package com.citruspay.citrusbrowser.core;

import android.text.TextUtils;

/**
 * CardDetails class is a POJO class which holds the Card details i.e. card number, Card prefix, card suffix and card token
 * Together these details are required to show the card number on the CitrusBrowser UI and for other use cases.
 * <p/>
 * Created by gautam on 8/16/16.
 */
public class CardDetails {

    private String mCardNumber = null;
    private String mCardPrefix = null;
    private String mCardSuffix = null;
    private String mCardToken = null;

    public CardDetails(String cardNumber, String cardPrefix, String cardSuffix, String cardToken) {
        this.mCardNumber = cardNumber;
        this.mCardPrefix = cardPrefix;
        this.mCardSuffix = cardSuffix;
        this.mCardToken = cardToken;
    }

    public CardDetails() {
    }

    public String getCardNumber() {
        if (!TextUtils.isEmpty(mCardNumber))
            return mCardNumber;
        else {
            return mCardPrefix + mCardSuffix;
        }
    }

    public void setCardNumber(String cardNumber) {
        this.mCardNumber = cardNumber;
    }

    public String getCardPrefix() {
        return mCardPrefix;
    }

    public void setCardPrefix(String cardPrefix) {
        this.mCardPrefix = cardPrefix;
    }

    public String getCardSuffix() {
        return mCardSuffix;
    }

    public void setCardSuffix(String cardSuffix) {
        this.mCardSuffix = cardSuffix;
    }

    public String getCardToken() {
        return mCardToken;
    }

    public void setCardToken(String cardToken) {
        this.mCardToken = cardToken;
    }
}
