/*
 * Decompiled with CFR 0.152.
 */
package com.citruspay.citrusbrowser.views;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;

public class DilatingDotDrawable
extends Drawable {
    private static final String TAG = DilatingDotDrawable.class.getSimpleName();
    private Paint mPaint = new Paint(1);
    private float radius;
    private float maxRadius;
    final Rect mDirtyBounds = new Rect(0, 0, 0, 0);

    public DilatingDotDrawable(int n, float f2, float f3) {
        this.mPaint.setColor(n);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mPaint.setStrokeJoin(Paint.Join.ROUND);
        this.radius = f2;
        this.setMaxRadius(f3);
    }

    public void draw(Canvas canvas) {
        Rect rect = this.getBounds();
        canvas.drawCircle((float)rect.centerX(), (float)rect.centerY(), this.radius - 1.0f, this.mPaint);
    }

    public void setAlpha(int n) {
        if (n != this.mPaint.getAlpha()) {
            this.mPaint.setAlpha(n);
            this.invalidateSelf();
        }
    }

    public void setColorFilter(ColorFilter colorFilter) {
        this.mPaint.setColorFilter(colorFilter);
        this.invalidateSelf();
    }

    public int getOpacity() {
        return -3;
    }

    public void setColor(int n) {
        this.mPaint.setColor(n);
        this.invalidateSelf();
    }

    public void setRadius(float f2) {
        this.radius = f2;
        this.invalidateSelf();
    }

    public float getRadius() {
        return this.radius;
    }

    public int getIntrinsicWidth() {
        return (int)(this.maxRadius * 2.0f) + 2;
    }

    public int getIntrinsicHeight() {
        return (int)(this.maxRadius * 2.0f) + 2;
    }

    public void setMaxRadius(float f2) {
        this.maxRadius = f2;
        this.mDirtyBounds.bottom = (int)(f2 * 2.0f) + 2;
        this.mDirtyBounds.right = (int)(f2 * 2.0f) + 2;
    }

    public Rect getDirtyBounds() {
        return this.mDirtyBounds;
    }

    protected void onBoundsChange(Rect rect) {
        super.onBoundsChange(rect);
        this.mDirtyBounds.offsetTo(rect.left, rect.top);
    }
}

