package com.citruspay.citrusbrowser.network;

import android.os.AsyncTask;
import android.text.TextUtils;

import com.citruspay.citrusbrowser.core.Callback;

import org.json.JSONObject;

/**
 * This class performs Bin service network call.
 * Created by Gautam on 16/6/16.
 */
public class BinRequest extends AsyncTask<String, String, JSONObject> {

    private Callback binResponseCallback = null;

    public BinRequest(Callback callback) {
        binResponseCallback = callback;
    }

    @Override
    protected void onPreExecute() {
        super.onPreExecute();

    }

    @Override
    protected JSONObject doInBackground(String... args) {
        String url = args[0];
        String replaceString = args[1];
        BinRequestParser binParser = new BinRequestParser();
        String requestUrl;
        if (!TextUtils.isEmpty(replaceString)) {

            requestUrl = url.replace("######", replaceString);
        } else {
            requestUrl = url;
        }

        // Getting JSON from URL
        JSONObject binJson = binParser.getJSONFromUrl(requestUrl);
        return binJson;
    }

    @Override
    protected void onPostExecute(JSONObject json) {
        if (json != null) {
            binResponseCallback.success(json);
        } else {
            binResponseCallback.error();
        }
    }

}