package com.citruspay.citrusbrowser.listener;

/**
 * This interface contains the event action to perform on the OTP Popup view.
 * <p>
 * Created by Gautam on 15/06/16.
 */
public interface OTPViewListener {

    /**
     * Send OTP Clicked event.
     */
    void onSendOtpClicked();

    /**
     * Enter Password Clicked event.
     */
    void onEnterPasswordClicked();

    /**
     * Cancel Clicked event.
     */
    void onCancelClicked();

    /**
     * Process OTP Txn event.
     *
     * @param otp
     */
    void onProcessTransactionClicked(String otp);

    /**
     * Resend OTP Clicked event.
     */
    void onResendOTPClicked();

    /**
     * Start OTP Read Timer.
     */
    void startOtpReadTimer();

    /**
     * Stop OTP read Timer.
     */
    void stopOtpReadTimer();

    /**
     * Dismiss OTP Popup event.
     */
    void dismissOTPPopup();

    /**
     * Process Password TXN event.
     *
     * @param password
     */
    void onEnteredPasswordConfirmed(String password);

    /**
     * On Back Pressed event.
     */
    void onBackPressed();

    /**
     * Display OTP error message.
     *
     * @param message
     */
    void displayOTPErrorMessage(String message);
}
