package com.citruspay.citrusbrowser.core;

import android.content.Context;

import com.citruspay.citrusbrowser.CitrusBrowserFragment;
import com.citruspay.citrusbrowser.listener.CitrusBrowserCallback;

import java.util.ArrayList;

/**
 * Created by gautam on 9/13/16.
 */
public class FlashPaymentTracker {

    private static FlashPaymentTracker mFlashPaymentTracker = null;
    private static CitrusBrowserFragment mCitrusBrowserFragment;
    private final Context mContext;
    private ArrayList<CitrusBrowserCallback> listeners = null;

    private FlashPaymentTracker(Context ctx) {
        this.mContext = ctx;
        this.listeners = new ArrayList<>();
    }

    /**
     * Get FlashPaymentTracker instance.
     *
     * @param context
     * @return
     */
    public static FlashPaymentTracker getInstance(Context context) {
        if (mFlashPaymentTracker == null) {
            synchronized (FlashPaymentTracker.class) {
                if (mFlashPaymentTracker == null) {
                    mFlashPaymentTracker = new FlashPaymentTracker(context);
                }
            }
        }
        return mFlashPaymentTracker;
    }

    public void flashListener(CitrusBrowserFragment citrusBrowserFragment) {
        mCitrusBrowserFragment = citrusBrowserFragment;
    }

    public void sendPaymentStatus(PaymentStatus paymentStatus) {
        if (mCitrusBrowserFragment != null)
            mCitrusBrowserFragment.displayFlashStatus(paymentStatus);
    }

    public void addListener(CitrusBrowserCallback callback) {
        if (listeners != null) {
            listeners.add(callback);
        }
    }

    public void notifyListeners(PaymentStatus status) {
        if (status == PaymentStatus.CANCELLED) {
            if (listeners != null) {
                for (int i = 0; i < listeners.size(); i++) {
                    listeners.get(i).txnCancelled();
                }
            }
        }
    }

    public void clear() {
        if (listeners != null)
            listeners.clear();
        if (mCitrusBrowserFragment != null)
            mCitrusBrowserFragment = null;
    }
}
