package com.citruspay.citrusbrowser.core;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;

/**
 * CardDetails class is a POJO class which holds the Card details i.e. card number, Card prefix, card suffix and card token
 * Together these details are required to show the card number on the CitrusBrowser UI and for other use cases.
 * <p/>
 * Created by gautam on 8/16/16.
 */
public class CardDetails implements Parcelable {

    private String mCardNumber = null;
    private String mCardPrefix = null;
    private String mCardSuffix = null;
    private String mCardToken = null;

    public CardDetails(String cardNumber, String cardPrefix, String cardSuffix, String cardToken) {
        this.mCardNumber = cardNumber;
        this.mCardPrefix = cardPrefix;
        this.mCardSuffix = cardSuffix;
        this.mCardToken = cardToken;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mCardNumber);
        dest.writeString(this.mCardPrefix);
        dest.writeString(this.mCardSuffix);
        dest.writeString(this.mCardToken);
    }

    public CardDetails() {
    }

    protected CardDetails(Parcel in) {
        this.mCardNumber = in.readString();
        this.mCardPrefix = in.readString();
        this.mCardSuffix = in.readString();
        this.mCardToken = in.readString();
    }

    public static final Creator<CardDetails> CREATOR = new Creator<CardDetails>() {
        @Override
        public CardDetails createFromParcel(Parcel source) {
            return new CardDetails(source);
        }

        @Override
        public CardDetails[] newArray(int size) {
            return new CardDetails[size];
        }
    };


    public String getCardNumber() {
        if (!TextUtils.isEmpty(mCardNumber))
            return mCardNumber;
        else {
            return mCardPrefix + mCardSuffix;
        }
    }

    public void setCardNumber(String cardNumber) {
        this.mCardNumber = cardNumber;
    }

    public String getCardPrefix() {
        return mCardPrefix;
    }

    public void setCardPrefix(String cardPrefix) {
        this.mCardPrefix = cardPrefix;
    }

    public String getCardSuffix() {
        return mCardSuffix;
    }

    public void setCardSuffix(String cardSuffix) {
        this.mCardSuffix = cardSuffix;
    }

    public String getCardToken() {
        return mCardToken;
    }

    public void setCardToken(String cardToken) {
        this.mCardToken = cardToken;
    }
}
