/*
 * Decompiled with CFR 0.152.
 */
package com.citruspay.graphics.helpers;

import android.content.Context;
import android.util.Log;
import com.citruspay.graphics.classes.PGSettingIdentifier;
import com.citruspay.graphics.enums.ScreenDensity;
import com.google.gson.Gson;

public class Utils {
    public static final String BASEURL = "https://s3.amazonaws.com/citruspay-sdk/assets/bank/";

    public static ScreenDensity getScreenDensity(Context context) {
        float density = context.getResources().getDisplayMetrics().density;
        Log.d((String)"DENSITY ***", (String)String.valueOf(density));
        if ((double)density >= 3.0) {
            return ScreenDensity.XXHDPI;
        }
        if ((double)density >= 2.0) {
            return ScreenDensity.XHDPI;
        }
        return ScreenDensity.HDPI;
    }

    public static PGSettingIdentifier getPGSettingIdentifier(String json) {
        Gson gson = new Gson();
        PGSettingIdentifier pgSettingIdentifier = (PGSettingIdentifier)gson.fromJson(json, PGSettingIdentifier.class);
        return pgSettingIdentifier;
    }

    public static String getURL(String CID, ScreenDensity screenDensity) {
        String density = screenDensity.name().toLowerCase();
        String finalURL = BASEURL + density + "/" + CID + ".png";
        return finalURL;
    }
}

