/*
 * Decompiled with CFR 0.152.
 */
package com.citruspay.graphics.helpers;

import android.content.Context;
import android.graphics.Bitmap;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.toolbox.ImageLoader;
import com.android.volley.toolbox.Volley;
import com.citruspay.graphics.helpers.DiskLruImageCache;

public class NetworkManager {
    private static int DISK_IMAGECACHE_SIZE = 0xA00000;
    private static Bitmap.CompressFormat DISK_IMAGECACHE_COMPRESS_FORMAT = Bitmap.CompressFormat.PNG;
    private static int DISK_IMAGECACHE_QUALITY = 100;
    private static NetworkManager mInstance;
    private RequestQueue mRequestQueue;
    private ImageLoader mImageLoader;
    private static Context mCtx;
    private String defaultICONURL;
    private ImageLoader.ImageCache mImageCache;

    public void setDefaultICONURL(String defaultICONURL) {
        this.defaultICONURL = defaultICONURL;
    }

    private NetworkManager(Context context) {
        mCtx = context;
        this.mRequestQueue = this.getRequestQueue();
        this.mImageCache = new DiskLruImageCache(mCtx, mCtx.getPackageCodePath(), DISK_IMAGECACHE_SIZE, DISK_IMAGECACHE_COMPRESS_FORMAT, DISK_IMAGECACHE_QUALITY);
        this.mImageLoader = new ImageLoader(Volley.newRequestQueue((Context)context), this.mImageCache);
    }

    public static synchronized NetworkManager getInstance(Context context) {
        if (mInstance == null) {
            mInstance = new NetworkManager(context);
        }
        return mInstance;
    }

    public RequestQueue getRequestQueue() {
        if (this.mRequestQueue == null) {
            this.mRequestQueue = Volley.newRequestQueue((Context)mCtx.getApplicationContext());
        }
        return this.mRequestQueue;
    }

    public Bitmap getBitmap(String url) {
        try {
            Bitmap bitmap = this.mImageCache.getBitmap(this.createKey(url));
            if (bitmap == null) {
                bitmap = this.mImageCache.getBitmap(this.defaultICONURL);
                return bitmap;
            }
            return bitmap;
        }
        catch (NullPointerException e) {
            throw new IllegalStateException("Disk Cache Not initialized");
        }
    }

    public void putBitmap(String url, Bitmap bitmap) {
        try {
            this.mImageCache.putBitmap(this.createKey(url), bitmap);
        }
        catch (NullPointerException e) {
            throw new IllegalStateException("Disk Cache Not initialized");
        }
    }

    public void clearCache() {
        if (this.mImageCache != null) {
            ((DiskLruImageCache)this.mImageCache).clearCache();
        }
    }

    private String createKey(String url) {
        return String.valueOf(url.hashCode());
    }

    public <T> void addToRequestQueue(Request<T> req) {
        this.getRequestQueue().add(req);
    }

    public ImageLoader getImageLoader() {
        return this.mImageLoader;
    }
}

