/*
 * Decompiled with CFR 0.152.
 */
package com.citruspay.graphics.helpers;

import android.content.Context;
import android.graphics.Bitmap;
import android.support.v4.util.LruCache;
import android.util.DisplayMetrics;
import com.android.volley.toolbox.ImageLoader;

public class LRUBitMapCache
extends LruCache<String, Bitmap>
implements ImageLoader.ImageCache {
    public LRUBitMapCache(int maxSize) {
        super(maxSize);
    }

    public LRUBitMapCache(Context ctx) {
        this(LRUBitMapCache.getCacheSize(ctx));
    }

    protected int sizeOf(String key, Bitmap value) {
        return value.getRowBytes() * value.getHeight();
    }

    public Bitmap getBitmap(String url) {
        return (Bitmap)this.get(url);
    }

    public void putBitmap(String url, Bitmap bitmap) {
        this.put(url, bitmap);
    }

    public static int getCacheSize(Context ctx) {
        DisplayMetrics displayMetrics = ctx.getResources().getDisplayMetrics();
        int screenWidth = displayMetrics.widthPixels;
        int screenHeight = displayMetrics.heightPixels;
        int screenBytes = screenWidth * screenHeight * 4;
        return screenBytes * 3;
    }
}

