/*
 * Decompiled with CFR 0.152.
 */
package com.citruspay.graphics;

import android.content.Context;
import android.graphics.Bitmap;
import android.util.Log;
import android.widget.ImageView;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.ImageLoader;
import com.android.volley.toolbox.JsonObjectRequest;
import com.citruspay.graphics.classes.NetBanking;
import com.citruspay.graphics.classes.PGSettingIdentifier;
import com.citruspay.graphics.enums.ScreenDensity;
import com.citruspay.graphics.helpers.NetworkManager;
import com.citruspay.graphics.helpers.Utils;
import java.util.HashSet;
import java.util.List;
import org.json.JSONObject;

public class AssetDownloadManager {
    private Context context = null;
    private String assetURL = null;
    private String configJSON = null;
    String REQUEST_TAG = "AssetDownloadManager";
    ScreenDensity mScreenDensity = null;
    Bitmap mBitmap = null;
    HashSet<String> failedResourceList;
    private NetworkManager mNetworkManager = null;
    private static AssetDownloadManager ourInstance = new AssetDownloadManager();

    public static AssetDownloadManager getInstance() {
        return ourInstance;
    }

    private AssetDownloadManager() {
    }

    public void init(Context context, String assetURL) {
        this.context = context;
        this.assetURL = assetURL;
        this.mNetworkManager = NetworkManager.getInstance(this.context);
        this.mScreenDensity = Utils.getScreenDensity(this.context);
        this.failedResourceList = new HashSet();
        this.downloadDefaultBank();
    }

    private void downloadDefaultBank() {
        final String defaultBankURL = Utils.getURL("CID000", this.mScreenDensity);
        Log.d((String)"DefaultBank", (String)defaultBankURL);
        this.mNetworkManager.getImageLoader().get(defaultBankURL, new ImageLoader.ImageListener(){

            public void onResponse(ImageLoader.ImageContainer response, boolean isImmediate) {
                Log.d((String)"Downloaded", (String)defaultBankURL);
                AssetDownloadManager.this.mBitmap = response.getBitmap();
                AssetDownloadManager.this.mNetworkManager.setDefaultICONURL(defaultBankURL);
            }

            public void onErrorResponse(VolleyError error) {
                Log.d((String)"failed***", (String)defaultBankURL);
            }
        });
    }

    public void downloadConfigJSON() {
        JsonObjectRequest jsonObjectReq = new JsonObjectRequest(this.assetURL, null, (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                Log.d((String)AssetDownloadManager.this.REQUEST_TAG, (String)response.toString());
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                Log.d((String)AssetDownloadManager.this.REQUEST_TAG, (String)error.toString());
            }
        });
        this.mNetworkManager.addToRequestQueue(jsonObjectReq);
    }

    public ImageLoader getImageLoader() {
        return this.mNetworkManager.getImageLoader();
    }

    public void getAllResources(String configJSON) {
        Log.d((String)"getAllResources", (String)"Started");
        this.configJSON = configJSON;
        PGSettingIdentifier pgSettingIdentifier = Utils.getPGSettingIdentifier(configJSON);
        List<NetBanking> netBankingList = pgSettingIdentifier.getNetBanking();
        for (final NetBanking netBanking : netBankingList) {
            if (this.failedResourceList.contains(netBanking.getIssuerCode())) continue;
            final String finalURL = Utils.getURL(netBanking.getIssuerCode(), this.mScreenDensity);
            this.mNetworkManager.getImageLoader().get(finalURL, new ImageLoader.ImageListener(){

                public void onResponse(ImageLoader.ImageContainer response, boolean isImmediate) {
                    Log.d((String)"Downloaded ****", (String)(finalURL + String.valueOf(isImmediate)));
                }

                public void onErrorResponse(VolleyError error) {
                    Log.d((String)"failed***", (String)netBanking.getIssuerCode());
                    AssetDownloadManager.this.failedResourceList.add(netBanking.getIssuerCode());
                }
            });
        }
    }

    public Bitmap getBitmap(String CID) {
        return this.mNetworkManager.getBitmap(Utils.getURL(CID, this.mScreenDensity));
    }

    public void updateDrawable(final String CID, final ImageView imageView) {
        if (this.failedResourceList.contains(CID)) {
            imageView.setImageBitmap(this.mBitmap);
        } else {
            this.mNetworkManager.getImageLoader().get(Utils.getURL(CID, this.mScreenDensity), new ImageLoader.ImageListener(){

                public void onResponse(ImageLoader.ImageContainer response, boolean isImmediate) {
                    Log.d((String)"updateDrawable", (String)("Setting Valid Image for BANK" + CID));
                    imageView.setImageBitmap(response.getBitmap());
                }

                public void onErrorResponse(VolleyError error) {
                    Log.d((String)"updateDrawable", (String)("Setting Default Image for BANK" + CID));
                    imageView.setImageBitmap(AssetDownloadManager.this.mBitmap);
                    AssetDownloadManager.this.failedResourceList.add(CID);
                }
            });
        }
    }

    public void clearCache() {
        this.mNetworkManager.clearCache();
    }
}

