/*
 * Decompiled with CFR 0.152.
 */
package com.citi.gradle.plugins.helm.publishing.dsl;

import com.citi.gradle.plugins.helm.dsl.credentials.internal.SerializableCredentials;
import com.citi.gradle.plugins.helm.dsl.credentials.internal.SerializableCredentialsKt;
import com.citi.gradle.plugins.helm.publishing.dsl.AbstractHelmPublishingRepository;
import com.citi.gradle.plugins.helm.publishing.dsl.NexusHelmPublishingRepository;
import com.citi.gradle.plugins.helm.publishing.publishers.AbstractHttpHelmChartPublisher;
import com.citi.gradle.plugins.helm.publishing.publishers.HelmChartPublisher;
import com.citi.gradle.plugins.helm.publishing.publishers.PublisherParams;
import com.citi.gradle.plugins.helm.publishing.util.RequestBodyExtensionsKt;
import java.io.File;
import java.net.URI;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import org.gradle.api.credentials.Credentials;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0012\u0018\u00002\u00020\u00012\u00020\u0002:\u0002\u0012\u0013B\u0017\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lcom/citi/gradle/plugins/helm/publishing/dsl/DefaultNexusHelmPublishingRepository;", "Lcom/citi/gradle/plugins/helm/publishing/dsl/AbstractHelmPublishingRepository;", "Lcom/citi/gradle/plugins/helm/publishing/dsl/NexusHelmPublishingRepository;", "name", "", "objects", "Lorg/gradle/api/model/ObjectFactory;", "(Ljava/lang/String;Lorg/gradle/api/model/ObjectFactory;)V", "apiVersion", "Lorg/gradle/api/provider/Property;", "getApiVersion", "()Lorg/gradle/api/provider/Property;", "publisherParams", "Lcom/citi/gradle/plugins/helm/publishing/publishers/PublisherParams;", "getPublisherParams", "()Lcom/citi/gradle/plugins/helm/publishing/publishers/PublisherParams;", "repository", "getRepository", "NexusPublisher", "NexusPublisherParams", "helm-publish-plugin"})
@SourceDebugExtension(value={"SMAP\nNexusHelmPublishingRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NexusHelmPublishingRepository.kt\ncom/citi/gradle/plugins/helm/publishing/dsl/DefaultNexusHelmPublishingRepository\n+ 2 ObjectFactoryExtensions.kt\norg/unbrokendome/gradle/pluginutils/ObjectFactoryExtensionsKt\n*L\n1#1,92:1\n17#2:93\n17#2:94\n*S KotlinDebug\n*F\n+ 1 NexusHelmPublishingRepository.kt\ncom/citi/gradle/plugins/helm/publishing/dsl/DefaultNexusHelmPublishingRepository\n*L\n41#1:93\n46#1:94\n*E\n"})
class DefaultNexusHelmPublishingRepository
extends AbstractHelmPublishingRepository
implements NexusHelmPublishingRepository {
    @NotNull
    private final Property<String> repository;
    @NotNull
    private final Property<String> apiVersion;

    @Inject
    public DefaultNexusHelmPublishingRepository(@NotNull String name, @NotNull ObjectFactory objects) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)objects, (String)"objects");
        super(objects, name);
        ObjectFactory $this$property$iv = objects;
        boolean $i$f$property = false;
        Property property = $this$property$iv.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"property(T::class.javaObjectType)");
        Property property2 = property.convention((Object)"");
        Intrinsics.checkNotNullExpressionValue((Object)property2, (String)"convention(...)");
        this.repository = property2;
        $this$property$iv = objects;
        $i$f$property = false;
        Property property3 = $this$property$iv.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property3, (String)"property(T::class.javaObjectType)");
        Property property4 = property3.convention((Object)"v1");
        Intrinsics.checkNotNullExpressionValue((Object)property4, (String)"convention(...)");
        this.apiVersion = property4;
    }

    @Override
    @NotNull
    public Property<String> getRepository() {
        return this.repository;
    }

    @Override
    @NotNull
    public Property<String> getApiVersion() {
        return this.apiVersion;
    }

    @Override
    @NotNull
    public PublisherParams getPublisherParams() {
        Object object = this.getUrl().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        URI uRI = (URI)object;
        Credentials credentials = (Credentials)this.getConfiguredCredentials().getOrNull();
        Object object2 = credentials != null ? SerializableCredentialsKt.toSerializable((Credentials)credentials) : null;
        Object object3 = this.getRepository().get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
        String string = (String)object3;
        Object object4 = this.getApiVersion().get();
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"get(...)");
        return new NexusPublisherParams(uRI, (SerializableCredentials)object2, string, (String)object4);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0018\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0007H\u0014R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u00078TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0014"}, d2={"Lcom/citi/gradle/plugins/helm/publishing/dsl/DefaultNexusHelmPublishingRepository$NexusPublisher;", "Lcom/citi/gradle/plugins/helm/publishing/publishers/AbstractHttpHelmChartPublisher;", "url", "Ljava/net/URI;", "credentials", "Lcom/citi/gradle/plugins/helm/dsl/credentials/internal/SerializableCredentials;", "repository", "", "apiVersion", "(Ljava/net/URI;Lcom/citi/gradle/plugins/helm/dsl/credentials/internal/SerializableCredentials;Ljava/lang/String;Ljava/lang/String;)V", "uploadMethod", "getUploadMethod", "()Ljava/lang/String;", "requestBody", "Lokhttp3/MultipartBody;", "chartFile", "Ljava/io/File;", "uploadPath", "chartName", "chartVersion", "helm-publish-plugin"})
    @SourceDebugExtension(value={"SMAP\nNexusHelmPublishingRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NexusHelmPublishingRepository.kt\ncom/citi/gradle/plugins/helm/publishing/dsl/DefaultNexusHelmPublishingRepository$NexusPublisher\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,92:1\n1#2:93\n*E\n"})
    private static final class NexusPublisher
    extends AbstractHttpHelmChartPublisher {
        @NotNull
        private final String repository;
        @NotNull
        private final String apiVersion;

        public NexusPublisher(@NotNull URI url, @Nullable SerializableCredentials credentials, @NotNull String repository, @NotNull String apiVersion) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            Intrinsics.checkNotNullParameter((Object)apiVersion, (String)"apiVersion");
            super(url, credentials);
            this.repository = repository;
            this.apiVersion = apiVersion;
        }

        @Override
        @NotNull
        protected String getUploadMethod() {
            return "POST";
        }

        @Override
        @NotNull
        protected String uploadPath(@NotNull String chartName, @NotNull String chartVersion) {
            String string;
            String string2;
            String it;
            String string3;
            Intrinsics.checkNotNullParameter((Object)chartName, (String)"chartName");
            Intrinsics.checkNotNullParameter((Object)chartVersion, (String)"chartVersion");
            String string4 = string3 = this.repository;
            StringBuilder stringBuilder = new StringBuilder().append("/service/rest/").append(this.apiVersion).append("/components");
            boolean bl = false;
            boolean bl2 = ((CharSequence)it).length() > 0;
            StringBuilder stringBuilder2 = stringBuilder;
            String string5 = bl2 ? string3 : null;
            if (string5 != null) {
                it = string5;
                stringBuilder = stringBuilder2;
                boolean bl3 = false;
                string2 = "?repository=" + it;
                stringBuilder2 = stringBuilder;
            } else {
                string2 = string = null;
            }
            if (string2 == null) {
                string = "";
            }
            return stringBuilder2.append(string).toString();
        }

        @NotNull
        protected MultipartBody requestBody(@NotNull File chartFile) {
            Intrinsics.checkNotNullParameter((Object)chartFile, (String)"chartFile");
            RequestBody requestBody = super.requestBody(chartFile);
            String string = chartFile.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            return RequestBodyExtensionsKt.toMultipartBody(requestBody, string);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/citi/gradle/plugins/helm/publishing/dsl/DefaultNexusHelmPublishingRepository$NexusPublisherParams;", "Lcom/citi/gradle/plugins/helm/publishing/publishers/PublisherParams;", "url", "Ljava/net/URI;", "credentials", "Lcom/citi/gradle/plugins/helm/dsl/credentials/internal/SerializableCredentials;", "repository", "", "apiVersion", "(Ljava/net/URI;Lcom/citi/gradle/plugins/helm/dsl/credentials/internal/SerializableCredentials;Ljava/lang/String;Ljava/lang/String;)V", "createPublisher", "Lcom/citi/gradle/plugins/helm/publishing/publishers/HelmChartPublisher;", "helm-publish-plugin"})
    private static final class NexusPublisherParams
    implements PublisherParams {
        @NotNull
        private final URI url;
        @Nullable
        private final SerializableCredentials credentials;
        @NotNull
        private final String repository;
        @NotNull
        private final String apiVersion;

        public NexusPublisherParams(@NotNull URI url, @Nullable SerializableCredentials credentials, @NotNull String repository, @NotNull String apiVersion) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            Intrinsics.checkNotNullParameter((Object)apiVersion, (String)"apiVersion");
            this.url = url;
            this.credentials = credentials;
            this.repository = repository;
            this.apiVersion = apiVersion;
        }

        @Override
        @NotNull
        public HelmChartPublisher createPublisher() {
            return new NexusPublisher(this.url, this.credentials, this.repository, this.apiVersion);
        }
    }
}

