/*
 * Decompiled with CFR 0.152.
 */
package com.chootdev.recycleclick;

import android.support.v7.widget.RecyclerView;
import android.view.View;
import com.chootdev.recycleclick.R;

public class RecycleClick {
    private final RecyclerView mRecyclerView;
    private OnItemClickListener mOnItemClickListener;
    private OnItemLongClickListener mOnItemLongClickListener;
    private View.OnClickListener mOnClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (RecycleClick.this.mOnItemClickListener != null) {
                RecyclerView.ViewHolder holder = RecycleClick.this.mRecyclerView.getChildViewHolder(v);
                RecycleClick.this.mOnItemClickListener.onItemClicked(RecycleClick.this.mRecyclerView, holder.getAdapterPosition(), v);
            }
        }
    };
    private View.OnLongClickListener mOnLongClickListener = new View.OnLongClickListener(){

        public boolean onLongClick(View v) {
            if (RecycleClick.this.mOnItemLongClickListener != null) {
                RecyclerView.ViewHolder holder = RecycleClick.this.mRecyclerView.getChildViewHolder(v);
                return RecycleClick.this.mOnItemLongClickListener.onItemLongClicked(RecycleClick.this.mRecyclerView, holder.getAdapterPosition(), v);
            }
            return false;
        }
    };
    private RecyclerView.OnChildAttachStateChangeListener mAttachListener = new RecyclerView.OnChildAttachStateChangeListener(){

        public void onChildViewAttachedToWindow(View view) {
            if (RecycleClick.this.mOnItemClickListener != null) {
                view.setOnClickListener(RecycleClick.this.mOnClickListener);
            }
            if (RecycleClick.this.mOnItemLongClickListener != null) {
                view.setOnLongClickListener(RecycleClick.this.mOnLongClickListener);
            }
        }

        public void onChildViewDetachedFromWindow(View view) {
        }
    };

    private RecycleClick(RecyclerView recyclerView) {
        this.mRecyclerView = recyclerView;
        this.mRecyclerView.setTag(R.id.item_click_support, (Object)this);
        this.mRecyclerView.addOnChildAttachStateChangeListener(this.mAttachListener);
    }

    public static RecycleClick addTo(RecyclerView view) {
        RecycleClick support = (RecycleClick)view.getTag(R.id.item_click_support);
        if (support == null) {
            support = new RecycleClick(view);
        }
        return support;
    }

    public static RecycleClick removeFrom(RecyclerView view) {
        RecycleClick support = (RecycleClick)view.getTag(R.id.item_click_support);
        if (support != null) {
            support.detach(view);
        }
        return support;
    }

    public RecycleClick setOnItemClickListener(OnItemClickListener listener) {
        this.mOnItemClickListener = listener;
        return this;
    }

    public RecycleClick setOnItemLongClickListener(OnItemLongClickListener listener) {
        this.mOnItemLongClickListener = listener;
        return this;
    }

    private void detach(RecyclerView view) {
        view.removeOnChildAttachStateChangeListener(this.mAttachListener);
        view.setTag(R.id.item_click_support, null);
    }

    public static interface OnItemLongClickListener {
        public boolean onItemLongClicked(RecyclerView var1, int var2, View var3);
    }

    public static interface OnItemClickListener {
        public void onItemClicked(RecyclerView var1, int var2, View var3);
    }
}

