/*
 * Decompiled with CFR 0.152.
 */
package com.chootdev.blurimg;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.renderscript.Allocation;
import android.renderscript.Element;
import android.renderscript.RenderScript;
import android.renderscript.ScriptIntrinsicBlur;
import android.widget.ImageView;
import com.squareup.picasso.Picasso;
import com.squareup.picasso.Target;

public class BlurImage {
    private static float BITMAP_SCALE = 0.4f;
    private static float BLUR_RADIUS = 7.5f;
    private static Context thiscontext;
    private static BlurImage blurImage;
    private static Bitmap blurFillImage;

    public static BlurImage withContext(Context context) {
        thiscontext = context;
        blurImage = new BlurImage();
        return blurImage;
    }

    public static BlurImage setBlurRadius(float radius) {
        BLUR_RADIUS = radius;
        return blurImage;
    }

    public static BlurImage setBitmapScale(float scale) {
        BITMAP_SCALE = scale;
        return blurImage;
    }

    public static BlurImage blurFromResource(int resource) {
        Bitmap bitmap = BitmapFactory.decodeResource((Resources)thiscontext.getResources(), (int)resource);
        BlurImage.blur(bitmap);
        return blurImage;
    }

    public static BlurImage blurFromUri(String imageUrl) {
        Picasso.with((Context)thiscontext).load(imageUrl).into(new Target(){

            public void onBitmapLoaded(Bitmap bitmap, Picasso.LoadedFrom from) {
                BlurImage.blur(bitmap);
                System.out.println("Test on load");
            }

            public void onBitmapFailed(Drawable errorDrawable) {
                System.out.println("Test on fail");
            }

            public void onPrepareLoad(Drawable placeHolderDrawable) {
                System.out.println("Test on pre load");
            }
        });
        return blurImage;
    }

    public static void into(ImageView imageView) {
        imageView.setBackground((Drawable)new BitmapDrawable(thiscontext.getResources(), blurFillImage));
    }

    public static BlurImage blur(Bitmap image) {
        int width = Math.round((float)image.getWidth() * BITMAP_SCALE);
        int height = Math.round((float)image.getHeight() * BITMAP_SCALE);
        Bitmap inputBitmap = Bitmap.createScaledBitmap((Bitmap)image, (int)width, (int)height, (boolean)false);
        Bitmap outputBitmap = Bitmap.createBitmap((Bitmap)inputBitmap);
        RenderScript rs = RenderScript.create((Context)thiscontext);
        ScriptIntrinsicBlur theIntrinsic = ScriptIntrinsicBlur.create((RenderScript)rs, (Element)Element.U8_4((RenderScript)rs));
        Allocation tmpIn = Allocation.createFromBitmap((RenderScript)rs, (Bitmap)inputBitmap);
        Allocation tmpOut = Allocation.createFromBitmap((RenderScript)rs, (Bitmap)outputBitmap);
        theIntrinsic.setRadius(BLUR_RADIUS);
        theIntrinsic.setInput(tmpIn);
        theIntrinsic.forEach(tmpOut);
        tmpOut.copyTo(outputBitmap);
        blurFillImage = outputBitmap;
        return blurImage;
    }
}

