/*
 * Decompiled with CFR 0.152.
 */
package com.chinazyjr.mylibrary.retrofit;

import android.content.Context;
import android.content.DialogInterface;
import android.os.Handler;
import android.os.Message;
import com.chinazyjr.mylibrary.retrofit.CustomProgressDialog;
import com.chinazyjr.mylibrary.retrofit.ProgressCancelListener;

public class ProgressDialogHandler
extends Handler {
    public static final int SHOW_PROGRESS_DIALOG = 1;
    public static final int DISMISS_PROGRESS_DIALOG = 2;
    private CustomProgressDialog pd;
    private Context context;
    private boolean cancelable;
    private ProgressCancelListener mProgressCancelListener;

    public ProgressDialogHandler(Context context, ProgressCancelListener mProgressCancelListener, boolean cancelable) {
        this.context = context;
        this.mProgressCancelListener = mProgressCancelListener;
        this.cancelable = cancelable;
    }

    private void initProgressDialog() {
        if (this.pd == null) {
            this.pd = CustomProgressDialog.createDialog(this.context);
            this.pd.setCancelable(this.cancelable);
            if (this.cancelable) {
                this.pd.setOnCancelListener(new DialogInterface.OnCancelListener(){

                    public void onCancel(DialogInterface dialogInterface) {
                        ProgressDialogHandler.this.mProgressCancelListener.onCancelProgress();
                    }
                });
            }
            if (!this.pd.isShowing()) {
                this.pd.show();
            }
        }
    }

    private void dismissProgressDialog() {
        if (this.pd != null) {
            this.pd.dismiss();
            this.pd = null;
        }
    }

    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                this.initProgressDialog();
                break;
            }
            case 2: {
                this.dismissProgressDialog();
            }
        }
    }
}

