/*
 * Decompiled with CFR 0.152.
 */
package com.chinazyjr.mylibrary.utils;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.AppOpsManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.Rect;
import android.net.Uri;
import android.net.http.SslError;
import android.os.Build;
import android.support.annotation.RequiresApi;
import android.support.design.widget.TabLayout;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.PermissionChecker;
import android.text.SpannableString;
import android.text.style.ForegroundColorSpan;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.webkit.SslErrorHandler;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceRequest;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.chinazyjr.mylibrary.base.ActivityCollector;
import com.chinazyjr.mylibrary.utils.LogUtils;
import com.chinazyjr.mylibrary.utils.UIUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.RoundingMode;
import java.text.DecimalFormat;

public class WYUtils {
    private static String phoneRex = "^1\\d{10}";
    private static String passRex = "^(?!^\\d+$)(?!^[a-zA-Z]+$)(?!^[\\-\\/:;()$&@\"\\.,\\?\\!'\\[\\]#%\\^\\*\\+=_\\\\\\|~<>\u20ac\u00a3\u00a5\u2022\uff1a\uff1b\uff08\uff09\u00a5@\u201c\u201d\u3002\uff0c\u3001\uff1f\uff01\u3010\u3011\uff5b\uff5d\u2014\u300a\u300b\\\u00b7]+$)[\\da-zA-Z\\-\\/:;()$&@\"\\.,\\?\\!'\\[\\]#%\\^\\*\\+=_\\\\\\|~<>\u20ac\u00a3\u00a5\u2022\uff1a\uff1b\uff08\uff09\u00a5@\u201c\u201d\u3002\uff0c\u3001\uff1f\uff01\u3010\u3011\uff5b\uff5d\u2014\u300a\u300b\\\u00b7]{6,20}$";
    private static String idRex = "(\\d{14}[0-9a-zA-Z])|(\\d{17}[0-9a-zA-Z])";
    private static String cardRex = "^\\d{16,19}$";
    private static String chn_characters = "([\\u4e00-\\u9fa5]{2,10})";
    private static String fma = "^[a-zA-Z0-9]{6}$";
    public static long exitTime = 0L;

    public static boolean checkPhone(String phone) {
        return phone.matches(phoneRex);
    }

    public static boolean checkPass(String password) {
        return password.matches(passRex);
    }

    public static boolean checkId(String id2) {
        return id2.matches(idRex);
    }

    public static boolean checkCard(String card) {
        return card.matches(cardRex);
    }

    public static boolean checkChnCharacters(String chnCharacters) {
        return chnCharacters.matches(chn_characters);
    }

    public static boolean checkFm(String fm) {
        return fm.matches(fma);
    }

    public static float processAmount(String string) {
        return Float.valueOf(string.replace(",", "")).floatValue();
    }

    public static String processAmountString(String string) {
        return string.replace(",", "");
    }

    public static boolean isApkInDebug(Context context) {
        try {
            ApplicationInfo info = context.getApplicationInfo();
            return (info.flags & 2) != 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void setIndicator(Context context, TabLayout tabs, int leftDip, int rightDip) {
        Class<?> tabLayout = tabs.getClass();
        Field tabStrip = null;
        try {
            tabStrip = tabLayout.getDeclaredField("mTabStrip");
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        tabStrip.setAccessible(true);
        LinearLayout ll_tab = null;
        try {
            ll_tab = (LinearLayout)tabStrip.get(tabs);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        int left = (int)(WYUtils.getDisplayMetrics((Context)context).density * (float)UIUtils.dp2px(leftDip, context));
        int right = (int)(WYUtils.getDisplayMetrics((Context)context).density * (float)UIUtils.dp2px(rightDip, context));
        for (int i = 0; i < ll_tab.getChildCount(); ++i) {
            View child = ll_tab.getChildAt(i);
            child.setPadding(0, 0, 0, 0);
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(0, -1, 1.0f);
            params.leftMargin = left;
            params.rightMargin = right;
            child.setLayoutParams((ViewGroup.LayoutParams)params);
            child.invalidate();
        }
    }

    private static DisplayMetrics getDisplayMetrics(Context context) {
        DisplayMetrics metric = new DisplayMetrics();
        ((Activity)context).getWindowManager().getDefaultDisplay().getMetrics(metric);
        return metric;
    }

    public static String getInvestDeadline(int num) {
        String result = "";
        switch (num) {
            case 1: {
                result = "\u5929";
                break;
            }
            case 2: {
                result = "\u5468";
                break;
            }
            case 3: {
                result = "\u4e2a\u6708";
                break;
            }
            case 4: {
                result = "\u5e74";
            }
        }
        return result;
    }

    public static String getPeriodUnit(String periodUnit) {
        String result = "";
        switch (periodUnit) {
            case "\u5929": {
                result = "1";
                break;
            }
            case "\u5468": {
                result = "2";
                break;
            }
            case "\u6708": {
                result = "3";
                break;
            }
            case "\u5e74": {
                result = "4";
            }
        }
        return result;
    }

    public static String getTwoNumStr(double num) {
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(2);
        df.setGroupingSize(0);
        df.setRoundingMode(RoundingMode.FLOOR);
        return df.format(num);
    }

    public static String getVersion(Context context) {
        try {
            PackageInfo pi = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            return pi.versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return "1.0";
        }
    }

    public static void loadHtml(final String url, WebView mWebView, final ProgressBar mProgressBar) {
        LogUtils.e("webViewUrl", url);
        WebSettings settings = mWebView.getSettings();
        if (Build.VERSION.SDK_INT >= 21) {
            mWebView.getSettings().setMixedContentMode(0);
        }
        mWebView.setDrawingCacheEnabled(true);
        settings.setJavaScriptEnabled(true);
        mWebView.setScrollBarStyle(0x2000000);
        mWebView.requestFocus();
        settings.setSavePassword(false);
        settings.setDefaultTextEncodingName("utf-8");
        settings.setLayoutAlgorithm(WebSettings.LayoutAlgorithm.SINGLE_COLUMN);
        settings.setLoadWithOverviewMode(true);
        settings.setUseWideViewPort(true);
        settings.setLayoutAlgorithm(WebSettings.LayoutAlgorithm.NARROW_COLUMNS);
        mWebView.loadUrl(url);
        mWebView.setWebChromeClient(new WebChromeClient(){

            public void onProgressChanged(WebView view, int newProgress) {
                if (newProgress == 100) {
                    mProgressBar.setVisibility(8);
                } else {
                    mProgressBar.setVisibility(0);
                }
            }
        });
        mWebView.setWebViewClient(new WebViewClient(){

            public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
                LogUtils.e("webViewUrl", url);
                view.loadUrl(url);
                return true;
            }

            public void onReceivedSslError(WebView view, SslErrorHandler handler, SslError error) {
                handler.proceed();
            }
        });
    }

    public static void setVisibility(TextView textView1, TextView textView2, TextView textView3, String str) {
        textView1.setVisibility(Double.valueOf(str) == 0.0 ? 8 : 0);
        textView2.setVisibility(Double.valueOf(str) == 0.0 ? 8 : 0);
        textView3.setVisibility(Double.valueOf(str) == 0.0 ? 8 : 0);
    }

    public static void serviceTel(Context context) {
        Uri uri = Uri.parse((String)"tel:4009996780");
        Intent intent = new Intent("android.intent.action.CALL", uri);
        if (ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.CALL_PHONE") == 0) {
            context.startActivity(intent);
        }
    }

    public static void CallPhone(Context context, int i) {
        if (Build.VERSION.SDK_INT >= 23) {
            if (PermissionChecker.checkSelfPermission((Context)context, (String)"android.permission.CALL_PHONE") != 0) {
                ActivityCompat.requestPermissions((Activity)((Activity)context), (String[])new String[]{"android.permission.CALL_PHONE"}, (int)i);
            } else {
                WYUtils.serviceTel(context);
            }
        } else {
            WYUtils.serviceTel(context);
        }
    }

    public static String getProfitPlan(int profitPlan) {
        String result = "";
        switch (profitPlan) {
            case 1: {
                result = "\u4e00\u6b21\u8fd8\u672c\u4ed8\u606f";
                break;
            }
            case 2: {
                result = "\u7b49\u989d\u672c\u91d1";
                break;
            }
            case 3: {
                result = "\u7b49\u989d\u672c\u606f";
                break;
            }
            case 4: {
                result = "\u6309\u671f\u4ed8\u606f\u5230\u671f\u8fd8\u672c";
            }
        }
        return result;
    }

    public static boolean isSoftShowing(Activity activity) {
        int screenHeight = activity.getWindow().getDecorView().getHeight();
        Rect rect = new Rect();
        activity.getWindow().getDecorView().getWindowVisibleDisplayFrame(rect);
        return screenHeight - rect.bottom - WYUtils.getSoftButtonsBarHeight(activity) != 0;
    }

    @TargetApi(value=17)
    private static int getSoftButtonsBarHeight(Activity activity) {
        DisplayMetrics metrics = new DisplayMetrics();
        activity.getWindowManager().getDefaultDisplay().getMetrics(metrics);
        int usableHeight = metrics.heightPixels;
        activity.getWindowManager().getDefaultDisplay().getRealMetrics(metrics);
        int realHeight = metrics.heightPixels;
        if (realHeight > usableHeight) {
            return realHeight - usableHeight;
        }
        return 0;
    }

    public static void showSoftPan(final EditText editText) {
        editText.postDelayed(new Runnable(){

            @Override
            public void run() {
                InputMethodManager inputManager = (InputMethodManager)editText.getContext().getSystemService("input_method");
                inputManager.showSoftInput((View)editText, 0);
            }
        }, 500L);
    }

    @RequiresApi(api=19)
    public static boolean isNotificationEnabled(Context context) {
        String CHECK_OP_NO_THROW = "checkOpNoThrow";
        String OP_POST_NOTIFICATION = "OP_POST_NOTIFICATION";
        AppOpsManager mAppOps = (AppOpsManager)context.getSystemService("appops");
        ApplicationInfo appInfo = context.getApplicationInfo();
        String pkg = context.getApplicationContext().getPackageName();
        int uid = appInfo.uid;
        Class<?> appOpsClass = null;
        try {
            appOpsClass = Class.forName(AppOpsManager.class.getName());
            Method checkOpNoThrowMethod = appOpsClass.getMethod(CHECK_OP_NO_THROW, Integer.TYPE, Integer.TYPE, String.class);
            Field opPostNotificationValue = appOpsClass.getDeclaredField(OP_POST_NOTIFICATION);
            int value = (Integer)opPostNotificationValue.get(Integer.class);
            return (Integer)checkOpNoThrowMethod.invoke((Object)mAppOps, value, uid, pkg) == 0;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static String getAppVersionName(Context context) {
        String versionName = "";
        try {
            PackageManager pm = context.getPackageManager();
            PackageInfo pi = pm.getPackageInfo(context.getPackageName(), 0);
            versionName = pi.versionName;
            int versioncode = pi.versionCode;
            if (versionName == null || versionName.length() <= 0) {
                return "";
            }
        }
        catch (Exception e) {
            Log.e((String)"VersionInfo", (String)"Exception", (Throwable)e);
        }
        return versionName;
    }

    public static boolean clickBack(int keyCode, KeyEvent event, Context context) {
        if (keyCode == 4 && event.getAction() == 0) {
            if (System.currentTimeMillis() - exitTime > 2000L) {
                UIUtils.showToastCommon(context, "\u518d\u6309\u4e00\u6b21\u9000\u51fa\u7a0b\u5e8f");
                exitTime = System.currentTimeMillis();
            } else {
                ActivityCollector.finishAll();
                System.exit(0);
            }
            return true;
        }
        return false;
    }

    public static void diffColor(TextView textView, String text, int start, int color) {
        SpannableString spannableString = new SpannableString((CharSequence)text);
        spannableString.setSpan((Object)new ForegroundColorSpan(color), start, spannableString.length(), 33);
        textView.setText((CharSequence)spannableString);
    }

    public static void diffColor(TextView textView, String text, int start, int end, int color) {
        SpannableString spannableString = new SpannableString((CharSequence)text);
        spannableString.setSpan((Object)new ForegroundColorSpan(color), start, end, 33);
        textView.setText((CharSequence)spannableString);
    }

    public static String secretPhone(String phone) {
        String left = phone.substring(0, 3);
        String right = phone.substring(phone.length() - 4, phone.length());
        return left + " **** " + right;
    }
}

