/*
 * Decompiled with CFR 0.152.
 */
package com.chinazyjr.mylibrary.utils;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.WindowManager;
import android.widget.Toast;

public class UIUtils {
    private static AlertDialog dialog;

    public static int dp2px(int dp, Context context) {
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    public static int sp2px(int sp, Context context) {
        return (int)TypedValue.applyDimension((int)2, (float)sp, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    public static int dip2px(Context context, int dip) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)((float)dip * scale + 0.5f);
    }

    public static int px2dip(Context context, int px) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)((float)px / scale + 0.5f);
    }

    public static View inflate(Context context, int resId) {
        return LayoutInflater.from((Context)context).inflate(resId, null);
    }

    public static Resources getResources(Context context) {
        return context.getResources();
    }

    public static String getString(Context context, int resId) {
        return context.getString(resId);
    }

    public static String[] getStringArray(Context context, int resId) {
        return context.getResources().getStringArray(resId);
    }

    public static int getDimens(Context context, int resId) {
        return context.getResources().getDimensionPixelSize(resId);
    }

    public static Drawable getDrawable(Context context, int resId) {
        return context.getResources().getDrawable(resId);
    }

    public static int getColor(Context context, int resId) {
        return context.getResources().getColor(resId);
    }

    public static void showToastCommon(Context context, String str) {
        Toast toast = Toast.makeText((Context)context, (CharSequence)str, (int)0);
        toast.setGravity(17, 0, 0);
        toast.show();
    }

    public static ColorStateList getColorStateList(Context context, int resId) {
        return context.getResources().getColorStateList(resId);
    }

    public static int getWidthPixes(Activity activity) {
        DisplayMetrics dm = new DisplayMetrics();
        activity.getWindowManager().getDefaultDisplay().getMetrics(dm);
        int widthPixels = dm.widthPixels;
        return widthPixels;
    }

    public static int[] getScreenDispaly(Context context) {
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        DisplayMetrics displayMetrics = new DisplayMetrics();
        windowManager.getDefaultDisplay().getMetrics(displayMetrics);
        int width = displayMetrics.widthPixels;
        int height = displayMetrics.heightPixels;
        int[] result = new int[]{width / 2, height / 2};
        return result;
    }
}

