/*
 * Decompiled with CFR 0.152.
 */
package com.chinazyjr.mylibrary.retrofit;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.graphics.drawable.AnimationDrawable;
import android.widget.ImageView;
import com.chinazyjr.mylibrary.R;

public class CustomProgressDialog
extends Dialog {
    private AnimationDrawable mAnimationDrawable;
    private static CustomProgressDialog mCustomProgressDialog = null;
    private static Context mContext;

    public CustomProgressDialog(Context context) {
        this(context, R.style.CustomProgressDialog);
    }

    public CustomProgressDialog(Context context, int theme) {
        super(context, theme);
        this.init();
    }

    private void init() {
        this.setContentView(R.layout.layout_custom_loading);
        this.getWindow().getAttributes().gravity = 17;
    }

    public void onWindowFocusChanged(boolean hasFocus) {
        super.onWindowFocusChanged(hasFocus);
        ImageView imageView = (ImageView)this.findViewById(R.id.iv_progress);
        imageView.setImageDrawable(mContext.getResources().getDrawable(R.drawable.anim_loading));
        this.mAnimationDrawable = (AnimationDrawable)imageView.getDrawable();
        this.mAnimationDrawable.start();
    }

    public static CustomProgressDialog createDialog(Context context) {
        mContext = context;
        mCustomProgressDialog = new CustomProgressDialog(context);
        mCustomProgressDialog.setCanceledOnTouchOutside(false);
        return mCustomProgressDialog;
    }

    public void dismiss() {
        super.dismiss();
        if (null != this.mAnimationDrawable) {
            this.mAnimationDrawable.stop();
        }
        this.mAnimationDrawable = null;
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (mContext != null && mContext instanceof Activity && mCustomProgressDialog != null && !((Activity)mContext).isFinishing()) {
            mCustomProgressDialog.dismiss();
        }
        mCustomProgressDialog = null;
        if (null != this.mAnimationDrawable) {
            this.mAnimationDrawable.stop();
        }
        this.mAnimationDrawable = null;
    }
}

