/*
 * Decompiled with CFR 0.152.
 */
package com.wakehao.bar.dot;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.app.Activity;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.drawable.AnimationDrawable;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.OvershootInterpolator;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.wakehao.bar.R;
import com.wakehao.bar.dot.DotView;
import com.wakehao.bar.dot.GeometryUtil;
import com.wakehao.bar.dot.Utils;

public class DragView
extends FrameLayout {
    private PointF dragCirclePoint;
    private Paint mDragPaint;
    private int statusBarHeight;
    private Context mContext;
    private PointF stillCirclePoint;
    private PointF middleBase;
    private String showNum = "";
    private float radius;
    private int textWidth;
    private int textHeight;
    private boolean isCanDraw;
    private float zoomedStillCircleRadius;
    private PointF[] stillPoint;
    private PointF[] dragPoint;
    private boolean isDisconnet;
    private boolean isDrawText;
    private boolean isShowDragCircle;
    private double slope;
    private float disconnectDistance = 70.0f;
    private ImageView boomImageView;
    private Handler handler = new Handler(){

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            DragView.this.destroy();
        }
    };
    private DotView mDotView;
    private long lastTime = 0L;

    public DragView(Context context) {
        this(context, null);
    }

    public DragView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public DragView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        this.init();
    }

    private void init() {
        ViewGroup.LayoutParams lp = new ViewGroup.LayoutParams(-1, -1);
        ((Activity)this.mContext).addContentView((View)this, lp);
        this.setBackgroundColor(0);
        this.dragCirclePoint = new PointF();
        this.mDragPaint = new Paint(1);
        this.mDragPaint.setColor(-65536);
        this.mDragPaint.setStyle(Paint.Style.FILL);
        this.mDragPaint.setTextSize(Utils.sp2px(this.mContext, 8.0f));
        this.stillCirclePoint = new PointF();
        this.boomImageView = new ImageView(this.mContext);
        this.boomImageView.setLayoutParams(new ViewGroup.LayoutParams(Utils.dip2px(this.mContext, 50.0f), Utils.dip2px(this.mContext, 50.0f)));
        this.boomImageView.setImageResource(R.drawable.drag_boom);
        this.boomImageView.setVisibility(4);
        this.addView((View)this.boomImageView);
    }

    public void removeOnTouchListener() {
        this.mDotView.setOnTouchListener(null);
    }

    public void rely(DotView relyView) {
        this.mDotView = relyView;
        if (relyView.isShowJustDot()) {
            return;
        }
        relyView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                switch (event.getAction()) {
                    case 0: {
                        DragView.this.getDotViewInfo((DotView)v);
                        DragView.this.updataPointF(DragView.this.stillCirclePoint, (float)((DotView)v).getCircleCenterOnRaw()[0] + DragView.this.radius, (float)((DotView)v).getCircleCenterOnRaw()[1] + DragView.this.radius);
                        DragView.this.isCanDraw = true;
                        v.setVisibility(8);
                        DragView.this.isDrawText = true;
                        DragView.this.refreshView();
                        break;
                    }
                    case 2: {
                        DragView.this.isDrawText = false;
                        DragView.this.isShowDragCircle = true;
                        DragView.this.dragCirclePoint.set(event.getRawX(), event.getRawY());
                        DragView.this.slope = (event.getRawY() - ((DragView)DragView.this).stillCirclePoint.y) / (event.getRawX() - ((DragView)DragView.this).stillCirclePoint.x);
                        DragView.this.calculatePath();
                        DragView.this.refreshView();
                        break;
                    }
                    case 1: {
                        if (DragView.this.isDisconnet) {
                            DragView.this.isCanDraw = false;
                            DragView.this.isShowDragCircle = false;
                            DragView.this.refreshView();
                            v.setVisibility(8);
                            DragView.this.showBoomAnim();
                            break;
                        }
                        DragView.this.showReBoundAnim(v);
                    }
                }
                return true;
            }
        });
    }

    private void showReBoundAnim(final View v) {
        final PointF tempDragCenter = new PointF(this.dragCirclePoint.x, this.dragCirclePoint.y);
        final ValueAnimator mAnim = ValueAnimator.ofFloat((float[])new float[]{1.0f});
        mAnim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator mAnim) {
                float percent = mAnim.getAnimatedFraction();
                PointF p = GeometryUtil.getPointByPercent(tempDragCenter, DragView.this.stillCirclePoint, percent);
                DragView.this.dragCirclePoint.set(p.x, p.y);
                DragView.access$1402(DragView.this, GeometryUtil.getIntersectionPoints(DragView.this.dragCirclePoint, DragView.this.radius, DragView.this.slope));
                DragView.this.middleBase = GeometryUtil.getMiddlePoint(DragView.this.stillCirclePoint, DragView.this.dragCirclePoint);
                DragView.this.refreshView();
            }
        });
        mAnim.setInterpolator((TimeInterpolator)new OvershootInterpolator(4.0f));
        mAnim.setDuration(500L);
        mAnim.start();
        mAnim.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animator) {
            }

            public void onAnimationEnd(Animator animator) {
                mAnim.removeListener((Animator.AnimatorListener)this);
                DragView.this.isCanDraw = false;
                DragView.this.isShowDragCircle = false;
                DragView.this.isDisconnet = false;
                v.setVisibility(0);
            }

            public void onAnimationCancel(Animator animator) {
            }

            public void onAnimationRepeat(Animator animator) {
            }
        });
    }

    private void showBoomAnim() {
        this.boomImageView.setX(this.dragCirclePoint.x - (float)(this.boomImageView.getWidth() / 2));
        this.boomImageView.setY(this.dragCirclePoint.y - (float)(this.boomImageView.getHeight() / 2) - (float)this.statusBarHeight);
        this.boomImageView.setVisibility(0);
        AnimationDrawable boom_drawable = (AnimationDrawable)this.boomImageView.getDrawable();
        boom_drawable.start();
        this.handler.sendEmptyMessageDelayed(1, 700L);
    }

    private void getDotViewInfo(DotView relyView) {
        this.showNum = relyView.getShowNum();
        this.radius = relyView.getRadius();
        this.textWidth = relyView.getNumWidth();
        this.textHeight = relyView.getNumHeight();
    }

    public void refreshView() {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            this.invalidate();
        } else {
            this.postInvalidate();
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.isCanDraw) {
            canvas.save();
            canvas.translate(0.0f, (float)(-this.statusBarHeight));
            if (!this.isDisconnet) {
                if (this.isShowDragCircle) {
                    this.paintStatueCircle();
                    canvas.drawCircle(this.stillCirclePoint.x, this.stillCirclePoint.y, this.zoomedStillCircleRadius, this.mDragPaint);
                    this.drawBPath(canvas);
                    this.drawDragCircle(canvas);
                } else {
                    this.paintStatueCircle();
                    canvas.drawCircle(this.stillCirclePoint.x, this.stillCirclePoint.y, this.radius, this.mDragPaint);
                }
                if (this.isDrawText) {
                    this.paintStatueText();
                    if (this.showNum.equals("1")) {
                        this.mDragPaint.setTextSize(Utils.sp2px(this.mContext, 9.0f));
                    }
                    canvas.drawText(this.showNum, this.stillCirclePoint.x - (float)(this.textWidth / 2) - (float)(this.showNum.contains("1") ? Utils.dip2px(this.mContext, 1.0f) : 0), this.stillCirclePoint.y + (float)(this.textHeight / 2), this.mDragPaint);
                }
            }
            if (this.isShowDragCircle) {
                this.drawDragCircle(canvas);
            }
            canvas.restore();
        }
    }

    private void drawDragCircle(Canvas canvas) {
        this.paintStatueCircle();
        canvas.drawCircle(this.dragCirclePoint.x, this.dragCirclePoint.y, this.radius, this.mDragPaint);
        this.paintStatueText();
        canvas.drawText(this.showNum, this.dragCirclePoint.x - (float)(this.textWidth / 2), this.dragCirclePoint.y + (float)(this.textHeight / 2), this.mDragPaint);
    }

    private void drawBPath(Canvas canvas) {
        Path path = new Path();
        path.moveTo(this.stillPoint[0].x, this.stillPoint[0].y);
        path.quadTo(this.middleBase.x, this.middleBase.y, this.dragPoint[0].x, this.dragPoint[0].y);
        path.lineTo(this.dragPoint[1].x, this.dragPoint[1].y);
        path.quadTo(this.middleBase.x, this.middleBase.y, this.stillPoint[1].x, this.stillPoint[1].y);
        path.close();
        canvas.drawPath(path, this.mDragPaint);
    }

    private void calculatePath() {
        if (this.middleBase == null) {
            this.middleBase = new PointF();
        }
        if (this.stillPoint == null) {
            this.stillPoint = new PointF[2];
        }
        if (this.dragPoint == null) {
            this.dragPoint = new PointF[2];
        }
        this.zoomedStillCircleRadius = this.getZoomedStillRadius();
        this.stillPoint = GeometryUtil.getIntersectionPoints(this.stillCirclePoint, this.zoomedStillCircleRadius, this.slope);
        this.dragPoint = GeometryUtil.getIntersectionPoints(this.dragCirclePoint, this.radius, this.slope);
        this.middleBase = GeometryUtil.getMiddlePoint(this.stillCirclePoint, this.dragCirclePoint);
    }

    private void paintStatueText() {
        if (this.mDragPaint.getColor() == -65536) {
            this.mDragPaint.setColor(-1);
            this.mDragPaint.setStyle(Paint.Style.FILL_AND_STROKE);
            this.mDragPaint.setStrokeWidth(1.0f);
        }
    }

    private void paintStatueCircle() {
        if (this.mDragPaint.getColor() == -1) {
            this.mDragPaint.setColor(-65536);
            this.mDragPaint.setStyle(Paint.Style.FILL);
        }
    }

    private float getZoomedStillRadius() {
        float currentDistance = GeometryUtil.getDistanceBetween2Points(this.stillCirclePoint, this.dragCirclePoint);
        if (currentDistance > this.disconnectDistance) {
            currentDistance = this.disconnectDistance;
            this.isDisconnet = true;
        } else {
            this.isDisconnet = false;
        }
        currentDistance = Math.min(currentDistance, this.disconnectDistance);
        float presnet = currentDistance / this.disconnectDistance;
        return this.envaluate(presnet, this.radius, 0.3f * this.radius);
    }

    public float envaluate(float present, float start, float end) {
        return start + (end - start) * present;
    }

    private void destroy() {
        if (this.handler != null) {
            this.handler.removeCallbacksAndMessages(null);
        }
        this.removeView((View)this.boomImageView);
        this.boomImageView = null;
        this.setVisibility(8);
        this.removeOnTouchListener();
        this.mContext = null;
    }

    public void onDestroy() {
        this.destroy();
    }

    public void disMissMes() {
        this.destroy();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.statusBarHeight = Utils.getStatusAndTitleBarHeight((View)this);
    }

    private void updataPointF(PointF pointF, float x, float y) {
        pointF.set(x, y);
    }

    static /* synthetic */ PointF[] access$1402(DragView x0, PointF[] x1) {
        x0.dragPoint = x1;
        return x1;
    }
}

