/*
 * Decompiled with CFR 0.152.
 */
package com.wakehao.bar;

import android.content.Context;
import android.content.res.XmlResourceParser;
import android.graphics.Color;
import android.support.annotation.XmlRes;
import android.support.v4.content.ContextCompat;
import com.wakehao.bar.BottomNavigationItemWithDot;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.xmlpull.v1.XmlPullParserException;

class ItemParser {
    private Context context;
    private List<BottomNavigationItemWithDot> items = new ArrayList<BottomNavigationItemWithDot>();
    private BottomNavigationItemWithDot item;
    private BottomNavigationItemWithDot.Config config;

    public ItemParser(Context context, BottomNavigationItemWithDot.Config config) {
        this.context = context;
        this.config = config;
    }

    public void parser(@XmlRes int res) {
        XmlResourceParser parser = this.context.getResources().getXml(res);
        try {
            parser.next();
            int eventType = parser.getEventType();
            while (eventType != 1) {
                if (eventType == 2 && parser.getName().equals("item")) {
                    this.parseItem(parser);
                } else if (eventType == 3 && parser.getName().equals("item") && this.item != null) {
                    this.items.add(this.item);
                    this.item = null;
                }
                eventType = parser.next();
            }
        }
        catch (XmlPullParserException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void parseItem(XmlResourceParser parser) {
        if (this.item == null) {
            this.item = this.getDefaultItem();
        }
        int attributeCount = parser.getAttributeCount();
        block16: for (int i = 0; i < attributeCount; ++i) {
            switch (parser.getAttributeName(i)) {
                case "id": {
                    continue block16;
                }
                case "icon": {
                    this.item.setIconRes(parser.getAttributeResourceValue(i, 0));
                    continue block16;
                }
                case "icon2": {
                    this.item.setIconResSelected(parser.getAttributeResourceValue(i, 0));
                    continue block16;
                }
                case "title": {
                    this.item.setTitle(this.getTitleText(i, parser));
                    continue block16;
                }
                case "shiftedColor": {
                    Integer shiftedColor = this.getColor(i, parser);
                    if (shiftedColor == null) continue block16;
                    this.item.setShiftedColor(shiftedColor);
                    continue block16;
                }
                case "fragment": {
                    String attributeValue = parser.getAttributeValue(i);
                    this.item.setFragment(attributeValue);
                }
            }
        }
    }

    private BottomNavigationItemWithDot getDefaultItem() {
        BottomNavigationItemWithDot bar = new BottomNavigationItemWithDot(this.context);
        bar.setConfig(this.config);
        return bar;
    }

    private String getTitleText(int attrIndex, XmlResourceParser parser) {
        int attributeResourceValue = parser.getAttributeResourceValue(attrIndex, 0);
        if (attributeResourceValue != 0) {
            return this.context.getString(attributeResourceValue);
        }
        return parser.getAttributeValue(attrIndex);
    }

    private Integer getColor(int i, XmlResourceParser parser) {
        int colorResourceValue = parser.getAttributeResourceValue(i, 0);
        if (colorResourceValue != 0) {
            return ContextCompat.getColor((Context)this.context, (int)colorResourceValue);
        }
        try {
            return Color.parseColor((String)parser.getAttributeValue(i));
        }
        catch (Exception e) {
            return null;
        }
    }

    public List<BottomNavigationItemWithDot> getBottomNavigationItems() {
        return this.items;
    }

    public int getItemCounts() {
        return this.items.size();
    }
}

