/*
 * Decompiled with CFR 0.152.
 */
package com.wakehao.bar;

import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.os.Looper;
import android.support.annotation.DrawableRes;
import android.support.annotation.IdRes;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentTransaction;
import android.support.v4.content.ContextCompat;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.ViewPropertyAnimatorCompat;
import android.support.v7.app.AppCompatActivity;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import com.wakehao.bar.BarUtils;
import com.wakehao.bar.BottomNavigationBar;
import com.wakehao.bar.R;
import com.wakehao.bar.dot.DotView;

public class BottomNavigationItemWithDot
extends FrameLayout {
    private DotView mDotView;
    private int dotTop;
    private boolean hasMesPoint;
    private String title;
    private int mShiftedColor;
    private String fragment;
    private int activeItemWidth;
    private int inActiveItemWidth;
    private boolean isViewPager;
    private boolean isSlide;
    private final long SHIFTING_TIME = 150L;
    private boolean canChangeBackColor;
    @DrawableRes
    private int iconRes;
    @DrawableRes
    private int iconRes2_selected;
    private ImageView mImageView;
    private TextView mTextView;
    final int mActiveMarginTop;
    private final int mScaleInactiveMarginTop;
    final int mShiftInactiveMarginTop;
    private final int mActiveMarginBottom;
    private final int mIconSize;
    private final int mActiveTextSize;
    private final int mInactiveTextSize;
    private int mPosition;
    private boolean isSelected;
    private boolean hasCorrect = true;
    private boolean initFinished;
    private Config config;
    private Fragment mFragment;
    private ImageView mImageView_selected;
    @IdRes
    private int containerId;
    private String tag;

    BottomNavigationItemWithDot(Context context) {
        super(context);
        Resources res = this.getResources();
        this.mActiveMarginTop = res.getDimensionPixelSize(R.dimen.item_active_marginTop);
        this.mScaleInactiveMarginTop = res.getDimensionPixelSize(R.dimen.item_scaleInactive_marginTop);
        this.mShiftInactiveMarginTop = res.getDimensionPixelSize(R.dimen.item_shiftInactive_marginTop);
        this.mActiveMarginBottom = res.getDimensionPixelSize(R.dimen.item_active_marginBottom);
        this.mIconSize = res.getDimensionPixelSize(R.dimen.item_icon_size);
        this.mActiveTextSize = res.getDimensionPixelSize(R.dimen.item_active_text_size);
        this.mInactiveTextSize = res.getDimensionPixelSize(R.dimen.item_inactive_text_size);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.mDotView.layout(this.getWidth() / 2 + BarUtils.dip2px(this.getContext(), 6.0f), this.dotTop, this.getWidth() / 2 + BarUtils.dip2px(this.getContext(), 6.0f) + this.mDotView.getWidth(), this.dotTop + this.mDotView.getHeight());
    }

    void showNum(int num) {
        this.hasMesPoint = true;
        this.mDotView.showNum(num);
    }

    void disMissMes() {
        if (!this.hasMesPoint) {
            return;
        }
        this.hasMesPoint = false;
        this.mDotView.disMisMes();
    }

    void setDotTop(int dotTop) {
        if (!this.hasMesPoint) {
            return;
        }
        this.dotTop = dotTop;
    }

    void alphaAnim(float positionOffset) {
        if (this.isSlide) {
            this.iconColorChange(positionOffset);
            if (this.config.switchMode == 1) {
                this.updateItemWidth((float)this.activeItemWidth - (float)(this.activeItemWidth - this.inActiveItemWidth) * positionOffset);
                this.updateIconMarginTop((float)this.mActiveMarginTop + (float)(this.mShiftInactiveMarginTop - this.mActiveMarginTop) * positionOffset);
                this.setDotTop((int)((float)this.mActiveMarginTop + (float)(this.mShiftInactiveMarginTop - this.mActiveMarginTop) * positionOffset));
                this.mTextView.setScaleX(1.0f - positionOffset);
                this.mTextView.setScaleY(1.0f - positionOffset);
            } else if (this.config.switchMode == 0) {
                this.updateIconMarginTop((float)this.mActiveMarginTop + (float)(this.mScaleInactiveMarginTop - this.mActiveMarginTop) * positionOffset);
                this.setDotTop((int)((float)this.mActiveMarginTop + (float)(this.mScaleInactiveMarginTop - this.mActiveMarginTop) * positionOffset));
                this.mTextView.setScaleX(1.1666666f - positionOffset / 6.0f);
                this.mTextView.setScaleY(1.1666666f - positionOffset / 6.0f);
            }
        }
    }

    private void updateIconMarginTop(float top) {
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)this.mImageView.getLayoutParams();
        layoutParams.topMargin = (int)top;
        this.mImageView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        if (this.mImageView_selected != null) {
            this.mImageView_selected.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
    }

    private void iconColorChange(float positionOffset) {
        int iconColor = BarUtils.getIconColor(positionOffset, 0, this.config.activeColor, this.config.inActiveColor, 10);
        this.mImageView.setColorFilter(iconColor, PorterDuff.Mode.SRC_IN);
        int iconColor1 = BarUtils.getIconColor(positionOffset, this.config.activeColor, 0, 0, 10);
        this.mImageView_selected.setColorFilter(iconColor1, PorterDuff.Mode.SRC_IN);
        this.mTextView.setTextColor(BarUtils.getOffsetColor(positionOffset, this.config.activeColor, this.config.inActiveColor, 10));
    }

    void correctItem(boolean isSelected) {
        if (this.canChangeBackColor) {
            ((BottomNavigationBar)this.getParent().getParent()).correctBackColor();
        }
        this.setSelected(isSelected, false);
        if (this.config.switchMode == 1) {
            this.updateItemWidth(isSelected ? (float)this.activeItemWidth : (float)this.inActiveItemWidth);
            FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)this.mImageView.getLayoutParams();
            layoutParams.topMargin = isSelected ? this.mActiveMarginTop : this.mShiftInactiveMarginTop;
            this.setDotTop(isSelected ? this.mActiveMarginTop : this.mShiftInactiveMarginTop);
            this.mImageView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            if (this.mImageView_selected != null) {
                this.mImageView_selected.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            }
            this.mTextView.setScaleX(isSelected ? 1.0f : 0.0f);
            this.mTextView.setScaleY(isSelected ? 1.0f : 0.0f);
        } else if (this.config.switchMode == 0) {
            FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)this.mImageView.getLayoutParams();
            layoutParams.topMargin = isSelected ? this.mActiveMarginTop : this.mScaleInactiveMarginTop;
            this.setDotTop(isSelected ? this.mActiveMarginTop : this.mScaleInactiveMarginTop);
            this.mImageView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            if (this.mImageView_selected != null) {
                this.mImageView_selected.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            }
            this.mTextView.setScaleX(isSelected ? 1.1666666f : 1.0f);
            this.mTextView.setScaleY(isSelected ? 1.1666666f : 1.0f);
        }
    }

    private void updateItemWidth(float currentWidth) {
        ViewGroup.LayoutParams params = this.getLayoutParams();
        if (params == null) {
            return;
        }
        params.width = Math.round(currentWidth);
        this.setLayoutParams(params);
    }

    void setSelected(boolean isSelected, boolean isAnim) {
        this.isSelected = isSelected;
        this.hasCorrect = true;
        this.updateState(isAnim);
    }

    private void initDefaultOption() {
        if (this.isSlide && this.iconRes2_selected == 0) {
            throw new RuntimeException("you need provide 2 pictures in Slide mode at least");
        }
        if (this.mPosition == 0) {
            this.isSelected = true;
        }
        if (this.mShiftedColor != 0 && this.canChangeBackColor && this.isSelected) {
            ((BottomNavigationBar)this.getParent().getParent()).setFirstItemBackgroundColor(this.mShiftedColor);
        }
        this.addImageAndText();
    }

    private void setItemBackground(int background) {
        Drawable backgroundDrawable = background == 0 ? null : ContextCompat.getDrawable((Context)this.getContext(), (int)background);
        ViewCompat.setBackground((View)this, (Drawable)backgroundDrawable);
    }

    private void addImageAndText() {
        FrameLayout.LayoutParams layoutParams;
        BottomNavigationItemWithDot.inflate((Context)this.getContext(), (int)this.getLayoutRes(), (ViewGroup)this);
        this.mImageView = (ImageView)this.findViewById(R.id.bar_image);
        this.mTextView = (TextView)this.findViewById(R.id.bar_title);
        this.mImageView.setImageResource(this.iconRes);
        this.mTextView.setText((CharSequence)this.title);
        this.mDotView = new DotView(this.getContext());
        this.addView(this.mDotView);
        if (this.iconRes2_selected != 0) {
            this.mImageView_selected = (ImageView)this.findViewById(R.id.bar_image_selected);
            this.mImageView_selected.setImageResource(this.iconRes2_selected);
        }
        if (this.isSelected) {
            this.mImageView.setColorFilter(0, PorterDuff.Mode.SRC_IN);
            if (this.mImageView_selected != null) {
                this.mImageView_selected.setColorFilter(this.config.activeColor, PorterDuff.Mode.SRC_IN);
            }
            layoutParams = (FrameLayout.LayoutParams)this.mImageView.getLayoutParams();
            layoutParams.topMargin = this.mActiveMarginTop;
            if (this.mImageView_selected != null) {
                this.mImageView_selected.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            }
        } else if (this.mImageView_selected != null) {
            this.mImageView_selected.setColorFilter(0, PorterDuff.Mode.SRC_IN);
        }
        switch (this.config.switchMode) {
            case 1: {
                if (this.isSelected) {
                    this.mTextView.setScaleX(1.0f);
                    this.mTextView.setScaleY(1.0f);
                    layoutParams = (FrameLayout.LayoutParams)this.mImageView.getLayoutParams();
                    layoutParams.topMargin = this.mActiveMarginTop;
                    this.mImageView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                }
                this.dotTop = this.isSelected ? this.mActiveMarginTop : this.mShiftInactiveMarginTop;
                break;
            }
            case 0: {
                if (this.isSelected) {
                    ViewCompat.setScaleX((View)this.mTextView, (float)1.1666666f);
                    ViewCompat.setScaleY((View)this.mTextView, (float)1.1666666f);
                    layoutParams = (FrameLayout.LayoutParams)this.mImageView.getLayoutParams();
                    layoutParams.topMargin = this.mActiveMarginTop;
                    this.mImageView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                }
                if (!this.canChangeBackColor) {
                    this.setItemBackground(this.config.itemBackGroundRes);
                }
                this.dotTop = this.isSelected ? this.mActiveMarginTop : this.mScaleInactiveMarginTop;
                break;
            }
            case 2: {
                this.dotTop = this.mActiveMarginTop;
                if (this.canChangeBackColor) break;
                this.setItemBackground(this.config.itemBackGroundRes);
            }
        }
        if (!this.isViewPager) {
            this.switchFragment(this.isSelected);
        }
        this.mTextView.setTextColor(this.isSelected ? this.config.activeColor : this.config.inActiveColor);
        this.tintImageColor(this.mImageView, this.isSelected ? this.config.activeColor : this.config.inActiveColor);
    }

    private void updateState(boolean isAnim) {
        this.mTextView.setTextColor(this.isSelected ? this.config.activeColor : this.config.inActiveColor);
        if (this.isSlide || this.iconRes2_selected != 0) {
            if (this.isSelected) {
                this.mImageView.setColorFilter(0, PorterDuff.Mode.SRC_IN);
                this.mImageView_selected.setColorFilter(this.config.activeColor, PorterDuff.Mode.SRC_IN);
            } else {
                this.mImageView_selected.setColorFilter(0, PorterDuff.Mode.SRC_IN);
                this.mImageView.setColorFilter(this.config.inActiveColor, PorterDuff.Mode.SRC_IN);
            }
        } else {
            this.tintImageColor(this.mImageView, this.isSelected ? this.config.activeColor : this.config.inActiveColor);
        }
        if (!this.isViewPager) {
            this.switchFragment(this.isSelected);
        }
        if (!isAnim) {
            return;
        }
        switch (this.config.switchMode) {
            case 0: {
                this.scaleAnim();
                break;
            }
            case 1: {
                this.shiftAnim();
                break;
            }
        }
    }

    private void scaleAnim() {
        float end;
        float start;
        if (this.isSelected) {
            start = this.mScaleInactiveMarginTop;
            end = this.mActiveMarginTop;
        } else {
            start = this.mActiveMarginTop;
            end = this.mScaleInactiveMarginTop;
        }
        ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{start, end});
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float marginTop = ((Float)animation.getAnimatedValue()).floatValue();
                FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)BottomNavigationItemWithDot.this.mImageView.getLayoutParams();
                layoutParams.topMargin = (int)marginTop;
                BottomNavigationItemWithDot.this.mImageView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                if (BottomNavigationItemWithDot.this.mImageView_selected != null) {
                    BottomNavigationItemWithDot.this.mImageView_selected.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                }
                BottomNavigationItemWithDot.this.setDotTop((int)marginTop);
            }
        });
        valueAnimator.setDuration(150L);
        valueAnimator.start();
        ViewPropertyAnimatorCompat titleAnimator = ViewCompat.animate((View)this.mTextView).setDuration(150L).scaleX(this.isSelected ? 1.1666666f : 1.0f).scaleY(this.isSelected ? 1.1666666f : 1.0f);
        titleAnimator.start();
    }

    private void shiftAnim() {
        if (this.activeItemWidth == this.inActiveItemWidth) {
            return;
        }
        this.updateItemWidth();
    }

    private void updateItemWidth() {
        final FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)this.mImageView.getLayoutParams();
        ValueAnimator valueAnimator = this.isSelected ? ValueAnimator.ofFloat((float[])new float[]{this.getWidth(), this.activeItemWidth}) : ValueAnimator.ofFloat((float[])new float[]{this.getWidth(), this.inActiveItemWidth});
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                ViewGroup.LayoutParams params = BottomNavigationItemWithDot.this.getLayoutParams();
                if (params == null) {
                    return;
                }
                params.width = Math.round(((Float)animation.getAnimatedValue()).floatValue());
                BottomNavigationItemWithDot.this.setLayoutParams(params);
                float offset = animation.getAnimatedFraction();
                if (BottomNavigationItemWithDot.this.isSelected) {
                    int marginTop;
                    layoutParams.topMargin = marginTop = BottomNavigationItemWithDot.this.mShiftInactiveMarginTop - (int)((float)(BottomNavigationItemWithDot.this.mShiftInactiveMarginTop - BottomNavigationItemWithDot.this.mActiveMarginTop) * animation.getAnimatedFraction());
                    BottomNavigationItemWithDot.this.mTextView.setScaleX(offset);
                    BottomNavigationItemWithDot.this.mTextView.setScaleY(offset);
                    BottomNavigationItemWithDot.this.setDotTop(marginTop);
                } else {
                    int marginTop;
                    layoutParams.topMargin = marginTop = BottomNavigationItemWithDot.this.mActiveMarginTop + (int)((float)(BottomNavigationItemWithDot.this.mShiftInactiveMarginTop - BottomNavigationItemWithDot.this.mActiveMarginTop) * animation.getAnimatedFraction());
                    BottomNavigationItemWithDot.this.mTextView.setScaleX(1.0f - offset);
                    BottomNavigationItemWithDot.this.mTextView.setScaleY(1.0f - offset);
                    BottomNavigationItemWithDot.this.setDotTop(marginTop);
                }
                BottomNavigationItemWithDot.this.mImageView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                if (BottomNavigationItemWithDot.this.mImageView_selected != null) {
                    BottomNavigationItemWithDot.this.mImageView_selected.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                }
            }
        });
        valueAnimator.setDuration(150L);
        valueAnimator.start();
    }

    private void refreshView() {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            this.invalidate();
        } else {
            this.postInvalidate();
        }
    }

    void setFragment(String fragmentPackageName) {
        if (TextUtils.isEmpty((CharSequence)this.tag)) {
            this.tag = fragmentPackageName;
        }
        this.mFragment = this.getActivity().getSupportFragmentManager().findFragmentByTag(fragmentPackageName);
        if (this.mFragment != null) {
            this.getActivity().getSupportFragmentManager().beginTransaction().hide(this.mFragment).commitAllowingStateLoss();
        } else {
            try {
                Class<?> aClass = Class.forName(fragmentPackageName);
                this.mFragment = (Fragment)aClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                throw new RuntimeException("you may provide a wrong fragment's packageName");
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    private AppCompatActivity getActivity() {
        return (AppCompatActivity)this.getContext();
    }

    private void switchFragment(boolean isSelected) {
        if (this.mFragment == null) {
            return;
        }
        FragmentTransaction fragmentTransaction = ((AppCompatActivity)this.getContext()).getSupportFragmentManager().beginTransaction();
        if (!isSelected) {
            if (this.mFragment.isAdded()) {
                fragmentTransaction.hide(this.mFragment);
            }
        } else if (this.mFragment.isAdded()) {
            fragmentTransaction.show(this.mFragment);
        } else {
            fragmentTransaction.add(this.getContainerId(), this.mFragment, this.tag);
        }
        fragmentTransaction.commitAllowingStateLoss();
    }

    @IdRes
    private int getContainerId() {
        if (this.containerId != 0) {
            return this.containerId;
        }
        this.containerId = ((BottomNavigationBar)this.getParent().getParent()).getContainerId();
        return this.containerId;
    }

    private void tintImageColor(ImageView imageView, int color) {
        imageView.setColorFilter(color, PorterDuff.Mode.SRC_IN);
    }

    private int getLayoutRes() {
        int res = 0;
        switch (this.config.switchMode) {
            case 0: {
                res = R.layout.bar_scale;
                break;
            }
            case 1: {
                res = R.layout.bar_shfit;
                break;
            }
            case 2: {
                res = R.layout.bar_still;
            }
        }
        return res;
    }

    void setPosition(int mPosition) {
        this.mPosition = mPosition;
    }

    Fragment getFragment() {
        if (this.mFragment == null) {
            throw new RuntimeException("the fragment is null");
        }
        return this.mFragment;
    }

    boolean isHasCorrect() {
        return this.hasCorrect;
    }

    void setConfig(Config config) {
        this.config = config;
    }

    void setIconRes(int iconRes) {
        this.iconRes = iconRes;
    }

    void setIconResSelected(int iconResSelected) {
        this.iconRes2_selected = iconResSelected;
    }

    void setTitle(String title) {
        this.title = title;
    }

    void changeTitle(String title) {
        this.title = title;
        this.mTextView.setText((CharSequence)title);
    }

    void setShiftedColor(int mShiftedColor) {
        this.mShiftedColor = mShiftedColor;
    }

    int getPosition() {
        return this.mPosition;
    }

    int getShiftedColor() {
        return this.mShiftedColor;
    }

    void setActiveItemWidth(int activeItemWidth) {
        this.activeItemWidth = activeItemWidth;
    }

    void setInActiveItemWidth(int inActiveItemWidth) {
        this.inActiveItemWidth = inActiveItemWidth;
    }

    void setIsViewPager(boolean isViewPager) {
        this.isViewPager = isViewPager;
    }

    void finishInit() {
        this.initFinished = true;
        this.initDefaultOption();
    }

    BottomNavigationItemWithDot setHasCorrect(boolean hasCorrect) {
        this.hasCorrect = hasCorrect;
        return this;
    }

    void setSlide(boolean slide) {
        this.isSlide = slide;
    }

    void setCanChangeBackColor(boolean canChangeBackColor) {
        this.canChangeBackColor = canChangeBackColor;
    }

    static class Config {
        private int activeColor;
        private int inActiveColor;
        private int itemBackGroundRes;
        private int switchMode;
        private boolean isSlide;

        Config(Build build) {
            this.activeColor = build.activeColor;
            this.inActiveColor = build.inActiveColor;
            this.itemBackGroundRes = build.itemBackGroundRes;
            this.switchMode = build.switchMode;
            this.isSlide = build.isSlide;
        }

        public int getSwitchMode() {
            return this.switchMode;
        }

        public static class Build {
            private int activeColor;
            private int inActiveColor;
            private int itemBackGroundRes;
            private int switchMode;
            private boolean isSlide;

            public Build setActiveColor(int activeColor) {
                this.activeColor = activeColor;
                return this;
            }

            public Build setInActiveColor(int inActiveColor) {
                this.inActiveColor = inActiveColor;
                return this;
            }

            public Build setItemBackGroundRes(int itemBackGroundRes) {
                this.itemBackGroundRes = itemBackGroundRes;
                return this;
            }

            public Build setSwitchMode(int switchMode) {
                this.switchMode = switchMode;
                return this;
            }

            public Build setIsSlide(boolean isSlide) {
                this.isSlide = isSlide;
                return this;
            }

            public Config build() {
                return new Config(this);
            }
        }
    }
}

