/*
 * Decompiled with CFR 0.152.
 */
package com.wakehao.bar;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.os.Build;
import android.os.Looper;
import android.support.annotation.IdRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentPagerAdapter;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.ViewPager;
import android.support.v7.app.AppCompatActivity;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewAnimationUtils;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import com.transitionseverywhere.Fade;
import com.transitionseverywhere.Slide;
import com.transitionseverywhere.Transition;
import com.transitionseverywhere.TransitionManager;
import com.wakehao.bar.BarUtils;
import com.wakehao.bar.BottomNavigationBarContent;
import com.wakehao.bar.BottomNavigationItemWithDot;
import com.wakehao.bar.ItemParser;
import com.wakehao.bar.R;

public class BottomNavigationBar
extends FrameLayout {
    private BottomNavigationBarContent mBottomNavigationBarContent;
    private int itemBackGroundRes;
    private int mSwitchMode;
    private float maxRadius;
    private float currentRadius = 0.0f;
    private Paint mPaint;
    private View circleView;
    private int activeColor;
    private int inActiveColor;
    private boolean isSlide;
    @IdRes
    private int containerId;
    private int itemCounts;
    private int viewpagerId;
    private ViewPager viewpager;
    private boolean canChangeBackColor = true;
    protected boolean isMoving;
    protected boolean isBackMoving;
    protected float offset;
    private float downX;
    private float downY;
    private int shiftedColor;
    private boolean isStart;
    private boolean isInflated;

    public BottomNavigationBar(Context context) {
        super(context, null);
    }

    public BottomNavigationBar(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BottomNavigationBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        if (Build.VERSION.SDK_INT < 21) {
            View shadowView = new View(context);
            shadowView.setBackgroundResource(R.drawable.shadow);
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, BarUtils.dip2px(context, 1.0f));
            this.addView(shadowView, (ViewGroup.LayoutParams)layoutParams);
        } else {
            this.circleView = new View(context);
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
            this.addView(this.circleView, (ViewGroup.LayoutParams)layoutParams);
        }
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.BottomNavigationBar, defStyleAttr, R.style.BottomNavigationView);
        if (typedArray.hasValue(R.styleable.BottomNavigationBar_switchMode)) {
            this.mSwitchMode = typedArray.getInt(R.styleable.BottomNavigationBar_switchMode, 0);
        }
        if (typedArray.hasValue(R.styleable.BottomNavigationBar_barElevation)) {
            this.setBackgroundColor(-1);
            ViewCompat.setElevation((View)this, (float)typedArray.getDimensionPixelSize(R.styleable.BottomNavigationBar_barElevation, 0));
        }
        if (typedArray.hasValue(R.styleable.BottomNavigationBar_fragmentContainerId)) {
            this.containerId = typedArray.getResourceId(R.styleable.BottomNavigationBar_fragmentContainerId, 0);
        }
        if (typedArray.hasValue(R.styleable.BottomNavigationBar_viewpagerId)) {
            this.viewpagerId = typedArray.getResourceId(R.styleable.BottomNavigationBar_viewpagerId, 0);
            this.isSlide = this.viewpagerId != 0;
        }
        this.itemBackGroundRes = typedArray.getResourceId(R.styleable.BottomNavigationBar_itemBackground, 0);
        this.activeColor = typedArray.getColor(R.styleable.BottomNavigationBar_selectedColor, BarUtils.getAppColorPrimary(context));
        this.inActiveColor = typedArray.getColor(R.styleable.BottomNavigationBar_unSelectedColor, -7829368);
        this.isSlide = typedArray.getBoolean(R.styleable.BottomNavigationBar_isSlide, false);
        if (typedArray.hasValue(R.styleable.BottomNavigationBar_menu)) {
            ItemParser parser = new ItemParser(context, this.getDefaultConfig());
            parser.parser(typedArray.getResourceId(R.styleable.BottomNavigationBar_menu, 0));
            this.mBottomNavigationBarContent = new BottomNavigationBarContent(context);
            this.itemCounts = parser.getItemCounts();
            this.mBottomNavigationBarContent.setSwitchMode(this.mSwitchMode).setItems(parser.getBottomNavigationItems());
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -2, 17);
            this.addView((View)this.mBottomNavigationBarContent, (ViewGroup.LayoutParams)layoutParams);
            for (int i = 0; i < this.itemCounts; ++i) {
                this.canChangeBackColor = this.canChangeBackColor && this.getBottomItem(i).getShiftedColor() != 0;
            }
            this.mBottomNavigationBarContent.setCanChangeBackColor(this.canChangeBackColor);
            this.mBottomNavigationBarContent.finishInit(parser.getBottomNavigationItems(), this.viewpagerId != 0, this.isSlide, this.canChangeBackColor);
        }
        typedArray.recycle();
    }

    boolean isCanChangeBackColor() {
        return this.canChangeBackColor;
    }

    boolean getCanClick() {
        return !this.isMoving && !this.isBackMoving & this.offset == 0.0f;
    }

    private void initViewPager(@IdRes int viewpagerId) {
        this.viewpager = (ViewPager)((Activity)this.getContext()).findViewById(viewpagerId);
        this.viewpager.setEnabled(false);
        this.viewpager.addOnPageChangeListener((ViewPager.OnPageChangeListener)new ViewPager.SimpleOnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
                super.onPageScrolled(position, positionOffset, positionOffsetPixels);
                BottomNavigationBar.this.offset = positionOffset;
                if (positionOffset == 0.0f && BottomNavigationBar.this.isSlide) {
                    for (int i = 0; i < BottomNavigationBar.this.itemCounts; ++i) {
                        if (BottomNavigationBar.this.getBottomItem(i).isHasCorrect()) continue;
                        BottomNavigationBar.this.getBottomItem(i).correctItem(i == position);
                    }
                }
                if (positionOffset > 0.0f && BottomNavigationBar.this.isSlide) {
                    BottomNavigationBar.this.startAlphaAnim(position, positionOffset, BottomNavigationBar.this.isMoving);
                    if (BottomNavigationBar.this.canChangeBackColor) {
                        BottomNavigationBar.this.setBackgroundColor(BarUtils.getOffsetColor(positionOffset, BottomNavigationBar.this.getBottomItem(position).getShiftedColor(), BottomNavigationBar.this.getBottomItem(position + 1).getShiftedColor(), 10));
                    }
                }
            }

            public void onPageScrollStateChanged(int state) {
                super.onPageScrollStateChanged(state);
                switch (state) {
                    case 0: {
                        BottomNavigationBar.this.isMoving = false;
                        BottomNavigationBar.this.isBackMoving = false;
                        break;
                    }
                    case 1: {
                        BottomNavigationBar.this.isMoving = true;
                        BottomNavigationBar.this.isBackMoving = false;
                        break;
                    }
                    case 2: {
                        BottomNavigationBar.this.isMoving = false;
                        BottomNavigationBar.this.isBackMoving = true;
                    }
                }
            }

            public void onPageSelected(int position) {
                super.onPageSelected(position);
                if (BottomNavigationBar.this.isBackMoving) {
                    if (BottomNavigationBar.this.isSlide) {
                        BottomNavigationBar.this.getChildView().updatePosition(position);
                    } else {
                        BottomNavigationBar.this.setItemSelected(position, true, false);
                        BottomNavigationBar.this.correctBackColor(position);
                    }
                }
            }
        });
        ((BottomNavigationBarContent)this.getChildAt(1)).setViewPager(this.viewpager);
        PagerAdapter pagerAdapter = new PagerAdapter(((AppCompatActivity)this.getContext()).getSupportFragmentManager());
        this.viewpager.setAdapter((android.support.v4.view.PagerAdapter)pagerAdapter);
    }

    void setFirstItemBackgroundColor(int shiftedColor) {
        this.setBackgroundColor(shiftedColor);
    }

    private BottomNavigationItemWithDot.Config getDefaultConfig() {
        return new BottomNavigationItemWithDot.Config.Build().setItemBackGroundRes(this.itemBackGroundRes).setSwitchMode(this.mSwitchMode).setActiveColor(this.activeColor).setInActiveColor(this.inActiveColor).setIsSlide(this.isSlide).build();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)View.MeasureSpec.getSize((int)widthMeasureSpec), (int)0x40000000);
        heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)BarUtils.dip2px(this.getContext(), 56.0f), (int)0x40000000);
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    void drawBackgroundCircle(int shiftedColor, float x, float y) {
        if (this.currentRadius == 0.0f) {
            this.currentRadius = BarUtils.dip2px(this.getContext(), 10.0f);
        }
        if (this.maxRadius == 0.0f) {
            this.maxRadius = (float)Math.sqrt(this.getMeasuredHeight() * this.getMeasuredHeight() + this.getMeasuredWidth() * this.getMeasuredWidth());
        }
        if (Build.VERSION.SDK_INT < 21) {
            this.drawLowVersionCircle(shiftedColor, x, y);
        } else {
            this.prepareForBackgroundColorAnimation(shiftedColor);
            this.drawHighVersionCircle(shiftedColor, (int)x, (int)y);
        }
    }

    @TargetApi(value=21)
    private void drawHighVersionCircle(final int shiftedColor, final int x, final int y) {
        if (this.isInflated) {
            final Animator animator = ViewAnimationUtils.createCircularReveal((View)this.circleView, (int)x, (int)y, (float)this.currentRadius, (float)this.maxRadius);
            animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    this.onEnd();
                }

                public void onAnimationCancel(Animator animation) {
                    this.onEnd();
                }

                private void onEnd() {
                    animator.removeListener((Animator.AnimatorListener)this);
                    BottomNavigationBar.this.setBackgroundColor(shiftedColor);
                    BottomNavigationBar.this.circleView.setVisibility(4);
                    ViewCompat.setAlpha((View)BottomNavigationBar.this.circleView, (float)1.0f);
                }
            });
            animator.start();
        } else {
            this.circleView.post(new Runnable(){

                @Override
                public void run() {
                    final Animator animator = ViewAnimationUtils.createCircularReveal((View)BottomNavigationBar.this.circleView, (int)x, (int)y, (float)BottomNavigationBar.this.currentRadius, (float)BottomNavigationBar.this.maxRadius);
                    animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                        public void onAnimationEnd(Animator animation) {
                            this.onEnd();
                        }

                        public void onAnimationCancel(Animator animation) {
                            this.onEnd();
                        }

                        private void onEnd() {
                            animator.removeListener((Animator.AnimatorListener)this);
                            BottomNavigationBar.this.setBackgroundColor(shiftedColor);
                            BottomNavigationBar.this.circleView.setVisibility(4);
                            ViewCompat.setAlpha((View)BottomNavigationBar.this.circleView, (float)1.0f);
                        }
                    });
                    animator.start();
                }
            });
        }
    }

    private void prepareForBackgroundColorAnimation(int newColor) {
        this.circleView.clearAnimation();
        this.circleView.setBackgroundColor(newColor);
        this.circleView.setVisibility(0);
    }

    private void drawLowVersionCircle(int shiftedColor, float x, float y) {
        this.downX = x;
        this.downY = y;
        this.shiftedColor = shiftedColor;
        this.isStart = true;
        this.refreshView();
    }

    private void refreshView() {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            this.invalidate();
        } else {
            this.postInvalidate();
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.isStart) {
            this.initPaint();
            this.mPaint.setColor(this.shiftedColor);
            if (this.currentRadius < this.maxRadius) {
                this.currentRadius += this.currentRadius + this.maxRadius / 30.0f;
                canvas.drawCircle(this.downX, this.downY, this.currentRadius, this.mPaint);
                this.refreshView();
            } else {
                this.isStart = false;
                this.currentRadius = 0.0f;
                this.setBackgroundColor(this.shiftedColor);
                canvas.drawRect(0.0f, 0.0f, (float)this.getMeasuredWidth(), (float)this.getMeasuredHeight(), this.mPaint);
            }
        }
    }

    private void initPaint() {
        if (this.mPaint == null) {
            this.mPaint = new Paint(1);
        }
    }

    private void startAlphaAnim(int position, float positionOffset, boolean isMoving) {
        ((BottomNavigationBarContent)this.getChildAt(1)).startAlphaAnim(position, positionOffset, isMoving);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            @TargetApi(value=16)
            public void onGlobalLayout() {
                BottomNavigationBar.this.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                BottomNavigationBar.this.isInflated = true;
                if (BottomNavigationBar.this.viewpagerId != 0) {
                    try {
                        BottomNavigationBar.this.initViewPager(BottomNavigationBar.this.viewpagerId);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("you need provide a fragment packageName in menu's xml");
                    }
                }
            }
        });
    }

    public void disMissNum(int position) {
        ((BottomNavigationItemWithDot)((BottomNavigationBarContent)this.getChildAt(1)).getChildAt(position)).disMissMes();
    }

    public void correctBackColor() {
        this.setBackgroundColor(this.getBottomItem(this.getChildView().getActivePosition()).getShiftedColor());
    }

    public void correctBackColor(int position) {
        if (this.canChangeBackColor) {
            this.setBackgroundColor(this.getBottomItem(position).getShiftedColor());
        }
    }

    public void setOnNavigationItemSelectedListener(@Nullable OnNavigationItemSelectedListener listener) {
        this.mBottomNavigationBarContent.injectListener(listener);
    }

    public void setItemSelected(final int position, final boolean isAnim) {
        if (position < 0 || position > this.itemCounts - 1) {
            throw new RuntimeException("the range of position is 0-" + (this.itemCounts - 1));
        }
        if (this.isInflated) {
            this.setItemSelected(position, isAnim, false);
            this.correctBackColor(position);
            if (this.viewpager != null) {
                this.viewpager.setCurrentItem(position, false);
            }
        } else {
            this.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                public void onGlobalLayout() {
                    if (Build.VERSION.SDK_INT >= 16) {
                        BottomNavigationBar.this.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    }
                    BottomNavigationBar.this.setItemSelected(position, isAnim, false);
                    BottomNavigationBar.this.correctBackColor(position);
                    if (BottomNavigationBar.this.viewpager != null) {
                        BottomNavigationBar.this.viewpager.setCurrentItem(position, false);
                    }
                }
            });
        }
    }

    private void setItemSelected(int position, boolean isAnim, boolean isCanBackWave) {
        this.getChildView().setItemSelected(position, isAnim, isCanBackWave);
    }

    public void hideBar() {
        if (this.getVisibility() == 4) {
            return;
        }
        TransitionManager.beginDelayedTransition((ViewGroup)this, (Transition)new Slide());
        this.setVisibility(4);
    }

    public void hideBar(int mode) {
        if (this.getVisibility() == 4) {
            return;
        }
        TransitionManager.beginDelayedTransition((ViewGroup)this, (Transition)new Fade().setDuration(700L));
        this.setVisibility(4);
    }

    public void showBar() {
        if (this.getVisibility() == 0) {
            return;
        }
        TransitionManager.beginDelayedTransition((ViewGroup)this, (Transition)new Slide());
        this.setVisibility(0);
    }

    public void showBar(int mode) {
        if (this.getVisibility() == 0) {
            return;
        }
        TransitionManager.beginDelayedTransition((ViewGroup)this, (Transition)new Fade().setDuration(700L));
        this.setVisibility(0);
    }

    public void showNum(int position, int num) {
        ((BottomNavigationItemWithDot)((BottomNavigationBarContent)this.getChildAt(1)).getChildAt(position)).showNum(num);
    }

    @IdRes
    int getContainerId() {
        return this.containerId;
    }

    private BottomNavigationItemWithDot getBottomItem(int position) {
        return (BottomNavigationItemWithDot)((BottomNavigationBarContent)this.getChildAt(1)).getChildAt(position);
    }

    private BottomNavigationBarContent getChildView() {
        return (BottomNavigationBarContent)this.getChildAt(1);
    }

    public Fragment getFragment(int position) {
        return this.getBottomItem(position).getFragment();
    }

    public ViewPager getViewPager() {
        if (this.viewpagerId != 0 && this.viewpager != null) {
            return this.viewpager;
        }
        return null;
    }

    public void setTitle(final int position, final String title) {
        if (this.isInflated) {
            this.getBottomItem(position).changeTitle(title);
        } else {
            this.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                public void onGlobalLayout() {
                    if (Build.VERSION.SDK_INT >= 16) {
                        BottomNavigationBar.this.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    }
                    BottomNavigationBar.this.getBottomItem(position).changeTitle(title);
                }
            });
        }
    }

    class PagerAdapter
    extends FragmentPagerAdapter {
        public PagerAdapter(FragmentManager fm) {
            super(fm);
        }

        public Fragment getItem(int position) {
            return BottomNavigationBar.this.getBottomItem(position).getFragment();
        }

        public int getCount() {
            return BottomNavigationBar.this.itemCounts;
        }
    }

    public static interface OnNavigationItemSelectedListener {
        public boolean onNavigationItemSelected(@NonNull BottomNavigationItemWithDot var1, int var2);

        public void onNavigationItemSelectedAgain(@NonNull BottomNavigationItemWithDot var1, int var2);
    }
}

