/*
 * Decompiled with CFR 0.152.
 */
package com.wakehao.bar;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.v7.appcompat.R;
import android.util.TypedValue;
import com.wakehao.bar.R;
import org.jetbrains.annotations.NotNull;

public class BarUtils {
    private static final int[] APPCOMPAT_CHECK_ATTRS = new int[]{R.attr.colorPrimary};

    public static int dip2px(Context context, float dpValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    public static int px2dip(Context context, float pxValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(pxValue / scale + 0.5f);
    }

    public static float px2sp(@NotNull Context context, float pxValue) {
        float fontScale = context.getResources().getDisplayMetrics().scaledDensity;
        return (int)(pxValue / fontScale);
    }

    public static float sp2px(@NotNull Context context, float spValue) {
        float fontScale = context.getResources().getDisplayMetrics().scaledDensity;
        return spValue * fontScale;
    }

    public static Drawable changeDrawableColor(int drawableRes, int colorRes, Context context) {
        Bitmap bitmap = BitmapFactory.decodeResource((Resources)context.getResources(), (int)drawableRes);
        Bitmap resultBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)(bitmap.getWidth() - 1), (int)(bitmap.getHeight() - 1));
        Paint p = new Paint();
        Canvas canvas = new Canvas(resultBitmap);
        canvas.drawBitmap(resultBitmap, 0.0f, 0.0f, p);
        BitmapDrawable drawable = new BitmapDrawable(context.getResources(), resultBitmap);
        drawable.setColorFilter((ColorFilter)new PorterDuffColorFilter(colorRes, PorterDuff.Mode.MULTIPLY));
        return drawable;
    }

    public static int getDeviceWidth(Context context) {
        return context.getResources().getDisplayMetrics().widthPixels;
    }

    static void checkAppCompatTheme(Context context) {
        boolean failed;
        TypedArray a = context.obtainStyledAttributes(APPCOMPAT_CHECK_ATTRS);
        boolean bl = failed = !a.hasValue(0);
        if (a != null) {
            a.recycle();
        }
        if (failed) {
            throw new IllegalArgumentException("You need to use a Theme.AppCompat theme (or descendant) with the design library.");
        }
    }

    @ColorInt
    public static int getAppColorPrimary(Context context) {
        BarUtils.checkAppCompatTheme(context);
        TypedValue typedValue = new TypedValue();
        context.getTheme().resolveAttribute(R.attr.colorPrimary, typedValue, true);
        return typedValue.data;
    }

    @ColorInt
    public static int getOffsetColor(float offset, @ColorInt int startColor, @ColorInt int endColor, int steps) {
        try {
            if ((double)offset <= 0.04) {
                return startColor;
            }
            if ((double)offset >= 0.96) {
                return endColor;
            }
            int startRed = Color.red((int)startColor);
            int startGreen = Color.green((int)startColor);
            int startBlue = Color.blue((int)startColor);
            int endRed = Color.red((int)endColor);
            int endGreen = Color.green((int)endColor);
            int endBlue = Color.blue((int)endColor);
            int newRed = (int)((float)startRed + (float)((endRed - startRed) / steps) * (offset * (float)steps));
            int newGreen = (int)((float)startGreen + (float)((endGreen - startGreen) / steps) * (offset * (float)steps));
            int newBlue = (int)((float)startBlue + (float)((endBlue - startBlue) / steps) * (offset * (float)steps));
            return Color.rgb((int)newRed, (int)newGreen, (int)newBlue);
        }
        catch (Exception e) {
            return 0;
        }
    }

    private static int getHexInt(int value) {
        String hexString = Integer.toHexString(value);
        if (hexString.length() == 1) {
            hexString = "0" + hexString;
        }
        return Integer.valueOf(hexString);
    }

    @ColorInt
    public static int getIconColor(float positionOffset, @ColorInt int startColor, @ColorInt int middleColor, @ColorInt int endColor, int step) {
        if (startColor == 0) {
            if ((double)positionOffset < 0.5) {
                if (middleColor == 0) {
                    return middleColor;
                }
                return Color.argb((int)((int)(255.0f * positionOffset * 2.0f)), (int)Color.red((int)middleColor), (int)Color.green((int)middleColor), (int)Color.blue((int)middleColor));
            }
            if ((double)positionOffset == 0.5) {
                return middleColor;
            }
            if (middleColor == 0) {
                if (endColor == 0) {
                    return middleColor;
                }
                return Color.argb((int)((int)(255.0f - 510.0f * positionOffset)), (int)Color.red((int)endColor), (int)Color.green((int)endColor), (int)Color.blue((int)endColor));
            }
            if (endColor == 0) {
                return Color.argb((int)((int)(255.0f - 510.0f * positionOffset)), (int)Color.red((int)endColor), (int)Color.green((int)endColor), (int)Color.blue((int)endColor));
            }
            return BarUtils.getOffsetColor((float)(((double)positionOffset - 0.5) * 2.0), middleColor, endColor, step);
        }
        if (middleColor == 0) {
            if ((double)positionOffset < 0.5) {
                return Color.argb((int)((int)(255.0f - 510.0f * positionOffset)), (int)Color.red((int)startColor), (int)Color.green((int)startColor), (int)Color.blue((int)startColor));
            }
            if ((double)positionOffset == 0.5) {
                return middleColor;
            }
            if (endColor == 0) {
                return 0;
            }
            return Color.argb((int)((int)(255.0f - 510.0f * positionOffset)), (int)Color.red((int)endColor), (int)Color.green((int)endColor), (int)Color.blue((int)endColor));
        }
        if (endColor == 0) {
            if ((double)positionOffset < 0.5) {
                return BarUtils.getOffsetColor(positionOffset * 2.0f, startColor, middleColor, step);
            }
            if ((double)positionOffset == 0.5) {
                return middleColor;
            }
            return Color.argb((int)((int)(255.0f - 510.0f * positionOffset)), (int)Color.red((int)middleColor), (int)Color.green((int)middleColor), (int)Color.blue((int)middleColor));
        }
        if ((double)positionOffset < 0.5) {
            return BarUtils.getOffsetColor(positionOffset * 2.0f, startColor, middleColor, step);
        }
        if ((double)positionOffset == 0.5) {
            return middleColor;
        }
        return BarUtils.getOffsetColor((float)(((double)positionOffset - 0.5) * 2.0), middleColor, endColor, step);
    }
}

