/*
 * Decompiled with CFR 0.152.
 */
package com.wakehao.bar.dot;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import org.jetbrains.annotations.NotNull;

public class Utils {
    public static int dip2px(Context context, float dpValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    public static int px2dip(Context context, float pxValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(pxValue / scale + 0.5f);
    }

    public static float px2sp(@NotNull Context context, float pxValue) {
        float fontScale = context.getResources().getDisplayMetrics().scaledDensity;
        return (int)(pxValue / fontScale);
    }

    public static float sp2px(@NotNull Context context, float spValue) {
        float fontScale = context.getResources().getDisplayMetrics().scaledDensity;
        return spValue * fontScale;
    }

    public static Drawable changeDrawableColor(int drawableRes, int colorRes, Context context) {
        Bitmap bitmap = BitmapFactory.decodeResource((Resources)context.getResources(), (int)drawableRes);
        Bitmap resultBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)(bitmap.getWidth() - 1), (int)(bitmap.getHeight() - 1));
        Paint p = new Paint();
        Canvas canvas = new Canvas(resultBitmap);
        canvas.drawBitmap(resultBitmap, 0.0f, 0.0f, p);
        BitmapDrawable drawable2 = new BitmapDrawable(context.getResources(), resultBitmap);
        drawable2.setColorFilter((ColorFilter)new PorterDuffColorFilter(colorRes, PorterDuff.Mode.MULTIPLY));
        return drawable2;
    }

    public static int getDeviceWidth(Context context) {
        return context.getResources().getDisplayMetrics().widthPixels;
    }

    public static int getStatusBarHeight(View v) {
        if (v == null) {
            return 0;
        }
        Rect frame = new Rect();
        v.getWindowVisibleDisplayFrame(frame);
        return frame.top;
    }

    public static int getStatusAndTitleBarHeight(View v) {
        if (v == null) {
            return 0;
        }
        Rect frame = new Rect();
        v.getWindowVisibleDisplayFrame(frame);
        View viewById = ((Activity)v.getContext()).getWindow().findViewById(0x1020002);
        return viewById.getTop() + frame.top;
    }
}

