/*
 * Decompiled with CFR 0.152.
 */
package com.wakehao.bar.dot;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.Rect;
import android.os.Looper;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import com.wakehao.bar.dot.DragView;
import com.wakehao.bar.dot.Utils;

public class DotView
extends View {
    private String showNum = "";
    private boolean isShowJustDot;
    private Paint mDotPaint;
    private Rect textRect;
    private float padding;
    private float radiusBase;
    private float radius;
    private Context mContext;
    private PointF circleCenter;
    private PointF textPoint;
    private DragView dragView;
    private boolean flagLimit;

    public DotView(Context context) {
        this(context, null);
    }

    public DotView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public DotView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        this.init();
    }

    private void init() {
        this.mDotPaint = new Paint(1);
        this.mDotPaint.setStyle(Paint.Style.FILL);
        this.mDotPaint.setTextSize(Utils.sp2px(this.mContext, 8.0f));
        this.mDotPaint.setColor(-65536);
        this.textRect = new Rect();
        this.circleCenter = new PointF();
        this.textPoint = new PointF();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = this.isShowJustDot() ? View.MeasureSpec.makeMeasureSpec((int)(2 * Utils.dip2px(this.mContext, 3.0f)), (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)((int)(2.0f * this.radius + 1.0f)), (int)0x40000000);
        super.onMeasure(width, width);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.isShowJustDot) {
            canvas.drawCircle(this.circleCenter.x + (float)Utils.dip2px(this.mContext, 3.0f), this.circleCenter.y + (float)Utils.dip2px(this.mContext, 3.0f), (float)Utils.dip2px(this.mContext, 3.0f), this.mDotPaint);
            return;
        }
        this.updataPointF();
        if (!TextUtils.isEmpty((CharSequence)this.showNum)) {
            this.drawDotCircle(canvas);
            this.drawNumText(canvas);
        }
    }

    private void updataPointF() {
        this.mDotPaint.getTextBounds(this.showNum, 0, this.showNum.length(), this.textRect);
        this.radiusBase = (float)Math.sqrt(Math.pow(this.textRect.height() / 2, 2.0) + Math.pow(this.textRect.width() / 2, 2.0));
        this.radius = this.radiusBase + this.padding;
        this.circleCenter.set(this.radius, this.radius);
        this.textPoint.set(this.radius - (float)(this.textRect.width() / 2), this.radius + (float)(this.textRect.height() / 2));
        if (this.radius != 0.0f && !this.flagLimit) {
            this.requestLayout();
            this.flagLimit = true;
        }
    }

    private void drawDotCircle(Canvas canvas) {
        canvas.drawCircle(this.circleCenter.x, this.circleCenter.y, this.radius, this.mDotPaint);
    }

    private void drawNumText(Canvas canvas) {
        this.mDotPaint.setColor(-1);
        this.mDotPaint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.mDotPaint.setStrokeWidth(1.0f);
        canvas.drawText(this.showNum, this.textPoint.x - (float)(this.showNum.contains("1") ? Utils.dip2px(this.mContext, 1.0f) : 0), this.textPoint.y, this.mDotPaint);
        this.mDotPaint.setColor(-65536);
        this.mDotPaint.setStyle(Paint.Style.FILL);
    }

    public void showNum(int num) {
        this.isShowJustDot = false;
        this.setOnTouchListener(null);
        if (this.getVisibility() == 8) {
            this.setVisibility(0);
        }
        if (num < 0) {
            this.isShowJustDot = true;
        } else if (num > 0) {
            this.showNum = num > 99 ? "99+" : String.valueOf(num);
        } else {
            return;
        }
        if (!this.isShowJustDot()) {
            this.createDragView();
        }
        this.setPaddingValue(num);
        this.refreshView();
    }

    public void disMisMes() {
        this.isShowJustDot = false;
        this.setVisibility(8);
        if (this.dragView != null) {
            this.dragView.disMissMes();
        }
    }

    private void createDragView() {
        this.dragView = new DragView(this.mContext);
        this.dragView.rely(this);
    }

    private void setPaddingValue(int num) {
        if (num == 1) {
            this.padding = Utils.dip2px(this.mContext, 4.0f);
            this.mDotPaint.setTextSize(Utils.sp2px(this.mContext, 9.0f));
        } else {
            this.padding = num > 0 && num < 10 ? (float)Utils.dip2px(this.mContext, 4.0f) : (num > 99 ? 2.0f : (float)Utils.dip2px(this.mContext, 3.0f));
        }
    }

    private void refreshView() {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            this.invalidate();
        } else {
            this.postInvalidate();
        }
    }

    public String getShowNum() {
        return this.showNum;
    }

    public float getRadius() {
        return this.radius;
    }

    public int getNumWidth() {
        return this.textRect.width();
    }

    public int getNumHeight() {
        return this.textRect.height();
    }

    public int[] getCircleCenterOnRaw() {
        int[] position = new int[2];
        this.getLocationOnScreen(position);
        return position;
    }

    public boolean isShowJustDot() {
        return this.isShowJustDot;
    }

    public void onDestroy() {
        if (this.dragView != null) {
            this.dragView.onDestroy();
        }
        this.mContext = null;
    }
}

