/*
 * Decompiled with CFR 0.152.
 */
package com.wakehao.bar;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.os.Looper;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.IdRes;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentTransaction;
import android.support.v4.content.ContextCompat;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.animation.FastOutSlowInInterpolator;
import android.support.v7.app.AppCompatActivity;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.wakehao.bar.BarUtils;
import com.wakehao.bar.BottomNavigationBar;
import com.wakehao.bar.BottomNavigationItemWithDot;
import com.wakehao.bar.R;

public class BottomNavigationItem
extends View {
    @DrawableRes
    private int iconRes;
    @DrawableRes
    private int iconRes2_selected;
    private String title;
    private Config config;
    private int mPosition;
    @ColorInt
    private int mShiftedColor;
    private boolean initFinished;
    private Paint mPaint;
    public final int mActiveMarginTop;
    private final int mScaleInactiveMarginTop;
    public final int mShiftInactiveMarginTop;
    private final int mActiveMarginBottom;
    private final int mIconSize;
    private final int mActiveTextSize;
    private final int mInactiveTextSize;
    private Fragment mFragment;
    private Bitmap mBitmap;
    private static final long ACTIVE_ANIMATION_DURATION_MS = 150L;
    private int activeItemWidth;
    private int inActiveItemWidth;
    float currentMarginTop;
    private boolean isViewPager;
    Bitmap bitmap_selected;
    private boolean isSliding;
    private boolean hasCorrect;
    private Paint mSelectedIconPaint;
    private Paint mUnSelectedIconPaint;
    private boolean isSelected;
    @IdRes
    private int containerId;
    private float scaleFraction;
    private float mIconSizeWidth;
    private float mIconSizeHeight;
    RectF rectF;
    Rect rect;
    boolean isRefresh;
    Rect textRect;
    float animatedFraction;
    private String tag;

    public BottomNavigationItem(Context context) {
        this(context, null);
    }

    public BottomNavigationItem(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BottomNavigationItem(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        Resources res = this.getResources();
        this.mActiveMarginTop = res.getDimensionPixelSize(R.dimen.item_active_marginTop);
        this.mScaleInactiveMarginTop = res.getDimensionPixelSize(R.dimen.item_scaleInactive_marginTop);
        this.mShiftInactiveMarginTop = res.getDimensionPixelSize(R.dimen.item_shiftInactive_marginTop);
        this.mActiveMarginBottom = res.getDimensionPixelSize(R.dimen.item_active_marginBottom);
        this.mIconSize = res.getDimensionPixelSize(R.dimen.item_icon_size);
        this.mActiveTextSize = res.getDimensionPixelSize(R.dimen.item_active_text_size);
        this.mInactiveTextSize = res.getDimensionPixelSize(R.dimen.item_inactive_text_size);
    }

    private void initDefaultOption() {
        if (this.mPosition == 0) {
            this.isSelected = true;
            if (this.mShiftedColor != 0 && !this.isViewPager) {
                ((BottomNavigationBar)this.getParent().getParent().getParent()).setFirstItemBackgroundColor(this.mShiftedColor);
            }
        }
        if (this.mShiftedColor == 0 || this.isViewPager) {
            this.setItemBackground(this.config.itemBackGroundRes);
        }
        this.mBitmap = BitmapFactory.decodeResource((Resources)this.getResources(), (int)this.iconRes);
        this.initPaint();
        if (this.iconRes2_selected != 0) {
            this.bitmap_selected = BitmapFactory.decodeResource((Resources)this.getResources(), (int)this.iconRes2_selected);
            this.initSecondPaint();
            if (this.isSelected) {
                this.mUnSelectedIconPaint.setColor(0);
            } else {
                this.mSelectedIconPaint.setColor(0);
            }
        }
        this.init();
        if (this.config.isSlide && this.iconRes2_selected == 0) {
            throw new RuntimeException("you need provide 2 pictures in Slide mode at least");
        }
        if (this.config.switchMode == 0) {
            float f = this.currentMarginTop = this.isSelected ? (float)this.mActiveMarginTop : (float)this.mScaleInactiveMarginTop;
        }
        if (this.config.switchMode == 2) {
            this.currentMarginTop = this.mActiveMarginTop;
        }
        if (this.mPosition == 0) {
            this.setSelected(true, false);
        }
    }

    public int getIconRes() {
        return this.iconRes;
    }

    public void setIconRes(int iconRes) {
        this.iconRes = iconRes;
    }

    public void setIconResSelected(int iconRes2_selected) {
        this.iconRes2_selected = iconRes2_selected;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Config getConfig() {
        return this.config;
    }

    public int getPosition() {
        return this.mPosition;
    }

    public void setPosition(int mPosition) {
        this.mPosition = mPosition;
    }

    public void setShiftedColor(int mShiftedColor) {
        this.mShiftedColor = mShiftedColor;
    }

    public int getShiftedColor() {
        if (this.isViewPager) {
            return 0;
        }
        return this.mShiftedColor;
    }

    public void setInActiveItemWidth(int inActiveItemWidth) {
        this.inActiveItemWidth = inActiveItemWidth;
    }

    public void setActiveItemWidth(int activeItemWidth) {
        this.activeItemWidth = activeItemWidth;
    }

    public void finishInit() {
        this.initFinished = true;
        this.initDefaultOption();
    }

    public void textAlphaAnim(float positionOffset) {
        this.mPaint.setColor(BarUtils.getOffsetColor(positionOffset, this.config.activeColor, this.config.inActiveColor, 10));
    }

    private void iconAlphaAnim(float positionOffset) {
        this.changeUnSelectedIconColorFilter(BarUtils.getIconColor(positionOffset, 0, this.config.activeColor, this.config.inActiveColor, 10));
        this.changeSelectedIconColorFilter(BarUtils.getIconColor(positionOffset, this.config.activeColor, 0, 0, 10));
    }

    public void alphaAnim(float positionOffset) {
        if (!this.config.isSlide) {
            return;
        }
        if (this.hasCorrect) {
            return;
        }
        this.isSliding = true;
        this.iconAlphaAnim(positionOffset);
        this.textAlphaAnim(positionOffset);
        if (this.config.switchMode == 0) {
            this.rectF.set((float)(this.getWidth() / 2) - this.mIconSizeWidth / 2.0f, this.getScaledY(positionOffset), (float)(this.getWidth() / 2) + this.mIconSizeWidth / 2.0f, this.getScaledY(positionOffset) + this.mIconSizeHeight);
            this.updateTextPaint(this.getScaledSp(positionOffset));
            this.correctDotViewPosition((int)this.getScaledY(positionOffset));
        } else if (this.config.switchMode == 1) {
            this.rectF.set((float)(this.getWidth() / 2) - this.mIconSizeWidth / 2.0f, (float)this.mActiveMarginTop + (float)(this.mShiftInactiveMarginTop - this.mActiveMarginTop) * positionOffset, (float)(this.getWidth() / 2) + this.mIconSizeWidth / 2.0f, (float)this.mActiveMarginTop + (float)(this.mShiftInactiveMarginTop - this.mActiveMarginTop) * positionOffset + this.mIconSizeHeight);
            this.updateTextPaint((float)this.mActiveTextSize * (1.0f - positionOffset));
            ((BottomNavigationItemWithDot)this.getParent()).setDotTop((int)((float)this.mActiveMarginTop + (float)(this.mShiftInactiveMarginTop - this.mActiveMarginTop) * positionOffset));
            this.updateItemWidth((float)this.activeItemWidth - (float)(this.activeItemWidth - this.inActiveItemWidth) * positionOffset);
        }
        if (!this.isSelected && (double)positionOffset >= 0.995) {
            this.correctItemData(false, true);
            return;
        }
        if (this.isSelected && (double)positionOffset <= 0.005) {
            this.correctItemData(true, true);
            return;
        }
        this.refreshView();
    }

    public boolean isHasCorrect() {
        return this.hasCorrect;
    }

    public void correctItemData(boolean isSelected, boolean hasCorrect) {
        this.hasCorrect = hasCorrect;
        this.isSelected = isSelected;
        if (isSelected) {
            if (this.config.switchMode == 2) {
                this.changeColor(this.config.activeColor);
                this.changeSelectedIconColorFilter(this.config.activeColor);
                this.mUnSelectedIconPaint.setColor(0);
                return;
            }
            if (this.config.switchMode == 1) {
                this.updateItemWidth(this.activeItemWidth);
                this.updateTextPaint(this.mActiveTextSize);
                this.rectF.set((float)(this.activeItemWidth / 2) - this.mIconSizeWidth / 2.0f, (float)this.mActiveMarginTop, (float)(this.activeItemWidth / 2) + this.mIconSizeWidth / 2.0f, (float)this.mActiveMarginTop + this.mIconSizeHeight);
            } else {
                this.updateTextPaint(this.mActiveTextSize);
                this.rectF.set((float)(this.activeItemWidth / 2) - this.mIconSizeWidth / 2.0f, (float)this.mActiveMarginTop, (float)(this.activeItemWidth / 2) + this.mIconSizeWidth / 2.0f, (float)this.mActiveMarginTop + this.mIconSizeHeight);
            }
        } else {
            if (this.config.switchMode == 2) {
                this.changeColor(this.config.inActiveColor);
                this.changeUnSelectedIconColorFilter(this.config.inActiveColor);
                this.mSelectedIconPaint.setColor(0);
                return;
            }
            if (this.config.switchMode == 1) {
                this.updateItemWidth(this.inActiveItemWidth);
                this.updateTextPaint(0.0f);
                this.rectF.set((float)(this.inActiveItemWidth / 2) - this.mIconSizeWidth / 2.0f, (float)this.mShiftInactiveMarginTop, this.mIconSizeWidth / 2.0f + (float)(this.inActiveItemWidth / 2), (float)this.mShiftInactiveMarginTop + this.mIconSizeHeight);
            } else {
                this.updateTextPaint(this.mInactiveTextSize);
                this.rectF.set((float)(this.inActiveItemWidth / 2) - this.mIconSizeWidth / 2.0f, (float)this.mScaleInactiveMarginTop, (float)(this.inActiveItemWidth / 2) + this.mIconSizeWidth / 2.0f, (float)this.mScaleInactiveMarginTop + this.mIconSizeHeight);
            }
        }
        this.setSelected(isSelected, false);
    }

    public void correctDotViewPosition(int top) {
        ((BottomNavigationItemWithDot)this.getParent()).correctDotViewPosition(top);
    }

    private float getScaledY(float offset) {
        return (float)this.mActiveMarginTop + (float)(this.mScaleInactiveMarginTop - this.mActiveMarginTop) * offset;
    }

    private float getScaledSp(float offset) {
        return (float)this.mActiveTextSize - (float)(this.mActiveTextSize - this.mInactiveTextSize) * offset;
    }

    private void initSecondPaint() {
        if (this.mSelectedIconPaint == null) {
            this.mSelectedIconPaint = new Paint(1);
            this.mSelectedIconPaint.setFilterBitmap(true);
            this.mUnSelectedIconPaint = new Paint(1);
            this.mUnSelectedIconPaint.setFilterBitmap(true);
        }
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    private void refreshView() {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            this.invalidate();
        } else {
            this.postInvalidate();
        }
    }

    public void setSelected(boolean isSelected, boolean isAnim) {
        this.isSelected = isSelected;
        this.changeColor(isSelected ? this.config.activeColor : this.config.inActiveColor);
        if (this.config.isSlide) {
            if (isSelected) {
                this.changeSelectedIconColorFilter(this.config.activeColor);
                this.mUnSelectedIconPaint.setColor(0);
            } else {
                this.changeUnSelectedIconColorFilter(this.config.inActiveColor);
                this.mSelectedIconPaint.setColor(0);
            }
        }
        if (!this.isViewPager) {
            this.switchFragment(isSelected);
        }
        if (!isAnim) {
            this.refreshView();
            return;
        }
        switch (this.config.getSwitchMode()) {
            case 0: {
                this.scaleAnim();
                break;
            }
            case 1: {
                this.translateAnim();
                break;
            }
            case 2: {
                this.refreshView();
            }
        }
    }

    private void switchFragment(boolean isSelected) {
        if (this.mFragment == null) {
            return;
        }
        FragmentTransaction fragmentTransaction = ((AppCompatActivity)this.getContext()).getSupportFragmentManager().beginTransaction();
        if (!isSelected) {
            if (this.mFragment.isAdded()) {
                fragmentTransaction.hide(this.mFragment);
            }
        } else if (this.mFragment.isAdded()) {
            fragmentTransaction.show(this.mFragment);
        } else {
            fragmentTransaction.add(this.getContainerId(), this.mFragment, this.tag);
        }
        fragmentTransaction.commitAllowingStateLoss();
    }

    @IdRes
    private int getContainerId() {
        if (this.containerId != 0) {
            return this.containerId;
        }
        this.containerId = ((BottomNavigationBar)this.getParent().getParent().getParent()).getContainerId();
        return this.containerId;
    }

    private void scaleAnim() {
        ValueAnimator scaleAnimator;
        this.isSliding = false;
        if (this.isSelected) {
            scaleAnimator = ValueAnimator.ofFloat((float[])new float[]{this.mScaleInactiveMarginTop, this.mActiveMarginTop});
        } else {
            if (Math.abs(this.mPaint.getTextSize() - (float)this.mInactiveTextSize) < 1.0f) {
                return;
            }
            scaleAnimator = ValueAnimator.ofFloat((float[])new float[]{this.mActiveMarginTop, this.mScaleInactiveMarginTop});
        }
        scaleAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                BottomNavigationItem.this.isRefresh = true;
                BottomNavigationItem.this.scaleFraction = animation.getAnimatedFraction();
                float change = BottomNavigationItem.this.scaleFraction * (float)(BottomNavigationItem.this.mScaleInactiveMarginTop - BottomNavigationItem.this.mActiveMarginTop);
                if (BottomNavigationItem.this.isSelected) {
                    BottomNavigationItem.this.currentMarginTop = (float)BottomNavigationItem.this.mScaleInactiveMarginTop - change;
                    BottomNavigationItem.this.rectF.set((float)(BottomNavigationItem.this.getWidth() / 2) - BottomNavigationItem.this.mIconSizeWidth / 2.0f, BottomNavigationItem.this.currentMarginTop, (float)(BottomNavigationItem.this.getWidth() / 2) + BottomNavigationItem.this.mIconSizeWidth / 2.0f, BottomNavigationItem.this.currentMarginTop + BottomNavigationItem.this.mIconSizeHeight);
                } else {
                    BottomNavigationItem.this.currentMarginTop = (float)BottomNavigationItem.this.mActiveMarginTop + change;
                    BottomNavigationItem.this.rectF.set((float)(BottomNavigationItem.this.getWidth() / 2) - BottomNavigationItem.this.mIconSizeWidth / 2.0f, BottomNavigationItem.this.currentMarginTop, (float)(BottomNavigationItem.this.getWidth() / 2) + BottomNavigationItem.this.mIconSizeWidth / 2.0f, BottomNavigationItem.this.currentMarginTop + BottomNavigationItem.this.mIconSizeHeight);
                }
                ((BottomNavigationItemWithDot)BottomNavigationItem.this.getParent()).correctDotViewPosition((int)BottomNavigationItem.this.currentMarginTop);
                BottomNavigationItem.this.refreshView();
            }
        });
        scaleAnimator.setDuration(150L);
        scaleAnimator.start();
    }

    public void setItemBackground(int background) {
        Drawable backgroundDrawable = background == 0 ? null : ContextCompat.getDrawable((Context)this.getContext(), (int)background);
        ViewCompat.setBackground((View)this, (Drawable)backgroundDrawable);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.initFinished) {
            switch (this.config.getSwitchMode()) {
                case 0: {
                    this.drawScaledIcon(canvas);
                    this.drawScaledText(canvas);
                    break;
                }
                case 1: {
                    this.drawShiftedIcon(canvas);
                    this.drawShiftedText(canvas);
                    break;
                }
                case 2: {
                    this.drawStillIcon(canvas);
                    this.drawStillText(canvas);
                }
            }
        }
    }

    private void drawStillText(Canvas canvas) {
        this.updateTextPaint(this.mActiveTextSize);
        canvas.drawText(this.title, (float)(this.getWidth() / 2 - this.textRect.width() / 2), (float)BarUtils.dip2px(this.getContext(), 46.0f), this.mPaint);
    }

    private void drawStillIcon(Canvas canvas) {
        this.rectF.set((float)(this.getWidth() / 2) - this.mIconSizeWidth / 2.0f, (float)this.mActiveMarginTop, (float)(this.getWidth() / 2) + this.mIconSizeWidth / 2.0f, (float)this.mActiveMarginTop + this.mIconSizeHeight);
        if (this.config.isSlide && this.iconRes2_selected != 0) {
            canvas.drawBitmap(this.mBitmap, this.rect, this.rectF, this.mUnSelectedIconPaint);
            canvas.drawBitmap(this.bitmap_selected, this.rect, this.rectF, this.mSelectedIconPaint);
            return;
        }
        if (this.iconRes2_selected != 0) {
            if (this.isSelected) {
                canvas.drawBitmap(this.bitmap_selected, this.rect, this.rectF, this.mPaint);
            } else {
                canvas.drawBitmap(this.mBitmap, this.rect, this.rectF, this.mPaint);
            }
            return;
        }
        canvas.drawBitmap(this.mBitmap, this.rect, this.rectF, this.mPaint);
    }

    private void init() {
        if (this.textRect == null) {
            this.textRect = new Rect();
        }
        if (this.rect == null) {
            int height;
            int width = this.mBitmap.getWidth();
            if (width > (height = this.mBitmap.getHeight())) {
                this.mIconSizeWidth = this.mIconSize;
                this.mIconSizeHeight = (float)height / (float)width * (float)this.mIconSize;
            } else if (width < height) {
                this.mIconSizeHeight = this.mIconSize;
                this.mIconSizeWidth = width / height * this.mIconSize;
            } else {
                this.mIconSizeWidth = this.mIconSize;
                this.mIconSizeHeight = this.mIconSize;
            }
            this.rect = new Rect(0, 0, width, height);
        }
        if (this.rectF == null) {
            this.rectF = new RectF();
        }
        if (this.isSelected) {
            this.changeColor(this.config.activeColor);
        } else {
            this.changeColor(this.config.inActiveColor);
        }
    }

    private void updateTextPaint(float textSize) {
        this.mPaint.setTextSize(textSize);
        this.mPaint.getTextBounds(this.title, 0, this.title.length(), this.textRect);
    }

    private void drawScaledText(Canvas canvas) {
        if (this.config.isSlide && this.isSliding) {
            canvas.drawText(this.title, (float)(this.getWidth() / 2 - this.textRect.width() / 2), (float)BarUtils.dip2px(this.getContext(), 46.0f), this.mPaint);
            return;
        }
        if (this.isRefresh) {
            if (this.isSelected) {
                this.updateTextPaint((float)this.mInactiveTextSize + (float)(this.mActiveTextSize - this.mInactiveTextSize) * this.scaleFraction);
            } else {
                this.updateTextPaint((float)this.mActiveTextSize - (float)(this.mActiveTextSize - this.mInactiveTextSize) * this.scaleFraction);
            }
            canvas.drawText(this.title, (float)(this.getWidth() / 2 - this.textRect.width() / 2), (float)BarUtils.dip2px(this.getContext(), 46.0f), this.mPaint);
            return;
        }
        this.updateTextPaint(this.isSelected ? (float)this.mActiveTextSize : (float)this.mInactiveTextSize);
        canvas.drawText(this.title, (float)(this.getWidth() / 2 - this.textRect.width() / 2), (float)BarUtils.dip2px(this.getContext(), 46.0f), this.mPaint);
    }

    private void drawScaledIcon(Canvas canvas) {
        if (this.isRefresh) {
            if (this.iconRes2_selected != 0) {
                canvas.drawBitmap(this.mBitmap, this.rect, this.rectF, this.mUnSelectedIconPaint);
                canvas.drawBitmap(this.bitmap_selected, this.rect, this.rectF, this.mSelectedIconPaint);
                return;
            }
            canvas.drawBitmap(this.mBitmap, this.rect, this.rectF, this.mPaint);
            return;
        }
        if (this.rectF.isEmpty()) {
            if (this.isSelected) {
                this.currentMarginTop = this.mActiveMarginTop;
                this.rectF.set((float)(this.getWidth() / 2) - this.mIconSizeWidth / 2.0f, (float)this.mActiveMarginTop, (float)(this.getWidth() / 2) + this.mIconSizeWidth / 2.0f, (float)this.mActiveMarginTop + this.mIconSizeHeight);
            } else {
                this.currentMarginTop = this.mScaleInactiveMarginTop;
                this.rectF.set((float)(this.getWidth() / 2) - this.mIconSizeWidth / 2.0f, (float)this.mScaleInactiveMarginTop, (float)(this.getWidth() / 2) + this.mIconSizeWidth / 2.0f, (float)this.mScaleInactiveMarginTop + this.mIconSizeHeight);
            }
        }
        if (this.config.isSlide && this.iconRes2_selected != 0) {
            canvas.drawBitmap(this.mBitmap, this.rect, this.rectF, this.mUnSelectedIconPaint);
            canvas.drawBitmap(this.bitmap_selected, this.rect, this.rectF, this.mSelectedIconPaint);
            return;
        }
        if (this.iconRes2_selected != 0) {
            if (this.isSelected) {
                canvas.drawBitmap(this.bitmap_selected, this.rect, this.rectF, this.mPaint);
            } else {
                canvas.drawBitmap(this.mBitmap, this.rect, this.rectF, this.mPaint);
            }
            return;
        }
        canvas.drawBitmap(this.mBitmap, this.rect, this.rectF, this.mPaint);
    }

    private void drawShiftedText(Canvas canvas) {
        if (this.isRefresh) {
            if (this.isSelected) {
                this.updateTextPaint((float)this.mActiveTextSize * this.animatedFraction);
            } else {
                this.updateTextPaint((float)this.mActiveTextSize - (float)this.mActiveTextSize * this.animatedFraction);
            }
            canvas.drawText(this.title, (float)(this.getWidth() / 2 - this.textRect.width() / 2), (float)BarUtils.dip2px(this.getContext(), 46.0f), this.mPaint);
            return;
        }
        if (this.mPosition != 0 && this.textRect.isEmpty()) {
            return;
        }
        if (this.textRect.isEmpty()) {
            this.mPaint.getTextBounds(this.title, 0, this.title.length(), this.textRect);
        }
        canvas.drawText(this.title, (float)(this.getWidth() / 2 - this.textRect.width() / 2), (float)BarUtils.dip2px(this.getContext(), 46.0f), this.mPaint);
    }

    private void drawShiftedIcon(Canvas canvas) {
        if (this.isRefresh) {
            if (this.iconRes2_selected != 0) {
                canvas.drawBitmap(this.mBitmap, this.rect, this.rectF, this.mUnSelectedIconPaint);
                canvas.drawBitmap(this.bitmap_selected, this.rect, this.rectF, this.mSelectedIconPaint);
                return;
            }
            canvas.drawBitmap(this.mBitmap, this.rect, this.rectF, this.mPaint);
            return;
        }
        if (this.rectF.isEmpty()) {
            if (this.isSelected) {
                this.rectF.set((float)(this.getWidth() / 2) - this.mIconSizeWidth / 2.0f, (float)this.mActiveMarginTop, (float)(this.getWidth() / 2) + this.mIconSizeWidth / 2.0f, (float)this.mActiveMarginTop + this.mIconSizeHeight);
            } else {
                this.rectF.set((float)(this.getWidth() / 2) - this.mIconSizeWidth / 2.0f, (float)this.mShiftInactiveMarginTop, (float)(this.getWidth() / 2) + this.mIconSizeWidth / 2.0f, (float)this.mShiftInactiveMarginTop + this.mIconSizeHeight);
            }
        }
        if (this.config.isSlide && this.iconRes2_selected != 0) {
            canvas.drawBitmap(this.mBitmap, this.rect, this.rectF, this.mUnSelectedIconPaint);
            canvas.drawBitmap(this.bitmap_selected, this.rect, this.rectF, this.mSelectedIconPaint);
            return;
        }
        if (this.iconRes2_selected != 0) {
            if (this.isSelected) {
                canvas.drawBitmap(this.bitmap_selected, this.rect, this.rectF, this.mPaint);
            } else {
                canvas.drawBitmap(this.mBitmap, this.rect, this.rectF, this.mPaint);
            }
            return;
        }
        canvas.drawBitmap(this.mBitmap, this.rect, this.rectF, this.mPaint);
    }

    private void initPaint() {
        this.mPaint = new Paint(1);
        this.mPaint.setFilterBitmap(true);
        this.mPaint.setTextSize(this.isSelected ? (float)this.mActiveTextSize : (float)this.mInactiveTextSize);
    }

    private void changeColor(@ColorInt int color) {
        if (this.iconRes2_selected != 0) {
            this.mPaint.setColor(color);
            return;
        }
        this.mPaint.setColorFilter((ColorFilter)new PorterDuffColorFilter(color, PorterDuff.Mode.SRC_IN));
        this.mPaint.setColor(color);
    }

    private void changeUnSelectedIconColorFilter(@ColorInt int color) {
        this.mUnSelectedIconPaint.setColorFilter((ColorFilter)new PorterDuffColorFilter(color, PorterDuff.Mode.SRC_IN));
        this.mUnSelectedIconPaint.setColor(color);
    }

    private void changeSelectedIconColorFilter(int color) {
        this.mSelectedIconPaint.setColorFilter((ColorFilter)new PorterDuffColorFilter(color, PorterDuff.Mode.SRC_IN));
        this.mSelectedIconPaint.setColor(color);
    }

    public void translateAnim() {
        ValueAnimator valueAnimator;
        this.isSliding = false;
        if (this.isSelected) {
            valueAnimator = ValueAnimator.ofFloat((float[])new float[]{this.inActiveItemWidth, this.activeItemWidth});
        } else {
            if (this.inActiveItemWidth == this.getWidth() || Math.abs(this.getWidth() - this.inActiveItemWidth) <= 10) {
                return;
            }
            valueAnimator = ValueAnimator.ofFloat((float[])new float[]{this.getWidth(), this.inActiveItemWidth});
        }
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float animatedValue = ((Float)animation.getAnimatedValue()).floatValue();
                BottomNavigationItem.this.animatedFraction = animation.getAnimatedFraction();
                float change = BottomNavigationItem.this.animatedFraction * (float)(BottomNavigationItem.this.mShiftInactiveMarginTop - BottomNavigationItem.this.mActiveMarginTop);
                if (BottomNavigationItem.this.isSelected) {
                    BottomNavigationItem.this.rectF.set(animatedValue / 2.0f - BottomNavigationItem.this.mIconSizeWidth / 2.0f, (float)BottomNavigationItem.this.mShiftInactiveMarginTop - change, animatedValue / 2.0f + BottomNavigationItem.this.mIconSizeWidth / 2.0f, (float)BottomNavigationItem.this.mShiftInactiveMarginTop - change + BottomNavigationItem.this.mIconSizeHeight);
                    ((BottomNavigationItemWithDot)BottomNavigationItem.this.getParent()).setDotTop((int)((float)BottomNavigationItem.this.mShiftInactiveMarginTop - change));
                } else {
                    BottomNavigationItem.this.rectF.set(animatedValue / 2.0f - BottomNavigationItem.this.mIconSizeWidth / 2.0f, (float)BottomNavigationItem.this.mActiveMarginTop + change, animatedValue / 2.0f + BottomNavigationItem.this.mIconSizeWidth / 2.0f, (float)BottomNavigationItem.this.mActiveMarginTop + change + BottomNavigationItem.this.mIconSizeHeight);
                    ((BottomNavigationItemWithDot)BottomNavigationItem.this.getParent()).setDotTop((int)((float)BottomNavigationItem.this.mActiveMarginTop + change));
                }
                BottomNavigationItem.this.isRefresh = true;
                BottomNavigationItem.this.updateItemWidth(((Float)animation.getAnimatedValue()).floatValue());
            }
        });
        valueAnimator.setDuration(150L);
        valueAnimator.setInterpolator((TimeInterpolator)new FastOutSlowInInterpolator());
        valueAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                valueAnimator.removeListener((Animator.AnimatorListener)this);
                BottomNavigationItem.this.correctItemData(BottomNavigationItem.this.isSelected, true);
                BottomNavigationItem.this.isRefresh = false;
            }
        });
        valueAnimator.start();
    }

    private void updateItemWidth(float currentWidth) {
        ViewGroup.LayoutParams params = this.getLayoutParams();
        if (params == null) {
            return;
        }
        params.width = Math.round(currentWidth);
        this.setLayoutParams(params);
        this.refreshView();
    }

    private AppCompatActivity getActivity() {
        return (AppCompatActivity)this.getContext();
    }

    public Fragment getFragment() {
        if (this.mFragment == null) {
            throw new RuntimeException("the fragment is null");
        }
        return this.mFragment;
    }

    public void setFragment(String fragmentPackageName) {
        if (TextUtils.isEmpty((CharSequence)this.tag)) {
            this.tag = fragmentPackageName;
        }
        this.mFragment = this.getActivity().getSupportFragmentManager().findFragmentByTag(fragmentPackageName);
        if (this.mFragment != null) {
            this.getActivity().getSupportFragmentManager().beginTransaction().hide(this.mFragment).commitAllowingStateLoss();
        } else {
            try {
                Class<?> aClass = Class.forName(fragmentPackageName);
                this.mFragment = (Fragment)aClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                throw new RuntimeException("you may provide a wrong fragment's packageName");
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    public void setIsViewPager(boolean isViewPager) {
        this.isViewPager = isViewPager;
    }

    protected void onVisibilityChanged(View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        if (visibility == 0 && this.config.isSlide) {
            this.correctItemData(this.isSelected, false);
        }
    }

    public BottomNavigationItem setHasCorrect(boolean hasCorrect) {
        this.hasCorrect = hasCorrect;
        return this;
    }

    public static class Config {
        private int activeColor;
        private int inActiveColor;
        private int itemBackGroundRes;
        private int switchMode;
        private boolean isSlide;

        public Config(Build build) {
            this.activeColor = build.activeColor;
            this.inActiveColor = build.inActiveColor;
            this.itemBackGroundRes = build.itemBackGroundRes;
            this.switchMode = build.switchMode;
            this.isSlide = build.isSlide;
        }

        public int getSwitchMode() {
            return this.switchMode;
        }

        public static class Build {
            private int activeColor;
            private int inActiveColor;
            private int itemBackGroundRes;
            private int switchMode;
            private boolean isSlide;

            public Build setActiveColor(int activeColor) {
                this.activeColor = activeColor;
                return this;
            }

            public Build setInActiveColor(int inActiveColor) {
                this.inActiveColor = inActiveColor;
                return this;
            }

            public Build setItemBackGroundRes(int itemBackGroundRes) {
                this.itemBackGroundRes = itemBackGroundRes;
                return this;
            }

            public Build setSwitchMode(int switchMode) {
                this.switchMode = switchMode;
                return this;
            }

            public Build setIsSlide(boolean isSlide) {
                this.isSlide = isSlide;
                return this;
            }

            public Config build() {
                return new Config(this);
            }
        }
    }
}

