/*
 * Decompiled with CFR 0.152.
 */
package com.wakehao.bar;

import android.content.Context;
import android.content.res.Resources;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.wakehao.bar.BarUtils;
import com.wakehao.bar.BottomNavigationBar;
import com.wakehao.bar.BottomNavigationItem;
import com.wakehao.bar.BottomNavigationItemWithDot;
import com.wakehao.bar.R;
import java.util.List;

public class BottomNavigationBarContent
extends LinearLayout {
    private final int mBottomNavigationBarHeight;
    private final int mActiveItemMaxWidth;
    private final int mActiveItemMinWidth;
    private final int mInactiveItemMaxWidth;
    private final int mInactiveItemMinWidth;
    private int mActivePosition = 0;
    private View.OnClickListener mOnClickListener;
    private int[] widthSpec;
    private int mSwitchMode;
    private int counts;
    private long LIMIT_OF_CLICK;
    private float downX;
    private float downY;
    private ViewPager viewPager;
    private BottomNavigationBar.OnNavigationItemSelectedListener mListener;

    public BottomNavigationBarContent(Context context) {
        this(context, null);
    }

    private BottomNavigationBarContent(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    private BottomNavigationBarContent(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        Resources res = this.getResources();
        this.mActiveItemMaxWidth = res.getDimensionPixelSize(R.dimen.bar_active_item_max_width);
        this.mActiveItemMinWidth = res.getDimensionPixelSize(R.dimen.bar_active_item_min_width);
        this.mBottomNavigationBarHeight = res.getDimensionPixelSize(R.dimen.bar_height);
        this.mInactiveItemMinWidth = res.getDimensionPixelSize(R.dimen.bar_inactive_item_min_width);
        this.mInactiveItemMaxWidth = res.getDimensionPixelSize(R.dimen.bar_inactive_item_max_width);
        this.mOnClickListener = new View.OnClickListener(){

            public void onClick(View v) {
                BottomNavigationItem item = (BottomNavigationItem)v;
                if ((BottomNavigationBarContent.this.mListener == null || BottomNavigationBarContent.this.mListener != null && BottomNavigationBarContent.this.mListener.onNavigationItemSelected(item, item.getPosition())) && System.currentTimeMillis() - BottomNavigationBarContent.this.LIMIT_OF_CLICK >= 150L) {
                    if (BottomNavigationBarContent.this.viewPager == null) {
                        BottomNavigationBarContent.this.setItemSelected(item.getPosition(), true);
                        BottomNavigationBarContent.this.LIMIT_OF_CLICK = System.currentTimeMillis();
                    } else if (((BottomNavigationBar)BottomNavigationBarContent.this.getParent()).getCanClick()) {
                        BottomNavigationBarContent.this.viewPager.setCurrentItem(item.getPosition(), false);
                        BottomNavigationBarContent.this.setItemSelected(item.getPosition(), true);
                        BottomNavigationBarContent.this.LIMIT_OF_CLICK = System.currentTimeMillis();
                    }
                }
            }
        };
        this.setId(R.id.bar_content_private);
    }

    public void setItemSelected(int position, boolean isAnim) {
        if (this.mActivePosition == position) {
            if (this.mListener != null) {
                this.mListener.onNavigationItemSelectedAgain(this.getBottomItem(position), position);
            }
            return;
        }
        int shiftedColor = ((BottomNavigationItem)((BottomNavigationItemWithDot)this.getChildAt(position)).getChildAt(0)).getShiftedColor();
        if (shiftedColor != 0) {
            ((BottomNavigationBar)this.getParent()).drawBackgroundCircle(shiftedColor, this.downX, this.downY);
        }
        this.mActivePosition = position;
        for (int i = 0; i < this.getChildCount(); ++i) {
            BottomNavigationItem item = (BottomNavigationItem)((BottomNavigationItemWithDot)this.getChildAt(i)).getChildAt(0);
            item.setSelected(i == position, isAnim);
        }
    }

    void updatePosition(int mActivePosition) {
        this.mActivePosition = mActivePosition;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (ev.getAction() == 0) {
            this.downX = ev.getRawX();
            this.downY = ev.getY();
        }
        return super.onInterceptTouchEvent(ev);
    }

    public void setItems(List<BottomNavigationItem> bottomNavigationItems) {
        int remain;
        int inActiveItem;
        int activeItem;
        int remain_activeMax;
        this.setOrientation(0);
        this.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, this.mBottomNavigationBarHeight));
        this.counts = bottomNavigationItems.size();
        this.widthSpec = new int[this.counts];
        int screenWidth = BarUtils.getDeviceWidth(this.getContext());
        if (this.mSwitchMode == 1) {
            remain_activeMax = screenWidth - (this.counts - 1) * this.mInactiveItemMinWidth;
            activeItem = Math.min(this.mActiveItemMaxWidth, remain_activeMax);
            if (activeItem < this.mActiveItemMinWidth) {
                activeItem = this.mActiveItemMinWidth;
            }
            int remain_inActiveMax = (screenWidth - activeItem) / (this.counts - 1);
            inActiveItem = Math.min(this.mInactiveItemMaxWidth, remain_inActiveMax);
            remain = screenWidth - activeItem - (this.counts - 1) * inActiveItem;
        } else {
            remain_activeMax = screenWidth / this.counts;
            inActiveItem = activeItem = Math.min(this.mActiveItemMaxWidth, remain_activeMax);
            remain = screenWidth - activeItem * this.counts;
        }
        for (int i = 0; i < this.counts; ++i) {
            int n = this.widthSpec[i] = this.mActivePosition == i ? activeItem : inActiveItem;
            if (remain > 0) {
                int n2 = i;
                this.widthSpec[n2] = this.widthSpec[n2] + 1;
                --remain;
            }
            BottomNavigationItem item = bottomNavigationItems.get(i);
            item.setClickable(true);
            item.setPosition(i);
            item.setOnClickListener(this.mOnClickListener);
            item.setActiveItemWidth(activeItem);
            item.setInActiveItemWidth(inActiveItem);
            LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(this.widthSpec[i], this.mBottomNavigationBarHeight);
            item.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            this.addView((View)new BottomNavigationItemWithDot(this.getContext(), item));
        }
    }

    public void setViewPager(ViewPager viewPager) {
        this.viewPager = viewPager;
    }

    public void injectListener(BottomNavigationBar.OnNavigationItemSelectedListener mListener) {
        this.mListener = mListener;
    }

    public void finishInit(List<BottomNavigationItem> bottomNavigationItems, boolean isViewpager) {
        for (BottomNavigationItem item : bottomNavigationItems) {
            item.setIsViewPager(isViewpager);
            item.finishInit();
        }
    }

    public BottomNavigationBarContent setSwitchMode(int mSwitchMode) {
        this.mSwitchMode = mSwitchMode;
        return this;
    }

    public void startAlphaAnim(int position, float positionOffset, boolean isMoving) {
        if (isMoving) {
            this.getBottomItem(position).setHasCorrect(false).alphaAnim(positionOffset);
            this.getBottomItem(position + 1).setHasCorrect(false).alphaAnim(1.0f - positionOffset);
        } else {
            this.getBottomItem(position).alphaAnim(positionOffset);
            this.getBottomItem(position + 1).alphaAnim(1.0f - positionOffset);
        }
    }

    public BottomNavigationItem getBottomItem(int position) {
        return (BottomNavigationItem)((BottomNavigationItemWithDot)this.getChildAt(position)).getChildAt(0);
    }

    protected Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putInt("mActivePosition", this.mActivePosition);
        bundle.putParcelable("superState", super.onSaveInstanceState());
        return bundle;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            int mRestoreActivePosition = bundle.getInt("mActivePosition");
            this.setItemSelected(mRestoreActivePosition, true);
            state = bundle.getParcelable("superState");
        }
        super.onRestoreInstanceState(state);
    }
}

