/*
 * Decompiled with CFR 0.152.
 */
package com.chanven.lib.cptr.loadmore;

import android.support.v4.widget.SwipeRefreshLayout;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.widget.AbsListView;
import android.widget.GridView;
import com.chanven.lib.cptr.loadmore.DefaultLoadMoreViewFooter;
import com.chanven.lib.cptr.loadmore.GridViewHandler;
import com.chanven.lib.cptr.loadmore.ILoadMoreViewFactory;
import com.chanven.lib.cptr.loadmore.ListViewHandler;
import com.chanven.lib.cptr.loadmore.LoadMoreHandler;
import com.chanven.lib.cptr.loadmore.OnLoadMoreListener;
import com.chanven.lib.cptr.loadmore.OnScrollBottomListener;
import com.chanven.lib.cptr.loadmore.RecyclerViewHandler;
import java.lang.reflect.Field;

public class SwipeRefreshHelper {
    private SwipeRefreshLayout mSwipeRefreshLayout;
    private View mContentView;
    private OnSwipeRefreshListener mOnSwipeRefreshListener;
    private LoadMoreHandler mLoadMoreHandler;
    private boolean isLoadingMore = false;
    private boolean isAutoLoadMoreEnable = true;
    private boolean isLoadMoreEnable = false;
    private boolean hasInitLoadMoreView = false;
    private ILoadMoreViewFactory loadMoreViewFactory = new DefaultLoadMoreViewFooter();
    private OnLoadMoreListener mOnLoadMoreListener;
    private ILoadMoreViewFactory.ILoadMoreView mLoadMoreView;
    private SwipeRefreshLayout.OnRefreshListener mOnRefreshListener = new SwipeRefreshLayout.OnRefreshListener(){

        public void onRefresh() {
            if (null != SwipeRefreshHelper.this.mOnSwipeRefreshListener) {
                SwipeRefreshHelper.this.mOnSwipeRefreshListener.onfresh();
            }
        }
    };
    private OnScrollBottomListener onScrollBottomListener = new OnScrollBottomListener(){

        @Override
        public void onScorllBootom() {
            if (SwipeRefreshHelper.this.isAutoLoadMoreEnable && SwipeRefreshHelper.this.isLoadMoreEnable && !SwipeRefreshHelper.this.isLoadingMore()) {
                SwipeRefreshHelper.this.loadMore();
            }
        }
    };
    private View.OnClickListener onClickLoadMoreListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (SwipeRefreshHelper.this.isLoadMoreEnable && !SwipeRefreshHelper.this.isLoadingMore()) {
                SwipeRefreshHelper.this.loadMore();
            }
        }
    };

    public void autoRefresh() {
        if (null != this.mOnSwipeRefreshListener) {
            this.mSwipeRefreshLayout.setRefreshing(true);
            this.mOnSwipeRefreshListener.onfresh();
        }
    }

    public SwipeRefreshHelper(SwipeRefreshLayout refreshLayout) {
        this.mSwipeRefreshLayout = refreshLayout;
        this.init();
    }

    private void init() {
        if (this.mSwipeRefreshLayout.getChildCount() <= 0) {
            throw new RuntimeException("SwipRefreshLayout has no child view");
        }
        try {
            Field field = this.mSwipeRefreshLayout.getClass().getDeclaredField("mTarget");
            field.setAccessible(true);
            this.mContentView = (View)field.get(this.mSwipeRefreshLayout);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setOnSwipeRefreshListener(OnSwipeRefreshListener onSwipeRefreshListener) {
        this.mOnSwipeRefreshListener = onSwipeRefreshListener;
        this.mSwipeRefreshLayout.setOnRefreshListener(this.mOnRefreshListener);
    }

    public void setOnLoadMoreListener(OnLoadMoreListener onLoadMoreListener) {
        this.mOnLoadMoreListener = onLoadMoreListener;
    }

    public void refreshComplete() {
        this.mSwipeRefreshLayout.setRefreshing(false);
    }

    public void setFooterView(ILoadMoreViewFactory factory) {
        if (null == factory || null != this.loadMoreViewFactory && this.loadMoreViewFactory == factory) {
            return;
        }
        this.loadMoreViewFactory = factory;
        if (this.hasInitLoadMoreView) {
            this.mLoadMoreHandler.removeFooter();
            this.mLoadMoreView = this.loadMoreViewFactory.madeLoadMoreView();
            this.hasInitLoadMoreView = this.mLoadMoreHandler.handleSetAdapter(this.mContentView, this.mLoadMoreView, this.onClickLoadMoreListener);
            if (!this.isLoadMoreEnable) {
                this.mLoadMoreHandler.removeFooter();
            }
        }
    }

    public void setLoadMoreEnable(boolean enable) {
        if (this.isLoadMoreEnable == enable) {
            return;
        }
        this.isLoadMoreEnable = enable;
        if (!this.hasInitLoadMoreView && this.isLoadMoreEnable) {
            this.mLoadMoreView = this.loadMoreViewFactory.madeLoadMoreView();
            if (null == this.mLoadMoreHandler) {
                if (this.mContentView instanceof GridView) {
                    this.mLoadMoreHandler = new GridViewHandler();
                } else if (this.mContentView instanceof AbsListView) {
                    this.mLoadMoreHandler = new ListViewHandler();
                } else if (this.mContentView instanceof RecyclerView) {
                    this.mLoadMoreHandler = new RecyclerViewHandler();
                }
            }
            if (null == this.mLoadMoreHandler) {
                throw new IllegalStateException("unSupported contentView !");
            }
            this.hasInitLoadMoreView = this.mLoadMoreHandler.handleSetAdapter(this.mContentView, this.mLoadMoreView, this.onClickLoadMoreListener);
            this.mLoadMoreHandler.setOnScrollBottomListener(this.mContentView, this.onScrollBottomListener);
            return;
        }
        if (this.hasInitLoadMoreView) {
            if (this.isLoadMoreEnable) {
                this.mLoadMoreHandler.addFooter();
            } else {
                this.mLoadMoreHandler.removeFooter();
            }
        }
    }

    public boolean isLoadMoreEnable() {
        return this.isLoadMoreEnable;
    }

    public void setAutoLoadMoreEnable(boolean isAutoLoadMoreEnable) {
        this.isAutoLoadMoreEnable = isAutoLoadMoreEnable;
    }

    private void loadMore() {
        this.isLoadingMore = true;
        this.mLoadMoreView.showLoading();
        if (null != this.mOnLoadMoreListener) {
            this.mOnLoadMoreListener.loadMore();
        }
    }

    public void loadMoreComplete(boolean hasMore) {
        this.isLoadingMore = false;
        if (hasMore) {
            this.mLoadMoreView.showNormal();
        } else {
            this.setNoMoreData();
        }
    }

    public void setNoMoreData() {
        this.isLoadingMore = false;
        this.mLoadMoreView.showNomore();
    }

    public boolean isLoadingMore() {
        return this.isLoadingMore;
    }

    public static interface OnSwipeRefreshListener {
        public void onfresh();
    }
}

