/*
 * Decompiled with CFR 0.152.
 */
package com.chanven.lib.cptr.loadmore;

import android.content.Context;
import android.os.Build;
import android.support.v4.view.ViewCompat;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.chanven.lib.cptr.loadmore.ILoadMoreViewFactory;
import com.chanven.lib.cptr.loadmore.LoadMoreHandler;
import com.chanven.lib.cptr.loadmore.OnScrollBottomListener;
import com.chanven.lib.cptr.recyclerview.RecyclerAdapterWithHF;

public class RecyclerViewHandler
implements LoadMoreHandler {
    private RecyclerAdapterWithHF mRecyclerAdapter;
    private View mFooter;

    @Override
    public boolean handleSetAdapter(View contentView, ILoadMoreViewFactory.ILoadMoreView loadMoreView, View.OnClickListener onClickLoadMoreListener) {
        final RecyclerView recyclerView = (RecyclerView)contentView;
        boolean hasInit = false;
        this.mRecyclerAdapter = (RecyclerAdapterWithHF)recyclerView.getAdapter();
        if (loadMoreView != null) {
            final Context context = recyclerView.getContext().getApplicationContext();
            loadMoreView.init(new ILoadMoreViewFactory.FootViewAdder(){

                @Override
                public View addFootView(int layoutId) {
                    View view = LayoutInflater.from((Context)context).inflate(layoutId, (ViewGroup)recyclerView, false);
                    RecyclerViewHandler.this.mFooter = view;
                    return this.addFootView(view);
                }

                @Override
                public View addFootView(View view) {
                    RecyclerViewHandler.this.mRecyclerAdapter.addFooter(view);
                    return view;
                }
            }, onClickLoadMoreListener);
            hasInit = true;
        }
        return hasInit;
    }

    @Override
    public void addFooter() {
        if (this.mRecyclerAdapter.getFootSize() <= 0 && null != this.mFooter) {
            this.mRecyclerAdapter.addFooter(this.mFooter);
        }
    }

    @Override
    public void removeFooter() {
        if (this.mRecyclerAdapter.getFootSize() > 0 && null != this.mFooter) {
            this.mRecyclerAdapter.removeFooter(this.mFooter);
        }
    }

    @Override
    public void setOnScrollBottomListener(View contentView, OnScrollBottomListener onScrollBottomListener) {
        RecyclerView recyclerView = (RecyclerView)contentView;
        recyclerView.addOnScrollListener((RecyclerView.OnScrollListener)new RecyclerViewOnScrollListener(onScrollBottomListener));
    }

    private static class RecyclerViewOnScrollListener
    extends RecyclerView.OnScrollListener {
        private OnScrollBottomListener onScrollBottomListener;

        public RecyclerViewOnScrollListener(OnScrollBottomListener onScrollBottomListener) {
            this.onScrollBottomListener = onScrollBottomListener;
        }

        public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
            if (newState == 0 && this.isScollBottom(recyclerView) && this.onScrollBottomListener != null) {
                this.onScrollBottomListener.onScorllBootom();
            }
        }

        private boolean isScollBottom(RecyclerView recyclerView) {
            return !this.isCanScollVertically(recyclerView);
        }

        private boolean isCanScollVertically(RecyclerView recyclerView) {
            if (Build.VERSION.SDK_INT < 14) {
                return ViewCompat.canScrollVertically((View)recyclerView, (int)1) || recyclerView.getScrollY() < recyclerView.getHeight();
            }
            return ViewCompat.canScrollVertically((View)recyclerView, (int)1);
        }

        public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
        }
    }
}

