/*
 * Decompiled with CFR 0.152.
 */
package com.chanven.lib.cptr.loadmore;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import com.chanven.lib.cptr.loadmore.GridViewWithHeaderAndFooter;
import com.chanven.lib.cptr.loadmore.ILoadMoreViewFactory;
import com.chanven.lib.cptr.loadmore.LoadMoreHandler;
import com.chanven.lib.cptr.loadmore.OnScrollBottomListener;

public class GridViewHandler
implements LoadMoreHandler {
    private GridViewWithHeaderAndFooter mGridView;
    private View mFooter;

    @Override
    public boolean handleSetAdapter(View contentView, ILoadMoreViewFactory.ILoadMoreView loadMoreView, View.OnClickListener onClickLoadMoreListener) {
        this.mGridView = (GridViewWithHeaderAndFooter)contentView;
        ListAdapter adapter = this.mGridView.getAdapter();
        boolean hasInit = false;
        if (loadMoreView != null) {
            final Context context = this.mGridView.getContext().getApplicationContext();
            loadMoreView.init(new ILoadMoreViewFactory.FootViewAdder(){

                @Override
                public View addFootView(int layoutId) {
                    View view = LayoutInflater.from((Context)context).inflate(layoutId, (ViewGroup)GridViewHandler.this.mGridView, false);
                    GridViewHandler.this.mFooter = view;
                    return this.addFootView(view);
                }

                @Override
                public View addFootView(View view) {
                    GridViewHandler.this.mGridView.addFooterView(view);
                    return view;
                }
            }, onClickLoadMoreListener);
            hasInit = true;
            if (null != adapter) {
                this.mGridView.setAdapter(adapter);
            }
        }
        return hasInit;
    }

    @Override
    public void addFooter() {
        if (this.mGridView.getFooterViewCount() <= 0 && null != this.mFooter) {
            this.mGridView.addFooterView(this.mFooter);
        }
    }

    @Override
    public void removeFooter() {
        if (this.mGridView.getFooterViewCount() > 0 && null != this.mFooter) {
            this.mGridView.removeFooterView(this.mFooter);
        }
    }

    @Override
    public void setOnScrollBottomListener(View contentView, OnScrollBottomListener onScrollBottomListener) {
        GridViewWithHeaderAndFooter gridView = (GridViewWithHeaderAndFooter)contentView;
        gridView.setOnScrollListener(new GridViewOnScrollListener(onScrollBottomListener));
        gridView.setOnItemSelectedListener(new GridViewOnItemSelectedListener(onScrollBottomListener));
    }

    private static class GridViewOnScrollListener
    implements AbsListView.OnScrollListener {
        private OnScrollBottomListener onScrollBottomListener;

        public GridViewOnScrollListener(OnScrollBottomListener onScrollBottomListener) {
            this.onScrollBottomListener = onScrollBottomListener;
        }

        public void onScrollStateChanged(AbsListView view, int scrollState) {
            if (scrollState == 0 && view.getLastVisiblePosition() + 1 == view.getCount() && this.onScrollBottomListener != null) {
                this.onScrollBottomListener.onScorllBootom();
            }
        }

        public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        }
    }

    private class GridViewOnItemSelectedListener
    implements AdapterView.OnItemSelectedListener {
        private OnScrollBottomListener onScrollBottomListener;

        public GridViewOnItemSelectedListener(OnScrollBottomListener onScrollBottomListener) {
            this.onScrollBottomListener = onScrollBottomListener;
        }

        public void onItemSelected(AdapterView<?> adapterView, View view, int position, long id2) {
            if (adapterView.getLastVisiblePosition() + 1 == adapterView.getCount() && this.onScrollBottomListener != null) {
                this.onScrollBottomListener.onScorllBootom();
            }
        }

        public void onNothingSelected(AdapterView<?> parent) {
        }
    }
}

