/*
 * Decompiled with CFR 0.152.
 */
package com.chanven.lib.cptr.header;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.Transformation;
import com.chanven.lib.cptr.PtrFrameLayout;
import com.chanven.lib.cptr.PtrUIHandler;
import com.chanven.lib.cptr.header.StoreHouseBarItem;
import com.chanven.lib.cptr.header.StoreHousePath;
import com.chanven.lib.cptr.indicator.PtrIndicator;
import com.chanven.lib.cptr.utils.PtrLocalDisplay;
import java.util.ArrayList;

public class StoreHouseHeader
extends View
implements PtrUIHandler {
    public ArrayList<StoreHouseBarItem> mItemList = new ArrayList();
    private int mLineWidth = -1;
    private float mScale = 1.0f;
    private int mDropHeight = -1;
    private float mInternalAnimationFactor = 0.7f;
    private int mHorizontalRandomness = -1;
    private float mProgress = 0.0f;
    private int mDrawZoneWidth = 0;
    private int mDrawZoneHeight = 0;
    private int mOffsetX = 0;
    private int mOffsetY = 0;
    private float mBarDarkAlpha = 0.4f;
    private float mFromAlpha = 1.0f;
    private float mToAlpha = 0.4f;
    private int mLoadingAniDuration = 1000;
    private int mLoadingAniSegDuration = 1000;
    private int mLoadingAniItemDuration = 400;
    private Transformation mTransformation = new Transformation();
    private boolean mIsInLoading = false;
    private AniController mAniController = new AniController();
    private int mTextColor = -1;

    public StoreHouseHeader(Context context) {
        super(context);
        this.initView();
    }

    public StoreHouseHeader(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public StoreHouseHeader(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView();
    }

    private void initView() {
        PtrLocalDisplay.init(this.getContext());
        this.mLineWidth = PtrLocalDisplay.dp2px(1.0f);
        this.mDropHeight = PtrLocalDisplay.dp2px(40.0f);
        this.mHorizontalRandomness = PtrLocalDisplay.SCREEN_WIDTH_PIXELS / 2;
    }

    private void setProgress(float progress) {
        this.mProgress = progress;
    }

    public int getLoadingAniDuration() {
        return this.mLoadingAniDuration;
    }

    public void setLoadingAniDuration(int duration) {
        this.mLoadingAniDuration = duration;
        this.mLoadingAniSegDuration = duration;
    }

    public StoreHouseHeader setLineWidth(int width) {
        this.mLineWidth = width;
        for (int i = 0; i < this.mItemList.size(); ++i) {
            this.mItemList.get(i).setLineWidth(width);
        }
        return this;
    }

    public StoreHouseHeader setTextColor(int color) {
        this.mTextColor = color;
        for (int i = 0; i < this.mItemList.size(); ++i) {
            this.mItemList.get(i).setColor(color);
        }
        return this;
    }

    public StoreHouseHeader setDropHeight(int height) {
        this.mDropHeight = height;
        return this;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int height = this.getTopOffset() + this.mDrawZoneHeight + this.getBottomOffset();
        heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000);
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.mOffsetX = (this.getMeasuredWidth() - this.mDrawZoneWidth) / 2;
        this.mOffsetY = this.getTopOffset();
        this.mDropHeight = this.getTopOffset();
    }

    private int getTopOffset() {
        return this.getPaddingTop() + PtrLocalDisplay.dp2px(10.0f);
    }

    private int getBottomOffset() {
        return this.getPaddingBottom() + PtrLocalDisplay.dp2px(10.0f);
    }

    public void initWithString(String str) {
        this.initWithString(str, 25);
    }

    public void initWithString(String str, int fontSize) {
        ArrayList<float[]> pointList = StoreHousePath.getPath(str, (float)fontSize * 0.01f, 14);
        this.initWithPointList(pointList);
    }

    public void initWithStringArray(int id) {
        String[] points = this.getResources().getStringArray(id);
        ArrayList<float[]> pointList = new ArrayList<float[]>();
        for (int i = 0; i < points.length; ++i) {
            String[] x = points[i].split(",");
            float[] f = new float[4];
            for (int j = 0; j < 4; ++j) {
                f[j] = Float.parseFloat(x[j]);
            }
            pointList.add(f);
        }
        this.initWithPointList(pointList);
    }

    public float getScale() {
        return this.mScale;
    }

    public void setScale(float scale) {
        this.mScale = scale;
    }

    public void initWithPointList(ArrayList<float[]> pointList) {
        float drawWidth = 0.0f;
        float drawHeight = 0.0f;
        boolean shouldLayout = this.mItemList.size() > 0;
        this.mItemList.clear();
        for (int i = 0; i < pointList.size(); ++i) {
            float[] line = pointList.get(i);
            PointF startPoint = new PointF((float)PtrLocalDisplay.dp2px(line[0]) * this.mScale, (float)PtrLocalDisplay.dp2px(line[1]) * this.mScale);
            PointF endPoint = new PointF((float)PtrLocalDisplay.dp2px(line[2]) * this.mScale, (float)PtrLocalDisplay.dp2px(line[3]) * this.mScale);
            drawWidth = Math.max(drawWidth, startPoint.x);
            drawWidth = Math.max(drawWidth, endPoint.x);
            drawHeight = Math.max(drawHeight, startPoint.y);
            drawHeight = Math.max(drawHeight, endPoint.y);
            StoreHouseBarItem item = new StoreHouseBarItem(i, startPoint, endPoint, this.mTextColor, this.mLineWidth);
            item.resetPosition(this.mHorizontalRandomness);
            this.mItemList.add(item);
        }
        this.mDrawZoneWidth = (int)Math.ceil(drawWidth);
        this.mDrawZoneHeight = (int)Math.ceil(drawHeight);
        if (shouldLayout) {
            this.requestLayout();
        }
    }

    private void beginLoading() {
        this.mIsInLoading = true;
        this.mAniController.start();
        this.invalidate();
    }

    private void loadFinish() {
        this.mIsInLoading = false;
        this.mAniController.stop();
    }

    public void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        float progress = this.mProgress;
        int c1 = canvas.save();
        int len = this.mItemList.size();
        for (int i = 0; i < len; ++i) {
            canvas.save();
            StoreHouseBarItem storeHouseBarItem = this.mItemList.get(i);
            float offsetX = (float)this.mOffsetX + storeHouseBarItem.midPoint.x;
            float offsetY = (float)this.mOffsetY + storeHouseBarItem.midPoint.y;
            if (this.mIsInLoading) {
                storeHouseBarItem.getTransformation(this.getDrawingTime(), this.mTransformation);
                canvas.translate(offsetX, offsetY);
            } else {
                if (progress == 0.0f) {
                    storeHouseBarItem.resetPosition(this.mHorizontalRandomness);
                    continue;
                }
                float startPadding = (1.0f - this.mInternalAnimationFactor) * (float)i / (float)len;
                float endPadding = 1.0f - this.mInternalAnimationFactor - startPadding;
                if (progress == 1.0f || progress >= 1.0f - endPadding) {
                    canvas.translate(offsetX, offsetY);
                    storeHouseBarItem.setAlpha(this.mBarDarkAlpha);
                } else {
                    float realProgress = progress <= startPadding ? 0.0f : Math.min(1.0f, (progress - startPadding) / this.mInternalAnimationFactor);
                    offsetX += storeHouseBarItem.translationX * (1.0f - realProgress);
                    offsetY += (float)(-this.mDropHeight) * (1.0f - realProgress);
                    Matrix matrix = new Matrix();
                    matrix.postRotate(360.0f * realProgress);
                    matrix.postScale(realProgress, realProgress);
                    matrix.postTranslate(offsetX, offsetY);
                    storeHouseBarItem.setAlpha(this.mBarDarkAlpha * realProgress);
                    canvas.concat(matrix);
                }
            }
            storeHouseBarItem.draw(canvas);
            canvas.restore();
        }
        if (this.mIsInLoading) {
            this.invalidate();
        }
        canvas.restoreToCount(c1);
    }

    @Override
    public void onUIReset(PtrFrameLayout frame) {
        this.loadFinish();
        for (int i = 0; i < this.mItemList.size(); ++i) {
            this.mItemList.get(i).resetPosition(this.mHorizontalRandomness);
        }
    }

    @Override
    public void onUIRefreshPrepare(PtrFrameLayout frame) {
    }

    @Override
    public void onUIRefreshBegin(PtrFrameLayout frame) {
        this.beginLoading();
    }

    @Override
    public void onUIRefreshComplete(PtrFrameLayout frame) {
        this.loadFinish();
    }

    @Override
    public void onUIPositionChange(PtrFrameLayout frame, boolean isUnderTouch, byte status, PtrIndicator ptrIndicator) {
        float currentPercent = Math.min(1.0f, ptrIndicator.getCurrentPercent());
        this.setProgress(currentPercent);
        this.invalidate();
    }

    private class AniController
    implements Runnable {
        private int mTick = 0;
        private int mCountPerSeg = 0;
        private int mSegCount = 0;
        private int mInterval = 0;
        private boolean mRunning = true;

        private AniController() {
        }

        private void start() {
            this.mRunning = true;
            this.mTick = 0;
            this.mInterval = StoreHouseHeader.this.mLoadingAniDuration / StoreHouseHeader.this.mItemList.size();
            this.mCountPerSeg = StoreHouseHeader.this.mLoadingAniSegDuration / this.mInterval;
            this.mSegCount = StoreHouseHeader.this.mItemList.size() / this.mCountPerSeg + 1;
            this.run();
        }

        @Override
        public void run() {
            int pos = this.mTick % this.mCountPerSeg;
            for (int i = 0; i < this.mSegCount; ++i) {
                int index = i * this.mCountPerSeg + pos;
                if (index > this.mTick) continue;
                StoreHouseBarItem item = StoreHouseHeader.this.mItemList.get(index %= StoreHouseHeader.this.mItemList.size());
                item.setFillAfter(false);
                item.setFillEnabled(true);
                item.setFillBefore(false);
                item.setDuration(StoreHouseHeader.this.mLoadingAniItemDuration);
                item.start(StoreHouseHeader.this.mFromAlpha, StoreHouseHeader.this.mToAlpha);
            }
            ++this.mTick;
            if (this.mRunning) {
                StoreHouseHeader.this.postDelayed(this, this.mInterval);
            }
        }

        private void stop() {
            this.mRunning = false;
            StoreHouseHeader.this.removeCallbacks(this);
        }
    }
}

