/*
 * Decompiled with CFR 0.152.
 */
package com.chanven.lib.cptr.loadmore;

import android.support.v4.widget.SwipeRefreshLayout;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.widget.AbsListView;
import com.chanven.lib.cptr.loadmore.DefaultLoadMoreFooter;
import com.chanven.lib.cptr.loadmore.ILoadViewMoreFactory;
import com.chanven.lib.cptr.loadmore.ListViewHandler;
import com.chanven.lib.cptr.loadmore.OnLoadMoreListener;
import com.chanven.lib.cptr.loadmore.OnScrollBottomListener;
import com.chanven.lib.cptr.loadmore.RecyclerViewHandler;
import java.lang.reflect.Field;

public class SwipeRefreshHelper {
    private SwipeRefreshLayout mSwipeRefreshLayout;
    private View mContentView;
    private OnSwipeRefreshListener mOnSwipeRefreshListener;
    private boolean isLoading = false;
    private boolean isAutoLoadMore = true;
    private boolean isLoadMoreEnable = false;
    private boolean hasInitLoadMoreView = false;
    private ILoadViewMoreFactory loadViewFactory = new DefaultLoadMoreFooter();
    private ListViewHandler listViewHandler = new ListViewHandler();
    private RecyclerViewHandler recyclerViewHandler = new RecyclerViewHandler();
    private OnLoadMoreListener mOnLoadMoreListener;
    private ILoadViewMoreFactory.ILoadMoreView mLoadMoreView;
    private SwipeRefreshLayout.OnRefreshListener mOnRefreshListener = new SwipeRefreshLayout.OnRefreshListener(){

        public void onRefresh() {
            if (null != SwipeRefreshHelper.this.mOnSwipeRefreshListener) {
                SwipeRefreshHelper.this.mOnSwipeRefreshListener.onfresh();
            }
        }
    };
    private OnScrollBottomListener onScrollBottomListener = new OnScrollBottomListener(){

        @Override
        public void onScorllBootom() {
            if (SwipeRefreshHelper.this.isAutoLoadMore && SwipeRefreshHelper.this.isLoadMoreEnable && !SwipeRefreshHelper.this.isLoading()) {
                SwipeRefreshHelper.this.loadMore();
            }
        }
    };
    private View.OnClickListener onClickLoadMoreListener = new View.OnClickListener(){

        public void onClick(View v) {
            SwipeRefreshHelper.this.loadMore();
        }
    };

    public void autoRefresh() {
        if (null != this.mOnSwipeRefreshListener) {
            this.mSwipeRefreshLayout.setRefreshing(true);
            this.mOnSwipeRefreshListener.onfresh();
        }
    }

    public SwipeRefreshHelper(SwipeRefreshLayout refreshLayout) {
        this.mSwipeRefreshLayout = refreshLayout;
        this.init();
    }

    private void init() {
        if (this.mSwipeRefreshLayout.getChildCount() <= 0) {
            throw new RuntimeException("SwipRefreshLayout has no child view");
        }
        try {
            Field field = this.mSwipeRefreshLayout.getClass().getDeclaredField("mTarget");
            field.setAccessible(true);
            this.mContentView = (View)field.get(this.mSwipeRefreshLayout);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setOnSwipeRefreshListener(OnSwipeRefreshListener onSwipeRefreshListener) {
        this.mOnSwipeRefreshListener = onSwipeRefreshListener;
        this.mSwipeRefreshLayout.setOnRefreshListener(this.mOnRefreshListener);
    }

    public void setOnLoadMoreListener(OnLoadMoreListener onLoadMoreListener) {
        this.mOnLoadMoreListener = onLoadMoreListener;
    }

    public void refreshComplete() {
        this.mSwipeRefreshLayout.setRefreshing(false);
    }

    public void setLoadMoreEnable(boolean enable) {
        if (this.isLoadMoreEnable == enable) {
            return;
        }
        this.isLoadMoreEnable = enable;
        if (!this.hasInitLoadMoreView && this.isLoadMoreEnable) {
            this.mLoadMoreView = this.loadViewFactory.madeLoadMoreView();
            if (this.mContentView instanceof AbsListView) {
                this.hasInitLoadMoreView = this.listViewHandler.handleSetAdapter(this.mContentView, this.mLoadMoreView, this.onClickLoadMoreListener);
                this.listViewHandler.setOnScrollBottomListener(this.mContentView, this.onScrollBottomListener);
            } else if (this.mContentView instanceof RecyclerView) {
                this.hasInitLoadMoreView = this.recyclerViewHandler.handleSetAdapter(this.mContentView, this.mLoadMoreView, this.onClickLoadMoreListener);
                this.recyclerViewHandler.setOnScrollBottomListener(this.mContentView, this.onScrollBottomListener);
            }
        }
    }

    private void loadMore() {
        this.isLoading = true;
        this.mLoadMoreView.showLoading();
        if (null != this.mOnLoadMoreListener) {
            this.mOnLoadMoreListener.loadMore();
        }
    }

    public void loadMoreComplete(boolean hasMore) {
        this.isLoading = false;
        if (hasMore) {
            this.mLoadMoreView.showNormal();
        } else {
            this.setNoMoreData();
        }
    }

    public void setNoMoreData() {
        this.isLoading = false;
        this.mLoadMoreView.showNomore();
    }

    public boolean isLoading() {
        return this.isLoading;
    }

    public static interface OnSwipeRefreshListener {
        public void onfresh();
    }
}

