/*
 * Decompiled with CFR 0.152.
 */
package com.chanven.lib.cptr.loadmore;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.ListView;
import com.chanven.lib.cptr.loadmore.ILoadViewMoreFactory;
import com.chanven.lib.cptr.loadmore.OnScrollBottomListener;
import com.chanven.lib.cptr.loadmore.ViewHandler;

public class ListViewHandler
implements ViewHandler {
    @Override
    public boolean handleSetAdapter(View contentView, ILoadViewMoreFactory.ILoadMoreView loadMoreView, View.OnClickListener onClickLoadMoreListener) {
        final ListView listView = (ListView)contentView;
        boolean hasInit = false;
        if (loadMoreView != null) {
            final Context context = listView.getContext().getApplicationContext();
            loadMoreView.init(new ILoadViewMoreFactory.FootViewAdder(){

                @Override
                public View addFootView(int layoutId) {
                    View view = LayoutInflater.from((Context)context).inflate(layoutId, (ViewGroup)listView, false);
                    return this.addFootView(view);
                }

                @Override
                public View addFootView(View view) {
                    listView.addFooterView(view);
                    return view;
                }
            }, onClickLoadMoreListener);
            hasInit = true;
        }
        return hasInit;
    }

    @Override
    public void setOnScrollBottomListener(View contentView, OnScrollBottomListener onScrollBottomListener) {
        ListView listView = (ListView)contentView;
        listView.setOnScrollListener((AbsListView.OnScrollListener)new ListViewOnScrollListener(onScrollBottomListener));
        listView.setOnItemSelectedListener((AdapterView.OnItemSelectedListener)new ListViewOnItemSelectedListener(onScrollBottomListener));
    }

    private static class ListViewOnScrollListener
    implements AbsListView.OnScrollListener {
        private OnScrollBottomListener onScrollBottomListener;

        public ListViewOnScrollListener(OnScrollBottomListener onScrollBottomListener) {
            this.onScrollBottomListener = onScrollBottomListener;
        }

        public void onScrollStateChanged(AbsListView listView, int scrollState) {
            if (scrollState == 0 && listView.getLastVisiblePosition() + 1 == listView.getCount() && this.onScrollBottomListener != null) {
                this.onScrollBottomListener.onScorllBootom();
            }
        }

        public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        }
    }

    private class ListViewOnItemSelectedListener
    implements AdapterView.OnItemSelectedListener {
        private OnScrollBottomListener onScrollBottomListener;

        public ListViewOnItemSelectedListener(OnScrollBottomListener onScrollBottomListener) {
            this.onScrollBottomListener = onScrollBottomListener;
        }

        public void onItemSelected(AdapterView<?> listView, View view, int position, long id2) {
            if (listView.getLastVisiblePosition() + 1 == listView.getCount() && this.onScrollBottomListener != null) {
                this.onScrollBottomListener.onScorllBootom();
            }
        }

        public void onNothingSelected(AdapterView<?> parent) {
        }
    }
}

