/*
 * Decompiled with CFR 0.152.
 */
package com.celerysoft.imagepager.util;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.Log;
import java.io.File;

public class ImageUtil {
    private static final String TAG = ImageUtil.class.getSimpleName();

    public static Bitmap getBitmap(Context context, String filePath) {
        File f = new File(filePath);
        if (!f.exists()) {
            Log.w((String)TAG, (String)("No such file: " + filePath));
            return null;
        }
        Bitmap bitmap = null;
        try {
            int targetWidth = (int)((double)context.getResources().getDisplayMetrics().widthPixels * 0.8);
            int targetHeight = context.getResources().getDisplayMetrics().heightPixels;
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
            int photoWidth = options.outWidth;
            int photoHeight = options.outHeight;
            options.inSampleSize = ImageUtil.calculateInSampleSize(photoWidth, photoHeight, targetWidth, targetHeight);
            options.inJustDecodeBounds = false;
            bitmap = BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
        }
        catch (OutOfMemoryError error) {
            error.printStackTrace();
        }
        return bitmap;
    }

    public static Bitmap getBitmap(Context context, int resId) {
        Bitmap bitmap = null;
        try {
            int targetWidth = (int)((double)context.getResources().getDisplayMetrics().widthPixels * 0.8);
            int targetHeight = context.getResources().getDisplayMetrics().heightPixels;
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeResource((Resources)context.getResources(), (int)resId, (BitmapFactory.Options)options);
            int photoWidth = options.outWidth;
            int photoHeight = options.outHeight;
            options.inSampleSize = ImageUtil.calculateInSampleSize(photoWidth, photoHeight, targetWidth, targetHeight);
            options.inJustDecodeBounds = false;
            bitmap = BitmapFactory.decodeResource((Resources)context.getResources(), (int)resId, (BitmapFactory.Options)options);
        }
        catch (OutOfMemoryError error) {
            error.printStackTrace();
        }
        return bitmap;
    }

    private static int calculateInSampleSize(int originalWidth, int originalHeight, int targetWidth, int targetHeight) {
        int inSampleSize = 1;
        if (originalHeight > targetHeight || originalWidth > targetWidth) {
            inSampleSize <<= 1;
            while (originalHeight / inSampleSize > targetHeight && originalWidth / inSampleSize > targetWidth) {
                inSampleSize <<= 1;
            }
        }
        return inSampleSize;
    }
}

