/*
 * Decompiled with CFR 0.152.
 */
package com.celerysoft.imagepager.adapter;

import android.content.Context;
import android.graphics.Bitmap;
import android.util.Log;
import com.celerysoft.imagepager.adapter.ImagePagerAdapter;
import com.celerysoft.imagepager.util.ImageUtil;
import java.util.ArrayList;
import uk.co.senab.photoview.PhotoView;

public class SimpleImagePagerAdapter
extends ImagePagerAdapter {
    private static final String TAG = SimpleImagePagerAdapter.class.getSimpleName();
    private Context mContext;
    private ArrayList<Bitmap> mImageBitmaps;
    private ArrayList<Image> mImages;

    public ArrayList<Image> getImages() {
        return this.mImages;
    }

    public void setImages(ArrayList<Image> images) {
        this.mImageBitmaps = null;
        this.mImages = images;
        this.createImageBitmaps(images.size());
    }

    public void addImage(Image image) {
        this.mImages.add(image);
        this.mImageBitmaps.add(null);
    }

    public void addImage(int index, Image image) {
        this.mImages.add(index, image);
        this.mImageBitmaps.add(index, null);
    }

    public SimpleImagePagerAdapter(Context context) {
        this.mContext = context;
    }

    @Override
    public PhotoView getItem(int position) {
        PhotoView photoView = new PhotoView(this.mContext);
        if (this.mImages != null && this.mImages.size() > position) {
            Bitmap bitmap;
            if (this.mImageBitmaps.get(position) != null) {
                bitmap = this.mImageBitmaps.get(position);
            } else {
                bitmap = this.mImages.get(position).getBitmap();
                this.mImageBitmaps.set(position, bitmap);
            }
            photoView.setImageBitmap(bitmap);
        }
        return photoView;
    }

    @Override
    public int getCount() {
        if (this.mImages != null) {
            return this.mImages.size();
        }
        return 0;
    }

    @Override
    public boolean removeImage(int imagePosition) {
        boolean succeeded = true;
        try {
            if (this.mImages != null) {
                this.mImages.remove(imagePosition);
                this.mImageBitmaps.remove(imagePosition);
            } else {
                succeeded = false;
                Log.w((String)TAG, (String)"remove image failed, no collection to handle removing operation.");
            }
            this.notifyDataSetChanged();
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)("remove image failed, image position: " + imagePosition + ", image count: " + this.getCount()));
            Log.w((String)TAG, (String)("detail: " + e.getMessage()));
            succeeded = false;
        }
        return succeeded;
    }

    private void createImageBitmaps(int imageCount) {
        this.mImageBitmaps = new ArrayList();
        for (int i = 0; i < imageCount; ++i) {
            this.mImageBitmaps.add(null);
        }
    }

    public static class Image {
        private Context mContext;
        int mImageResId = -1;
        String mImagePath = null;
        String mImageUrl = null;

        public Image(Context context) {
            this.mContext = context;
        }

        public int getImageResId() {
            return this.mImageResId;
        }

        public void setImageResId(int imageResId) {
            this.mImageResId = imageResId;
            this.mImagePath = null;
            this.mImageUrl = null;
        }

        public String getImagePath() {
            return this.mImagePath;
        }

        public void setImagePath(String imagePath) {
            this.mImageResId = -1;
            this.mImagePath = imagePath;
            this.mImageUrl = null;
        }

        public String getImageUrl() {
            return this.mImageUrl;
        }

        public void setImageUrl(String imageUrl) {
            this.mImageResId = -1;
            this.mImageUrl = null;
            this.mImageUrl = imageUrl;
        }

        public Bitmap getBitmap() {
            Bitmap bitmap = null;
            if (this.mImageResId != -1) {
                bitmap = ImageUtil.getBitmap(this.mContext, this.mImageResId);
            } else if (this.mImagePath != null) {
                bitmap = ImageUtil.getBitmap(this.mContext, this.mImagePath);
            } else if (this.mImageUrl != null) {
                // empty if block
            }
            return bitmap;
        }
    }
}

