/*
 * Decompiled with CFR 0.152.
 */
package com.celerysoft.imagepager.view.indicator;

import android.content.Context;
import android.util.Log;
import android.widget.TextView;
import com.celerysoft.imagepager.R;
import com.celerysoft.imagepager.util.DensityUtil;
import com.celerysoft.imagepager.view.indicator.Indicator;

public class TextIndicator
extends TextView
implements Indicator {
    private final String TAG = TextIndicator.class.getSimpleName();
    private Context mContext;
    private int mImageCount;
    private int mCurrentImagePosition = 0;

    public TextIndicator(Context context) {
        super(context);
        this.mContext = context;
        this.setGravity(17);
        this.setTextSize(DensityUtil.sp2px(context, 16.0f));
        this.setBackgroundResource(R.drawable.textindicator_background);
        try {
            this.setTextColor(context.getResources().getColor(R.color.text_indicator_text_color, null));
        }
        catch (NoSuchMethodError e) {
            this.setTextColor(context.getResources().getColor(R.color.text_indicator_text_color));
        }
    }

    @Override
    public void onPageSelected(int position) {
        String text = position + 1 + "/" + this.mImageCount;
        this.setText(text);
        this.mCurrentImagePosition = position;
    }

    @Override
    public void onPageDeleted() {
        String text;
        --this.mImageCount;
        int n = this.mCurrentImagePosition = this.mCurrentImagePosition < this.mImageCount ? this.mCurrentImagePosition : this.mImageCount - 1;
        if (this.mImageCount <= 0) {
            this.setTextSize(DensityUtil.sp2px(this.mContext, 24.0f));
            text = this.mContext.getString(R.string.no_images);
            if (this.mImageCount < 0) {
                Log.e((String)this.TAG, (String)"image count less than 0, it could not be happened!");
            }
        } else {
            this.setTextSize(DensityUtil.sp2px(this.mContext, 16.0f));
            text = this.mCurrentImagePosition + 1 + "/" + this.mImageCount;
        }
        this.setText(text);
    }

    @Override
    public void onPageAdapterChanged(int imageCount) {
        this.mImageCount = imageCount;
        this.mCurrentImagePosition = 0;
        String text = "1/" + this.mImageCount;
        this.setText(text);
    }
}

