/*
 * Decompiled with CFR 0.152.
 */
package com.celerysoft.imagepager.adapter;

import android.content.Context;
import android.graphics.Bitmap;
import android.util.Log;
import com.celerysoft.imagepager.adapter.ImagePagerAdapter;
import com.celerysoft.imagepager.util.ImageUtil;
import java.util.ArrayList;
import uk.co.senab.photoview.PhotoView;

public class SimpleImagePagerAdapter
extends ImagePagerAdapter {
    private static final String TAG = SimpleImagePagerAdapter.class.getSimpleName();
    private Context mContext;
    private ArrayList<Integer> mImageResIds;
    private ArrayList<String> mImagePaths;
    private ArrayList<Bitmap> mImageBitmaps;
    private ArrayList<String> mImageUrls;

    @Deprecated
    public void setImageResIds(ArrayList<Integer> imageResIds) {
        this.removeAllCollection();
        this.mImageResIds = imageResIds;
    }

    public void setImagePaths(ArrayList<String> imagePaths) {
        this.removeAllCollection();
        this.mImagePaths = imagePaths;
        this.mImageBitmaps = new ArrayList();
        int imageCount = this.mImagePaths.size();
        for (int i = 0; i < imageCount; ++i) {
            this.mImageBitmaps.add(null);
        }
    }

    public void setImageUrls(ArrayList<String> imageUrls) {
        this.removeAllCollection();
        this.mImageUrls = imageUrls;
    }

    public SimpleImagePagerAdapter(Context context) {
        this.mContext = context;
    }

    @Override
    public PhotoView getItem(int position) {
        PhotoView photoView = new PhotoView(this.mContext);
        if (this.mImageResIds != null && this.mImageResIds.size() > position) {
            photoView.setImageResource(this.mImageResIds.get(position).intValue());
        } else if (this.mImagePaths != null && this.mImagePaths.size() > position) {
            Bitmap bitmap;
            if (this.mImageBitmaps.get(position) != null) {
                bitmap = this.mImageBitmaps.get(position);
            } else {
                bitmap = ImageUtil.getBitmap(this.mContext, this.mImagePaths.get(position));
                this.mImageBitmaps.set(position, bitmap);
            }
            photoView.setImageBitmap(bitmap);
        } else if (this.mImageUrls == null || this.mImageUrls.size() > position) {
            // empty if block
        }
        return photoView;
    }

    @Override
    public int getCount() {
        if (this.mImageResIds != null) {
            return this.mImageResIds.size();
        }
        if (this.mImagePaths != null) {
            return this.mImagePaths.size();
        }
        if (this.mImageUrls != null) {
            return this.mImageUrls.size();
        }
        return 0;
    }

    @Override
    public boolean removeImage(int imagePosition) {
        boolean succeeded = true;
        try {
            if (this.mImageResIds != null) {
                this.mImageResIds.remove(imagePosition);
            } else if (this.mImagePaths != null) {
                this.mImagePaths.remove(imagePosition);
                this.mImageBitmaps.remove(imagePosition);
            } else if (this.mImageBitmaps != null) {
                this.mImageBitmaps.remove(imagePosition);
            } else if (this.mImageUrls != null) {
                this.mImageUrls.remove(imagePosition);
            } else {
                succeeded = false;
                Log.w((String)TAG, (String)"remove image failed, no collection to handle removing operation.");
            }
            this.notifyDataSetChanged();
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)("remove image failed, image position: " + imagePosition + ", image count: " + this.getCount()));
            Log.w((String)TAG, (String)("detail: " + e.getMessage()));
            succeeded = false;
        }
        return succeeded;
    }

    private void removeAllCollection() {
        this.mImageResIds = null;
        this.mImagePaths = null;
        this.mImageBitmaps = null;
        this.mImageUrls = null;
    }
}

