/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io.factory;

import com.cedarsoftware.io.ClassFactory;
import com.cedarsoftware.io.JsonIoException;
import com.cedarsoftware.io.JsonObject;
import com.cedarsoftware.io.Resolver;
import com.cedarsoftware.util.Converter;
import com.cedarsoftware.util.MultiKeyMap;
import java.util.Map;

public class MultiKeyMapFactory
implements ClassFactory {
    @Override
    public Map newInstance(Class<?> c, JsonObject jObj, Resolver resolver) {
        Object[] entries;
        MultiKeyMap.CollectionKeyMode collectionKeyMode;
        String configStr = resolver.readString(jObj, "config");
        if (configStr == null) {
            throw new JsonIoException("MultiKeyMap requires a config string. Found keys: " + jObj.keySet());
        }
        String[] parts = configStr.split("/");
        if (parts.length != 7) {
            throw new JsonIoException("Invalid MultiKeyMap config format: " + configStr);
        }
        int capacity = Converter.convert2int((Object)parts[0]);
        float loadFactor = Converter.convert2float((Object)parts[1]);
        String modeCode = parts[2];
        boolean flattenDimensions = Converter.convert2boolean((Object)parts[3]);
        boolean simpleKeysMode = Converter.convert2boolean((Object)parts[4]);
        boolean valueBasedEquality = Converter.convert2boolean((Object)parts[5]);
        boolean caseSensitive = Converter.convert2boolean((Object)parts[6]);
        switch (modeCode) {
            case "EXP": {
                collectionKeyMode = MultiKeyMap.CollectionKeyMode.COLLECTIONS_EXPANDED;
                break;
            }
            case "NOEXP": {
                collectionKeyMode = MultiKeyMap.CollectionKeyMode.COLLECTIONS_NOT_EXPANDED;
                break;
            }
            default: {
                collectionKeyMode = MultiKeyMap.CollectionKeyMode.COLLECTIONS_EXPANDED;
            }
        }
        MultiKeyMap.Builder builder = MultiKeyMap.builder().capacity(capacity).loadFactor(loadFactor).collectionKeyMode(collectionKeyMode).flattenDimensions(flattenDimensions).simpleKeysMode(simpleKeysMode).valueBasedEquality(valueBasedEquality).caseSensitive(caseSensitive);
        MultiKeyMap mkmap = builder.build();
        Object entriesObj = jObj.get("entries");
        if (entriesObj != null && (entries = this.extractEntriesArray(entriesObj)) != null) {
            for (Object entryObj : entries) {
                if (!(entryObj instanceof JsonObject)) continue;
                JsonObject entryJsonObj = (JsonObject)entryObj;
                Object key = entryJsonObj.get("keys");
                Object value = entryJsonObj.get("value");
                if (key instanceof JsonObject) {
                    JsonObject keyJsonObj = (JsonObject)key;
                    key = resolver.toJava(keyJsonObj.getType(), keyJsonObj);
                }
                if (value instanceof JsonObject) {
                    value = resolver.toJava(((JsonObject)value).getType(), value);
                }
                mkmap.put(key, value);
            }
        }
        jObj.remove("config");
        jObj.remove("entries");
        jObj.setTarget(mkmap);
        return mkmap;
    }

    private Object[] extractEntriesArray(Object entriesObj) {
        JsonObject entriesJsonObj;
        Object itemsObj;
        if (entriesObj instanceof Object[]) {
            return (Object[])entriesObj;
        }
        if (entriesObj instanceof JsonObject && (itemsObj = (entriesJsonObj = (JsonObject)entriesObj).get("@items")) instanceof Object[]) {
            return (Object[])itemsObj;
        }
        return null;
    }
}

