/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io;

import com.cedarsoftware.io.JsonIoException;
import com.cedarsoftware.io.JsonObject;
import com.cedarsoftware.io.ReadOptions;
import com.cedarsoftware.io.ReferenceTracker;
import com.cedarsoftware.io.Resolver;
import com.cedarsoftware.io.reflect.Injector;
import com.cedarsoftware.util.ArrayUtilities;
import com.cedarsoftware.util.TypeUtilities;
import com.cedarsoftware.util.convert.Converter;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class MapResolver
extends Resolver {
    public MapResolver(ReadOptions readOptions, ReferenceTracker references, Converter converter) {
        super(readOptions, references, converter);
    }

    @Override
    <T> T toJavaObjects(JsonObject rootObj, Type rootType) {
        this.verifyRootType(rootType);
        return super.toJavaObjects(rootObj, rootType);
    }

    private void verifyRootType(Type rootType) {
        Class ultimateRawType;
        if (rootType == null) {
            return;
        }
        Class rawRootType = TypeUtilities.getRawClass((Type)rootType);
        Type typeToCheck = rootType;
        if (rawRootType != null && rawRootType.isArray() ? this.converter.isSimpleTypeConversionSupported(ultimateRawType = TypeUtilities.getRawClass((Type)(typeToCheck = this.getUltimateComponentType(rootType)))) || ultimateRawType != null && ultimateRawType.equals(Object.class) : this.converter.isSimpleTypeConversionSupported(rawRootType)) {
            return;
        }
        Class rawTypeToCheck = TypeUtilities.getRawClass((Type)typeToCheck);
        if (rawTypeToCheck != null && (Collection.class.isAssignableFrom(rawTypeToCheck) || Map.class.isAssignableFrom(rawTypeToCheck))) {
            return;
        }
        String typeName = rawRootType != null ? rawRootType.getName() : rootType.toString();
        throw new JsonIoException("In readOptions.isReturningJsonObjects() mode, the rootType '" + typeName + "' is not supported. Allowed types are:\n- null\n- primitive types (e.g., int, boolean) and their wrapper classes (e.g., Integer, Boolean)\n- types supported by Converter.convert()\n- Map or any of its subclasses\n- Collection or any of its subclasses\n- Arrays (of any depth) of the above types\nPlease use one of these types as the rootType, or enable readOptions.isReturningJavaObjects().");
    }

    private Type getUltimateComponentType(Type type) {
        while (true) {
            if (type instanceof Class) {
                Class cls = type;
                if (!cls.isArray()) break;
                type = cls.getComponentType();
                continue;
            }
            if (!(type instanceof GenericArrayType)) break;
            type = ((GenericArrayType)((Object)type)).getGenericComponentType();
        }
        return type;
    }

    private void substituteSortedCollectionType(JsonObject jsonObj) {
        Class<?> javaType = jsonObj.getRawType();
        if (javaType == null) {
            return;
        }
        if (SortedSet.class.isAssignableFrom(javaType)) {
            jsonObj.setType((Type)((Object)LinkedHashSet.class));
        } else if (SortedMap.class.isAssignableFrom(javaType)) {
            jsonObj.setType((Type)((Object)LinkedHashMap.class));
        }
    }

    @Override
    protected void adjustTypeBeforeResolve(JsonObject rootObj, Type rootType) {
        if (rootObj.getTypeString() != null) {
            this.substituteSortedCollectionType(rootObj);
        }
    }

    @Override
    protected void traverseMap(JsonObject jsonObj) {
        Object[] complexKeys;
        if (jsonObj.getTypeString() != null) {
            this.substituteSortedCollectionType(jsonObj);
        }
        if ((complexKeys = jsonObj.getKeys()) != null) {
            Object[] items = jsonObj.getItems();
            if (items != null) {
                this.traverseArrayForRefs(complexKeys);
                this.traverseArrayForRefs(items);
            }
        } else {
            this.traverseFields(jsonObj);
        }
        this.addMapToRehash(jsonObj);
    }

    private void traverseArrayForRefs(Object[] array) {
        ReferenceTracker refTracker = this.references;
        for (int i = 0; i < array.length; ++i) {
            Object element = array[i];
            if (!(element instanceof JsonObject)) continue;
            JsonObject jObj = (JsonObject)element;
            if (jObj.isReference()) {
                long refId = jObj.getReferenceId();
                JsonObject refObject = refTracker.getOrThrow(refId);
                array[i] = refObject;
                continue;
            }
            this.push(jObj);
        }
    }

    @Override
    protected Object reconcileResult(Object result, JsonObject rootObj, Type rootType) {
        if (rootType != null) {
            return result;
        }
        if (result != null && result.getClass().isArray()) {
            return result;
        }
        Type javaType = rootObj.getType();
        if (javaType != null) {
            Class javaClass = TypeUtilities.getRawClass((Type)javaType);
            if (this.converter.isSimpleTypeConversionSupported(javaClass) || Number.class.isAssignableFrom(javaClass)) {
                Class<?> basicType = this.getJsonSynonymType(javaClass);
                return this.converter.convert((Object)rootObj, basicType);
            }
            if (!this.isBuiltInPrimitive(result, this.converter)) {
                return rootObj;
            }
        }
        if (result != null && this.converter.isSimpleTypeConversionSupported(result.getClass())) {
            return result;
        }
        return rootObj;
    }

    private Class<?> getJsonSynonymType(Class<?> javaType) {
        if (javaType == StringBuilder.class || javaType == StringBuffer.class) {
            return String.class;
        }
        if (javaType == AtomicInteger.class) {
            return Integer.class;
        }
        if (javaType == AtomicLong.class) {
            return Long.class;
        }
        if (javaType == AtomicBoolean.class) {
            return Boolean.class;
        }
        return javaType;
    }

    private boolean isBuiltInPrimitive(Object obj, Converter converter) {
        if (obj == null) {
            return false;
        }
        return converter.isSimpleTypeConversionSupported(obj.getClass());
    }

    @Override
    protected Object readWithFactoryIfExists(Object o, Type compType) {
        JsonObject jsonObj;
        Object converted;
        if (o instanceof JsonObject && (converted = this.convertIfNonRefType(jsonObj = (JsonObject)o, jsonObj.getRawType())) != null) {
            jsonObj.setFinishedTarget(converted, true);
            return converted;
        }
        return null;
    }

    @Override
    public void traverseFields(JsonObject jsonObj) {
        Object target = jsonObj.getTarget();
        Map<String, Injector> injectorMap = null;
        if (target != null) {
            injectorMap = this.getReadOptions().getDeepInjectorMap(target.getClass());
        }
        ReadOptions readOptions = this.getReadOptions();
        for (Map.Entry<Object, Object> e : jsonObj.entrySet()) {
            Class<?> fieldType;
            Injector injector;
            String fieldName = (String)e.getKey();
            Object rhs = e.getValue();
            if (rhs == null) {
                jsonObj.put(fieldName, (Object)null);
                continue;
            }
            Class<?> rhsClass = rhs.getClass();
            Injector injector2 = injector = injectorMap == null ? null : injectorMap.get(fieldName);
            if (rhsClass.isArray()) {
                JsonObject jsonArray = new JsonObject();
                jsonArray.setItems((Object[])rhs);
                this.push(jsonArray);
                jsonObj.put(fieldName, rhs);
                continue;
            }
            if (rhs instanceof JsonObject) {
                Class<?> injectorType;
                boolean isNonRefClass;
                JsonObject jObj = (JsonObject)rhs;
                if (injector != null && (isNonRefClass = readOptions.isNonReferenceableClass(injectorType = injector.getType()))) {
                    jObj.setValue(this.converter.convert(jObj.getValue(), injectorType));
                    continue;
                }
                if (jObj.isReference()) {
                    long refId = jObj.getReferenceId();
                    JsonObject refObject = this.references.getOrThrow(refId);
                    jsonObj.put(fieldName, refObject);
                    continue;
                }
                Object converted = this.convertIfNonRefType(jObj, jObj.getRawType());
                if (converted != null) {
                    jObj.setFinishedTarget(converted, true);
                    jsonObj.put(fieldName, converted);
                    continue;
                }
                this.push(jObj);
                continue;
            }
            if (injector == null || (fieldType = injector.getType()) == Object.class || rhsClass == fieldType) continue;
            Object fastValue = MapResolver.fastPrimitiveCoercion(rhs, rhsClass, fieldType);
            if (fastValue != null) {
                jsonObj.put(fieldName, fastValue);
                continue;
            }
            if (this.converter.isConversionSupportedFor(rhsClass, fieldType)) {
                Object fieldValue = this.converter.convert(rhs, fieldType);
                jsonObj.put(fieldName, fieldValue);
                continue;
            }
            if (!(rhs instanceof String) || fieldType == String.class || fieldType == StringBuilder.class || fieldType == StringBuffer.class || !"".equals(((String)rhs).trim())) continue;
            jsonObj.put(fieldName, (Object)null);
        }
        Object currentTarget = jsonObj.getTarget();
        if (currentTarget != null && !(currentTarget instanceof Map)) {
            jsonObj.setTarget(null);
        }
    }

    private void handleNestedArray(Object element, Class<?> componentType, Object target, int index) {
        JsonObject jsonObject = null;
        if (element instanceof JsonObject && ((JsonObject)element).isArray()) {
            jsonObject = (JsonObject)element;
        } else if (element != null && element.getClass().isArray()) {
            jsonObject = new JsonObject();
            jsonObject.setItems((Object[])element);
        }
        if (jsonObject != null) {
            if (componentType.isArray()) {
                Object arrayElement;
                jsonObject.setType(componentType);
                ((Object[])target)[index] = arrayElement = this.createInstance(jsonObject);
            }
            this.push(jsonObject);
        }
    }

    @Override
    protected void traverseArray(JsonObject jsonObj) {
        Object[] items = jsonObj.getItems();
        if (ArrayUtilities.isEmpty((Object)items)) {
            return;
        }
        Object[] target = jsonObj.getTarget() != null ? jsonObj.getTarget() : items;
        Class<?> componentType = this.getArrayComponentType(jsonObj);
        boolean isPrimitive = componentType.isPrimitive();
        Object[] refArray = isPrimitive ? null : target;
        int len = items.length;
        for (int i = 0; i < len; ++i) {
            Object element = items[i];
            if (element == null) {
                MapResolver.setArrayElement(target, refArray, i, null, isPrimitive);
                continue;
            }
            Class<?> elementClass = element.getClass();
            if (elementClass.isArray() || element instanceof JsonObject && ((JsonObject)element).isArray()) {
                this.handleNestedArray(element, componentType, target, i);
                continue;
            }
            this.processArrayElement(element, elementClass, componentType, target, refArray, i, isPrimitive);
        }
        jsonObj.setFinished();
    }

    private Class<?> getArrayComponentType(JsonObject jsonObj) {
        Class<?> targetClass;
        if (jsonObj.getTarget() != null && (targetClass = jsonObj.getTarget().getClass()).isArray()) {
            return targetClass.getComponentType();
        }
        return Object.class;
    }

    private void processArrayElement(Object element, Class<?> elementClass, Class<?> componentType, Object target, Object[] refArray, int index, boolean isPrimitive) {
        Object fastValue = MapResolver.fastPrimitiveCoercion(element, elementClass, componentType);
        if (fastValue != null) {
            MapResolver.setArrayElement(target, refArray, index, fastValue, isPrimitive);
            return;
        }
        if (this.converter.isConversionSupportedFor(elementClass, componentType)) {
            Object convertedValue = this.converter.convert(element, componentType);
            MapResolver.setArrayElement(target, refArray, index, convertedValue, isPrimitive);
            return;
        }
        if (element instanceof JsonObject) {
            this.processJsonObjectArrayElement((JsonObject)element, target, refArray, index, isPrimitive);
            return;
        }
        MapResolver.setArrayElement(target, refArray, index, element, isPrimitive);
    }

    private void processJsonObjectArrayElement(JsonObject jsonObject, Object target, Object[] refArray, int index, boolean isPrimitive) {
        if (jsonObject.isReference()) {
            this.processArrayReference(jsonObject, target, refArray, index, isPrimitive);
        } else {
            this.processArrayJsonObject(jsonObject, target, refArray, index, isPrimitive);
        }
    }

    private void processArrayReference(JsonObject jsonObject, Object target, Object[] refArray, int index, boolean isPrimitive) {
        long refId = jsonObject.getReferenceId();
        JsonObject refObject = this.references.getOrThrow(refId);
        Object convertedRef = this.convertIfNonRefType(refObject, refObject.getRawType());
        if (convertedRef != null) {
            refObject.setFinishedTarget(convertedRef, true);
            MapResolver.setArrayElement(target, refArray, index, refObject.getTarget(), isPrimitive);
        } else {
            MapResolver.setArrayElement(target, refArray, index, refObject, isPrimitive);
        }
    }

    private void processArrayJsonObject(JsonObject jsonObject, Object target, Object[] refArray, int index, boolean isPrimitive) {
        Object converted = this.convertIfNonRefType(jsonObject, jsonObject.getRawType());
        if (converted != null) {
            MapResolver.setArrayElement(target, refArray, index, converted, isPrimitive);
            jsonObject.setFinished();
        } else {
            this.push(jsonObject);
        }
    }

    @Override
    protected void traverseCollection(JsonObject jsonObj) {
        if (jsonObj.isFinished) {
            return;
        }
        this.substituteSortedCollectionType(jsonObj);
        Object[] items = jsonObj.getItems();
        Collection col = (Collection)jsonObj.getTarget();
        if (col == null) {
            col = (Collection)this.createInstance(jsonObj);
        }
        if (items != null) {
            MapResolver.ensureCollectionCapacity(col, items.length);
        }
        boolean isList = col instanceof List;
        boolean isEnumSet = col instanceof EnumSet;
        int idx = 0;
        if (items != null) {
            for (Object element : items) {
                if (element == null) {
                    col.add(null);
                } else if (MapResolver.isDirectlyAddableJsonValue(element)) {
                    col.add(element);
                } else if (element.getClass().isArray()) {
                    this.wrapArrayAndAddToCollection((Object[])element, (Type)((Object)Object[].class), col);
                } else {
                    this.processJsonObjectElement((JsonObject)element, jsonObj, col, idx, isList, isEnumSet);
                }
                ++idx;
            }
        }
        jsonObj.setFinished();
    }

    private void processJsonObjectElement(JsonObject jObj, JsonObject parent, Collection<Object> col, int idx, boolean isList, boolean isEnumSet) {
        if (jObj.isReference()) {
            this.resolveReferenceInCollection(jObj, parent, col, idx, isList);
            return;
        }
        if (isEnumSet) {
            boolean noEnumName;
            Class<?> rawType = jObj.getRawType();
            boolean bl = noEnumName = !jObj.containsKey("name") && !jObj.containsKey("Enum.name") && !jObj.hasValue();
            if (rawType != null && rawType.isEnum() && noEnumName) {
                jObj.setFinished();
                return;
            }
        }
        jObj.setType((Type)((Object)Object.class));
        this.createInstance(jObj);
        this.addResolvedObjectToCollection(jObj, col);
    }

    @Override
    protected Object resolveArray(Type suggestedType, List<Object> list) {
        Class rawType;
        Class clazz = rawType = suggestedType == null ? null : TypeUtilities.getRawClass((Type)suggestedType);
        if (suggestedType == null || rawType == Object.class) {
            return list.toArray();
        }
        JsonObject jsonArray = new JsonObject();
        jsonArray.setType(suggestedType);
        this.substituteSortedCollectionType(jsonArray);
        if (Collection.class.isAssignableFrom(rawType)) {
            jsonArray.setTarget(this.createInstance(jsonArray));
        } else {
            jsonArray.setTarget(Array.newInstance(rawType, list.size()));
        }
        jsonArray.setItems(list.toArray());
        return jsonArray;
    }

    private static Object fastPrimitiveCoercion(Object value, Class<?> valueClass, Class<?> targetType) {
        if (valueClass == Long.class) {
            return MapResolver.coerceLong((Long)value, targetType);
        }
        if (valueClass == Double.class) {
            return MapResolver.coerceDouble((Double)value, targetType);
        }
        return null;
    }

    private static Object coerceLong(long longVal, Class<?> targetType) {
        if (targetType == Integer.TYPE || targetType == Integer.class) {
            return (int)longVal;
        }
        if (targetType == Short.TYPE || targetType == Short.class) {
            return (short)longVal;
        }
        if (targetType == Byte.TYPE || targetType == Byte.class) {
            return (byte)longVal;
        }
        if (targetType == Double.TYPE || targetType == Double.class) {
            return (double)longVal;
        }
        if (targetType == Float.TYPE || targetType == Float.class) {
            return Float.valueOf(longVal);
        }
        return null;
    }

    private static Object coerceDouble(double doubleVal, Class<?> targetType) {
        if (targetType == Float.TYPE || targetType == Float.class) {
            return Float.valueOf((float)doubleVal);
        }
        if (targetType == Long.TYPE || targetType == Long.class) {
            return (long)doubleVal;
        }
        if (targetType == Integer.TYPE || targetType == Integer.class) {
            return (int)doubleVal;
        }
        return null;
    }
}

