/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io;

import com.cedarsoftware.io.JsonIoException;
import com.cedarsoftware.io.JsonObject;
import com.cedarsoftware.io.MetaUtils;
import com.cedarsoftware.io.Primitives;
import com.cedarsoftware.io.WriteOptions;
import com.cedarsoftware.io.WriteOptionsBuilder;
import com.cedarsoftware.io.WriterContext;
import com.cedarsoftware.io.Writers;
import com.cedarsoftware.io.reflect.Accessor;
import com.cedarsoftware.util.ArrayUtilities;
import com.cedarsoftware.util.ClassUtilities;
import com.cedarsoftware.util.CompactMap;
import com.cedarsoftware.util.CompactSet;
import com.cedarsoftware.util.FastWriter;
import com.cedarsoftware.util.IOUtilities;
import com.cedarsoftware.util.TypeUtilities;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class JsonWriter
implements WriterContext,
Closeable,
Flushable {
    private static final Logger LOG;
    private static final String ID_SHORT = "\"@i\":";
    private static final String ID_LONG = "\"@id\":";
    private static final String TYPE_SHORT = "\"@t\":\"";
    private static final String TYPE_LONG = "\"@type\":\"";
    private static final String REF_SHORT = "\"@r\":";
    private static final String REF_LONG = "\"@ref\":";
    private static final String ITEMS_SHORT = "\"@e\":";
    private static final String ITEMS_LONG = "\"@items\":";
    private static final String KEYS_SHORT = "\"@k\":";
    private static final String KEYS_LONG = "\"@keys\":";
    private static final String ID_JSON5 = "$id:";
    private static final String TYPE_JSON5 = "$type:\"";
    private static final String REF_JSON5 = "$ref:";
    private static final String ITEMS_JSON5 = "$items:";
    private static final String KEYS_JSON5 = "$keys:";
    private static final String ID_JSON5_SHORT = "$i:";
    private static final String TYPE_JSON5_SHORT = "$t:\"";
    private static final String REF_JSON5_SHORT = "$r:";
    private static final String ITEMS_JSON5_SHORT = "$e:";
    private static final String KEYS_JSON5_SHORT = "$k:";
    private final String idPrefix;
    private final String typePrefix;
    private final String refPrefix;
    private final String itemsPrefix;
    private final String keysPrefix;
    private static final Object[] byteStrings;
    private static final String NEW_LINE;
    private static final Long ZERO;
    private static final boolean[] NEEDS_ESCAPE;
    private static final boolean[] NEEDS_ESCAPE_SINGLE_QUOTE;
    private final WriteOptions writeOptions;
    private final Map<Object, Long> objVisited = new IdentityHashMap<Object, Long>(256);
    private final Map<Object, Long> objsReferenced = new IdentityHashMap<Object, Long>(256);
    private final Writer out;
    private int identity = 1;
    private int depth = 0;
    private int[] traceDepths = new int[256];
    private int traceDepthIndex;
    private Class<?> declaredElementType = null;
    private Class<?> declaredKeyType = null;
    private final Deque<WriteContext> contextStack = new ArrayDeque<WriteContext>();
    private static final ClassValue<WriteType> writeTypeCache;
    private static final char[] DIGIT_TENS;
    private static final char[] DIGIT_ONES;
    private final char[] longBuffer = new char[20];

    public JsonWriter(OutputStream out) {
        this(out, null);
    }

    public JsonWriter(OutputStream out, WriteOptions writeOptions) {
        this.out = new FastWriter((Writer)new OutputStreamWriter(out, StandardCharsets.UTF_8));
        this.writeOptions = writeOptions == null ? WriteOptionsBuilder.getDefaultWriteOptions() : writeOptions;
        boolean isJson5 = this.writeOptions.isJson5UnquotedKeys();
        boolean isShort = this.writeOptions.isShortMetaKeys();
        if (isJson5 && isShort) {
            this.idPrefix = ID_JSON5_SHORT;
            this.typePrefix = TYPE_JSON5_SHORT;
            this.refPrefix = REF_JSON5_SHORT;
            this.itemsPrefix = ITEMS_JSON5_SHORT;
            this.keysPrefix = KEYS_JSON5_SHORT;
        } else if (isJson5) {
            this.idPrefix = ID_JSON5;
            this.typePrefix = TYPE_JSON5;
            this.refPrefix = REF_JSON5;
            this.itemsPrefix = ITEMS_JSON5;
            this.keysPrefix = KEYS_JSON5;
        } else if (isShort) {
            this.idPrefix = ID_SHORT;
            this.typePrefix = TYPE_SHORT;
            this.refPrefix = REF_SHORT;
            this.itemsPrefix = ITEMS_SHORT;
            this.keysPrefix = KEYS_SHORT;
        } else {
            this.idPrefix = ID_LONG;
            this.typePrefix = TYPE_LONG;
            this.refPrefix = REF_LONG;
            this.itemsPrefix = ITEMS_LONG;
            this.keysPrefix = KEYS_LONG;
        }
    }

    @Override
    public WriteOptions getWriteOptions() {
        return this.writeOptions;
    }

    protected Map<Object, Long> getObjVisited() {
        return this.objVisited;
    }

    @Override
    public Map<Object, Long> getObjsReferenced() {
        return this.objsReferenced;
    }

    public void tabIn() throws IOException {
        this.tab(this.out, 1);
    }

    public void newLine() throws IOException {
        this.tab(this.out, 0);
    }

    public void tabOut() throws IOException {
        this.tab(this.out, -1);
    }

    private void tab(Writer output, int delta) throws IOException {
        if (!this.writeOptions.isPrettyPrint()) {
            return;
        }
        output.write(NEW_LINE);
        this.depth += delta;
        if (this.depth > 0) {
            int maxDepth = this.writeOptions.getMaxIndentationDepth();
            int actualDepth = Math.min(this.depth, maxDepth);
            int indentationThreshold = this.writeOptions.getIndentationThreshold();
            int indentationSize = this.writeOptions.getIndentationSize();
            if (actualDepth <= indentationThreshold) {
                for (int i = 0; i < actualDepth; ++i) {
                    for (int j = 0; j < indentationSize; ++j) {
                        output.write(32);
                    }
                }
            } else {
                char[] spaces = new char[actualDepth * indentationSize];
                Arrays.fill(spaces, ' ');
                output.write(spaces);
            }
            if (this.depth > maxDepth) {
                output.write("... (depth=" + this.depth + ")");
            }
        }
    }

    public boolean writeUsingCustomWriter(Object o, boolean showType, Writer output) {
        Class<?> c = o.getClass();
        try {
            return this.writeCustom(c, o, !this.writeOptions.isNeverShowingType() && showType, output);
        }
        catch (Exception e) {
            throw new JsonIoException("Unable to write custom formatted object:", e);
        }
    }

    private boolean isCustomWrittenClass(Class<?> c, Object o) {
        if (this.writeOptions.isNotCustomWrittenClass(c)) {
            return false;
        }
        if (this.writeOptions.getCustomWriter(c) == null) {
            return false;
        }
        if (o instanceof CompactSet && ((CompactSet)o).isDefaultCompactSet()) {
            return false;
        }
        return !(o instanceof CompactMap) || !((CompactMap)o).isDefaultCompactMap();
    }

    public boolean writeArrayElementIfMatching(Class<?> arrayComponentClass, Object o, boolean showType, Writer output) {
        if (!arrayComponentClass.isInstance(o)) {
            return false;
        }
        try {
            return this.writeCustom(arrayComponentClass, o, showType, output);
        }
        catch (IOException e) {
            throw new JsonIoException("Unable to write custom formatted object as array element:", e);
        }
    }

    protected boolean writeCustom(Class<?> clazz, Object o, boolean showType, Writer output) throws IOException {
        if (!this.isCustomWrittenClass(clazz, o)) {
            return false;
        }
        if (this.writeOptions.isNeverShowingType()) {
            showType = false;
        }
        com.cedarsoftware.io.JsonClassWriter closestWriter = this.writeOptions.getCustomWriter(o.getClass());
        if (this.writeOptionalReference(o)) {
            return true;
        }
        boolean referenced = this.objsReferenced.containsKey(o);
        if (closestWriter.hasPrimitiveForm(this) && (!referenced && !showType || closestWriter instanceof Writers.JsonStringWriter)) {
            closestWriter.writePrimitiveForm(o, output, this);
            return true;
        }
        output.write(123);
        this.tabIn();
        if (referenced) {
            this.writeId(this.getIdLong(o));
            if (showType) {
                output.write(44);
                this.newLine();
            }
        }
        if (showType) {
            String typeName = closestWriter.getTypeName(o);
            this.writeType(typeName, output);
        }
        if (referenced || showType) {
            output.write(44);
            this.newLine();
        }
        closestWriter.write(o, showType || referenced, output, this);
        this.tabOut();
        output.write(125);
        return true;
    }

    public void write(Object obj) {
        this.traceReferences(obj);
        this.objVisited.clear();
        try {
            boolean showType = this.writeOptions.isShowingRootTypeInfo();
            if (obj != null) {
                String alias;
                int fieldCount;
                com.cedarsoftware.io.JsonClassWriter writer;
                if (this.writeOptions.isNeverShowingType()) {
                    showType = false;
                } else if (!this.writeOptions.isAlwaysShowingType() && (writer = this.writeOptions.getCustomWriter(obj.getClass())) instanceof Writers.EnumsAsStringWriter && (fieldCount = this.writeOptions.getAccessorsForClass(obj.getClass()).size()) <= 2 && (alias = this.writeOptions.getTypeNameAlias(obj.getClass().getName())).equals(obj.getClass().getName())) {
                    showType = false;
                }
            }
            this.writeImpl(obj, showType);
        }
        catch (JsonIoException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JsonIoException("Error writing object to JSON:", e);
        }
        this.flush();
        this.objVisited.clear();
        this.objsReferenced.clear();
    }

    protected void traceReferences(Object root) {
        if (root == null) {
            return;
        }
        ArrayDeque<Object> objectStack = new ArrayDeque<Object>(256);
        this.traceDepthIndex = 0;
        objectStack.addFirst(root);
        this.pushDepth(0);
        Map<Object, Long> visited = this.objVisited;
        Map<Object, Long> referenced = this.objsReferenced;
        int MAX_DEPTH = this.writeOptions.getMaxObjectGraphDepth();
        int MAX_OBJECTS = this.writeOptions.getMaxObjectCount();
        int processedCount = 0;
        while (!objectStack.isEmpty() && processedCount < MAX_OBJECTS) {
            Object obj = objectStack.removeFirst();
            int currentDepth = this.traceDepths[--this.traceDepthIndex];
            ++processedCount;
            if (currentDepth > MAX_DEPTH) {
                throw new JsonIoException("Object graph too deep (>" + MAX_DEPTH + " levels). This may indicate a circular reference or excessively nested structure.");
            }
            Class<?> clazz = obj.getClass();
            boolean isNonReferenceable = this.writeOptions.isNonReferenceableClass(clazz);
            if (!isNonReferenceable) {
                Long id = visited.get(obj);
                if (id != null) {
                    if (!id.equals(ZERO)) continue;
                    id = this.identity++;
                    visited.put(obj, id);
                    referenced.put(obj, id);
                    continue;
                }
                visited.put(obj, ZERO);
            }
            int nextDepth = currentDepth + 1;
            if (obj instanceof Object[]) {
                this.processArray((Object[])obj, objectStack, nextDepth);
                continue;
            }
            if (obj instanceof JsonObject) {
                this.processJsonObject((JsonObject)obj, objectStack, nextDepth);
                continue;
            }
            if (obj instanceof Map) {
                this.processMap((Map)obj, objectStack, nextDepth);
                continue;
            }
            if (obj instanceof Collection) {
                this.processCollection((Collection)obj, objectStack, nextDepth);
                continue;
            }
            if (isNonReferenceable) continue;
            this.processFields(objectStack, obj, nextDepth);
        }
        if (processedCount >= MAX_OBJECTS) {
            throw new JsonIoException("Object graph too large (>" + MAX_OBJECTS + " objects). This may indicate excessive nesting or a memory leak.");
        }
    }

    private void pushDepth(int depth) {
        if (this.traceDepthIndex >= this.traceDepths.length) {
            this.traceDepths = Arrays.copyOf(this.traceDepths, this.traceDepths.length * 2);
        }
        this.traceDepths[this.traceDepthIndex++] = depth;
    }

    private void processArray(Object[] array, Deque<Object> objectStack, int depth) {
        Class<?> componentType = array.getClass().getComponentType();
        if (!this.writeOptions.isNonReferenceableClass(componentType)) {
            for (Object element : array) {
                if (element == null) continue;
                objectStack.addFirst(element);
                this.pushDepth(depth);
            }
        }
    }

    private void processJsonObject(JsonObject jsonObj, Deque<Object> objectStack, int depth) {
        Object[] items = jsonObj.getItems();
        Object[] keys = jsonObj.getKeys();
        if (items != null || keys != null) {
            if (items != null) {
                this.processArray(items, objectStack, depth);
            }
            if (keys != null) {
                this.processArray(keys, objectStack, depth);
            }
        } else {
            this.processMap(jsonObj, objectStack, depth);
        }
    }

    private void processMap(Map<?, ?> map, Deque<Object> objectStack, int depth) {
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (key != null) {
                objectStack.addFirst(key);
                this.pushDepth(depth);
            }
            if (value == null) continue;
            objectStack.addFirst(value);
            this.pushDepth(depth);
        }
    }

    private void processCollection(Collection<?> collection, Deque<Object> objectStack, int depth) {
        for (Object item : collection) {
            if (item == null) continue;
            objectStack.addFirst(item);
            this.pushDepth(depth);
        }
    }

    protected void processFields(Deque<Object> objectStack, Object obj, int depth) {
        List<Accessor> fields = this.writeOptions.getAccessorsForClass(obj.getClass());
        for (Accessor accessor : fields) {
            Object o = accessor.retrieve(obj);
            if (o == null) continue;
            objectStack.addFirst(o);
            this.pushDepth(depth);
        }
    }

    private boolean writeOptionalReference(Object obj) throws IOException {
        if (obj == null || this.writeOptions.isNonReferenceableClass(obj.getClass())) {
            return false;
        }
        Writer output = this.out;
        if (this.objVisited.containsKey(obj)) {
            long id = this.getIdLong(obj);
            if (id == 0L) {
                return false;
            }
            output.write(123);
            output.write(this.refPrefix);
            this.writeLongDirect(id);
            output.write(125);
            return true;
        }
        this.objVisited.put(obj, null);
        return false;
    }

    @Override
    public void writeImpl(Object obj, boolean showType) throws IOException {
        if (obj == null || obj instanceof ProcessBuilder || obj instanceof Process || obj instanceof ClassLoader || obj instanceof Constructor || obj instanceof Method || obj instanceof Field) {
            this.out.write("null");
            return;
        }
        if (this.writeOptions.isNeverShowingType()) {
            showType = false;
        }
        if (this.writeUsingCustomWriter(obj, showType, this.out) || this.writeOptionalReference(obj)) {
            return;
        }
        Class<?> objClass = obj.getClass();
        block0 : switch (writeTypeCache.get(objClass)) {
            case PRIMITIVE_ARRAY: {
                this.writePrimitiveArray(obj, objClass, showType);
                break;
            }
            case OBJECT_ARRAY: {
                this.writeObjectArray((Object[])obj, objClass, showType);
                break;
            }
            case ENUM_SET: {
                this.writeEnumSet((EnumSet)obj);
                break;
            }
            case COLLECTION: {
                this.writeCollection((Collection)obj, showType);
                break;
            }
            case JSON_OBJECT: {
                JsonObject jObj = (JsonObject)obj;
                switch (jObj.getJsonType()) {
                    case ARRAY: {
                        this.writeJsonObjectArray(jObj, showType);
                        break block0;
                    }
                    case COLLECTION: {
                        this.writeJsonObjectCollection(jObj, showType);
                        break block0;
                    }
                    case MAP: {
                        if (this.writeJsonObjectMapWithStringKeys(jObj, showType)) break block0;
                        this.writeJsonObjectMap(jObj, showType);
                        break block0;
                    }
                }
                this.writeJsonObjectObject(jObj, showType);
                break;
            }
            case MAP: {
                if (this.writeMapWithStringKeys((Map)obj, showType)) break;
                this.writeMap((Map)obj, showType);
                break;
            }
            case POJO: {
                this.writeObject(obj, showType, false);
            }
        }
    }

    private void writeId(long id) throws IOException {
        this.out.write(this.idPrefix);
        this.writeLongDirect(id);
    }

    private void writeLongDirect(long value) throws IOException {
        boolean negative;
        if (value == 0L) {
            this.out.write(48);
            return;
        }
        int idx = this.longBuffer.length;
        boolean bl = negative = value < 0L;
        if (!negative) {
            value = -value;
        }
        while (value <= -100L) {
            int q = (int)(value / 100L);
            int r = (int)((long)(q * 100) - value);
            value = q;
            this.longBuffer[--idx] = DIGIT_ONES[r];
            this.longBuffer[--idx] = DIGIT_TENS[r];
        }
        int r = (int)(-value);
        this.longBuffer[--idx] = DIGIT_ONES[r];
        if (r >= 10) {
            this.longBuffer[--idx] = DIGIT_TENS[r];
        }
        if (negative) {
            this.longBuffer[--idx] = 45;
        }
        this.out.write(this.longBuffer, idx, this.longBuffer.length - idx);
    }

    private void writeType(String name, Writer output) throws IOException {
        if (this.writeOptions.isNeverShowingType()) {
            return;
        }
        output.write(this.typePrefix);
        String alias = this.writeOptions.getTypeNameAlias(name);
        output.write(alias);
        output.write(34);
    }

    private void writePrimitive(Object obj, boolean showType) throws IOException {
        if (this.writeOptions.isNeverShowingType()) {
            showType = false;
        }
        if (obj instanceof Long && this.getWriteOptions().isWriteLongsAsStrings()) {
            if (showType) {
                this.out.write(123);
                this.writeType("long", this.out);
                this.out.write(44);
            }
            com.cedarsoftware.io.JsonClassWriter writer = this.getWriteOptions().getCustomWriter(Long.class);
            writer.write(obj, showType, this.out, this);
            if (showType) {
                this.out.write(125);
            }
        } else if (!this.isNanInfinityAllowed() && obj instanceof Double && (Double.isNaN((Double)obj) || Double.isInfinite((Double)obj))) {
            this.out.write("null");
        } else if (!this.isNanInfinityAllowed() && obj instanceof Float && (Float.isNaN(((Float)obj).floatValue()) || Float.isInfinite(((Float)obj).floatValue()))) {
            this.out.write("null");
        } else {
            this.out.write(obj.toString());
        }
    }

    private void writeObjectArray(Object[] array, Class<?> arrayType, boolean showType) throws IOException {
        if (this.writeOptions.isNeverShowingType()) {
            showType = false;
        }
        int len = array.length;
        boolean referenced = this.objsReferenced.containsKey(array);
        boolean typeWritten = showType && !arrayType.equals(Object[].class);
        Writer output = this.out;
        if (typeWritten || referenced) {
            output.write(123);
            this.tabIn();
        }
        if (referenced) {
            this.writeId(this.getIdLong(array));
            output.write(44);
            this.newLine();
        }
        if (typeWritten) {
            this.writeType(arrayType.getName(), output);
            output.write(44);
            this.newLine();
        }
        if (len == 0) {
            if (typeWritten || referenced) {
                output.write(this.itemsPrefix);
                output.write("[]");
                this.tabOut();
                output.write(125);
            } else {
                output.write("[]");
            }
            return;
        }
        if (typeWritten || referenced) {
            output.write(this.itemsPrefix);
            output.write(91);
        } else {
            output.write(91);
        }
        this.tabIn();
        int lenMinus1 = len - 1;
        Class<?> componentClass = arrayType.getComponentType();
        for (int i = 0; i < len; ++i) {
            Object value = array[i];
            if (value == null) {
                output.write("null");
            } else {
                boolean forceType = this.isForceType(value.getClass(), componentClass);
                if (!this.writeArrayElementIfMatching(componentClass, value, forceType, output)) {
                    this.writeImpl(value, forceType);
                }
            }
            if (i == lenMinus1) continue;
            output.write(44);
            this.newLine();
        }
        if (len > 0 && this.writeOptions.isJson5TrailingCommas()) {
            output.write(44);
        }
        this.tabOut();
        output.write(93);
        if (typeWritten || referenced) {
            this.tabOut();
            output.write(125);
        }
    }

    private void writePrimitiveArray(Object array, Class<?> arrayType, boolean showType) throws IOException {
        if (this.writeOptions.isNeverShowingType()) {
            showType = false;
        }
        int len = ArrayUtilities.getLength((Object)array);
        boolean referenced = this.objsReferenced.containsKey(array);
        boolean typeWritten = showType && !arrayType.equals(Object[].class);
        Writer output = this.out;
        if (typeWritten || referenced) {
            output.write(123);
            this.tabIn();
        }
        if (referenced) {
            this.writeId(this.getIdLong(array));
            output.write(44);
            this.newLine();
        }
        if (typeWritten) {
            this.writeType(arrayType.getName(), output);
            output.write(44);
            this.newLine();
        }
        if (len == 0) {
            if (typeWritten || referenced) {
                output.write(this.itemsPrefix);
                output.write("[]");
                this.tabOut();
                output.write(125);
            } else {
                output.write("[]");
            }
            return;
        }
        if (typeWritten || referenced) {
            output.write(this.itemsPrefix);
            output.write(91);
        } else {
            output.write(91);
        }
        this.tabIn();
        int lenMinus1 = len - 1;
        if (byte[].class == arrayType) {
            this.writeByteArray((byte[])array, lenMinus1);
        } else if (char[].class == arrayType) {
            this.writeStringValue(new String((char[])array));
        } else if (short[].class == arrayType) {
            this.writeShortArray((short[])array, lenMinus1);
        } else if (int[].class == arrayType) {
            this.writeIntArray((int[])array, lenMinus1);
        } else if (long[].class == arrayType) {
            this.writeLongArray((long[])array, lenMinus1);
        } else if (float[].class == arrayType) {
            this.writeFloatArray((float[])array, lenMinus1);
        } else if (double[].class == arrayType) {
            this.writeDoubleArray((double[])array, lenMinus1);
        } else if (boolean[].class == arrayType) {
            this.writeBooleanArray((boolean[])array, lenMinus1);
        }
        if (len > 0 && this.writeOptions.isJson5TrailingCommas()) {
            output.write(44);
        }
        this.tabOut();
        output.write(93);
        if (typeWritten || referenced) {
            this.tabOut();
            output.write(125);
        }
    }

    private void writeBooleanArray(boolean[] booleans, int lenMinus1) throws IOException {
        Writer output = this.out;
        for (int i = 0; i < lenMinus1; ++i) {
            output.write(booleans[i] ? "true," : "false,");
        }
        output.write(Boolean.toString(booleans[lenMinus1]));
    }

    private void writeDoubleArray(double[] doubles, int lenMinus1) throws IOException {
        Writer output = this.out;
        com.cedarsoftware.io.JsonClassWriter writer = this.getWriteOptions().getCustomWriter(Double.class);
        for (int i = 0; i < lenMinus1; ++i) {
            writer.write(doubles[i], false, output, this);
            output.write(44);
        }
        writer.write(doubles[lenMinus1], false, output, this);
    }

    private void writeFloatArray(float[] floats, int lenMinus1) throws IOException {
        Writer output = this.out;
        com.cedarsoftware.io.JsonClassWriter writer = this.getWriteOptions().getCustomWriter(Float.class);
        for (int i = 0; i < lenMinus1; ++i) {
            writer.write(Float.valueOf(floats[i]), false, output, this);
            output.write(44);
        }
        writer.write(Float.valueOf(floats[lenMinus1]), false, output, this);
    }

    private void writeLongArray(long[] longs, int lenMinus1) throws IOException {
        Writer output = this.out;
        com.cedarsoftware.io.JsonClassWriter writer = this.getWriteOptions().getCustomWriter(Long.TYPE);
        for (int i = 0; i < lenMinus1; ++i) {
            writer.write(longs[i], false, output, this);
            output.write(44);
        }
        writer.write(longs[lenMinus1], false, output, this);
    }

    private void writeIntArray(int[] ints, int lenMinus1) throws IOException {
        if (ints == null) {
            throw new JsonIoException("Int array cannot be null");
        }
        if (lenMinus1 < 0 || lenMinus1 >= ints.length) {
            throw new JsonIoException("Invalid array bounds: lenMinus1=" + lenMinus1 + ", array.length=" + ints.length);
        }
        Writer output = this.out;
        for (int i = 0; i < lenMinus1; ++i) {
            output.write(Integer.toString(ints[i]));
            output.write(44);
        }
        output.write(Integer.toString(ints[lenMinus1]));
    }

    private void writeShortArray(short[] shorts, int lenMinus1) throws IOException {
        Writer output = this.out;
        for (int i = 0; i < lenMinus1; ++i) {
            output.write(Integer.toString(shorts[i]));
            output.write(44);
        }
        output.write(Integer.toString(shorts[lenMinus1]));
    }

    private void writeByteArray(byte[] bytes, int lenMinus1) throws IOException {
        if (bytes == null) {
            throw new JsonIoException("Byte array cannot be null");
        }
        if (lenMinus1 < 0 || lenMinus1 >= bytes.length) {
            throw new JsonIoException("Invalid array bounds: lenMinus1=" + lenMinus1 + ", array.length=" + bytes.length);
        }
        Writer output = this.out;
        Object[] byteStrs = byteStrings;
        for (int i = 0; i < lenMinus1; ++i) {
            int index = bytes[i] + 128;
            if (index < 0 || index >= byteStrs.length) {
                throw new JsonIoException("Byte value out of range: " + bytes[i]);
            }
            output.write((char[])byteStrs[index]);
            output.write(44);
        }
        int finalIndex = bytes[lenMinus1] + 128;
        if (finalIndex < 0 || finalIndex >= byteStrs.length) {
            throw new JsonIoException("Byte value out of range: " + bytes[lenMinus1]);
        }
        output.write((char[])byteStrs[finalIndex]);
    }

    private void writeCollection(Collection<?> col, boolean showType) throws IOException {
        if (this.writeOptions.isNeverShowingType()) {
            showType = false;
        }
        Writer output = this.out;
        boolean referenced = this.objsReferenced.containsKey(col);
        boolean isEmpty = col.isEmpty();
        if (referenced || showType) {
            output.write(123);
            this.tabIn();
        } else if (isEmpty) {
            output.write(91);
        }
        this.writeIdAndTypeIfNeeded(col, showType, referenced);
        if (isEmpty) {
            if (referenced || showType) {
                this.tabOut();
                output.write(125);
            } else {
                output.write(93);
            }
            return;
        }
        this.beginCollection(showType, referenced);
        Iterator<?> i = col.iterator();
        this.writeElements(output, i);
        if (this.writeOptions.isJson5TrailingCommas()) {
            output.write(44);
        }
        this.tabOut();
        output.write(93);
        if (showType || referenced) {
            this.tabOut();
            output.write("}");
        }
    }

    private void writeElements(Writer output, Iterator<?> i) throws IOException {
        while (i.hasNext()) {
            this.writeCollectionElement(i.next());
            if (!i.hasNext()) continue;
            output.write(44);
            this.newLine();
        }
    }

    private String getTypeNameForOutput(Object obj) {
        JsonObject jsonObj;
        String typeString;
        if (obj instanceof JsonObject && (typeString = (jsonObj = (JsonObject)obj).getTypeString()) != null && !typeString.isEmpty() && !typeString.equals(obj.getClass().getName())) {
            return typeString;
        }
        return obj.getClass().getName();
    }

    private void writeIdAndTypeIfNeeded(Object col, boolean showType, boolean referenced) throws IOException {
        if (this.writeOptions.isNeverShowingType()) {
            showType = false;
        }
        if (referenced) {
            this.writeId(this.getIdLong(col));
        }
        if (showType) {
            if (referenced) {
                this.out.write(44);
                this.newLine();
            }
            this.writeType(this.getTypeNameForOutput(col), this.out);
        }
    }

    private void beginCollection(boolean showType, boolean referenced) throws IOException {
        if (showType || referenced) {
            this.out.write(44);
            this.newLine();
            this.out.write(this.itemsPrefix);
            this.out.write(91);
        } else {
            this.out.write(91);
        }
        this.tabIn();
    }

    private void writeJsonObjectArray(JsonObject jObj, boolean showType) throws IOException {
        boolean typeWritten;
        Object[] items;
        if (this.writeOptions.isNeverShowingType()) {
            showType = false;
        }
        int len = (items = jObj.getItems()) != null ? items.length : 0;
        Class<?> jsonObjectType = jObj.getRawType();
        Class arrayClass = jsonObjectType == null || Object[].class.equals(jsonObjectType) ? Object[].class : jsonObjectType;
        Writer output = this.out;
        boolean isObjectArray = Object[].class == arrayClass;
        Class<?> componentClass = arrayClass.getComponentType();
        boolean referenced = this.adjustIfReferenced(jObj);
        boolean bl = typeWritten = showType && !isObjectArray;
        if (typeWritten || referenced) {
            output.write(123);
            this.tabIn();
        }
        if (referenced) {
            this.writeId(jObj.id);
            output.write(44);
            this.newLine();
        }
        if (typeWritten) {
            this.writeType(arrayClass.getName(), output);
            output.write(44);
            this.newLine();
        }
        if (len == 0) {
            if (typeWritten || referenced) {
                output.write(this.itemsPrefix);
                output.write("[]");
                this.tabOut();
                output.write("}");
            } else {
                output.write("[]");
            }
            return;
        }
        if (typeWritten || referenced) {
            output.write(this.itemsPrefix);
            output.write(91);
        } else {
            output.write(91);
        }
        this.tabIn();
        int lenMinus1 = len - 1;
        for (int i = 0; i < len; ++i) {
            Object value = items[i];
            if (value == null) {
                output.write("null");
            } else {
                boolean forceType = this.isForceType(value.getClass(), componentClass);
                if (!this.writeArrayElementIfMatching(componentClass, value, forceType, output)) {
                    if (Character.class == componentClass || Character.TYPE == componentClass) {
                        this.writeStringValue((String)value);
                    } else if (value instanceof String) {
                        this.writeStringValue((String)value);
                    } else if (value instanceof Boolean || value instanceof Long || value instanceof Double) {
                        this.writePrimitive(value, forceType);
                    } else {
                        this.writeImpl(value, forceType);
                    }
                }
            }
            if (i == lenMinus1) continue;
            output.write(44);
            this.newLine();
        }
        if (len > 0 && this.writeOptions.isJson5TrailingCommas()) {
            output.write(44);
        }
        this.tabOut();
        output.write(93);
        if (typeWritten || referenced) {
            this.tabOut();
            output.write(125);
        }
    }

    private void writeJsonObjectCollection(JsonObject jObj, boolean showType) throws IOException {
        int len;
        if (this.writeOptions.isNeverShowingType()) {
            showType = false;
        }
        Class<?> colClass = jObj.getRawType();
        boolean referenced = this.adjustIfReferenced(jObj);
        Writer output = this.out;
        Object[] items = jObj.getItems();
        int n = len = items != null ? items.length : 0;
        if (referenced || showType || len == 0) {
            output.write(123);
            this.tabIn();
        }
        if (referenced) {
            this.writeId(jObj.id);
        }
        if (showType) {
            if (referenced) {
                output.write(44);
                this.newLine();
            }
            this.writeType(colClass.getName(), output);
        }
        if (len == 0) {
            this.tabOut();
            output.write(125);
            return;
        }
        this.beginCollection(showType, referenced);
        int itemsLen = items.length;
        int itemsLenMinus1 = itemsLen - 1;
        for (int i = 0; i < itemsLen; ++i) {
            this.writeCollectionElement(items[i]);
            if (i == itemsLenMinus1) continue;
            output.write(44);
            this.newLine();
        }
        this.tabOut();
        output.write("]");
        if (showType || referenced) {
            this.tabOut();
            output.write(125);
        }
    }

    private void writeJsonObjectMap(JsonObject jObj, boolean showType) throws IOException {
        if (this.writeOptions.isNeverShowingType()) {
            showType = false;
        }
        Writer output = this.out;
        showType = this.emitIdAndTypeIfNeeded(jObj, showType, output);
        if (jObj.isEmpty()) {
            this.tabOut();
            output.write(125);
            return;
        }
        if (showType) {
            output.write(44);
            this.newLine();
        }
        this.writeMapToEnd(jObj, output);
    }

    private boolean writeJsonObjectMapWithStringKeys(JsonObject jObj, boolean showType) throws IOException {
        if (this.writeOptions.isNeverShowingType()) {
            showType = false;
        }
        if (this.writeOptions.isForceMapOutputAsTwoArrays() || !JsonWriter.ensureJsonPrimitiveKeys(jObj)) {
            return false;
        }
        Writer output = this.out;
        this.emitIdAndTypeIfNeeded(jObj, showType, output);
        if (jObj.isEmpty()) {
            this.tabOut();
            output.write(125);
            return true;
        }
        if (showType) {
            output.write(44);
            this.newLine();
        }
        return this.writeMapBody(jObj.entrySet().iterator());
    }

    private boolean emitIdAndTypeIfNeeded(JsonObject jObj, boolean showType, Writer output) throws IOException {
        boolean referenced = this.adjustIfReferenced(jObj);
        output.write(123);
        this.tabIn();
        if (referenced) {
            this.writeId(jObj.getId());
        }
        if (showType) {
            String type;
            if (referenced) {
                output.write(44);
                this.newLine();
            }
            if ((type = this.getTypeNameForOutput(jObj)) != null) {
                this.writeType(type, output);
            } else {
                showType = false;
            }
        }
        return showType;
    }

    private void writeJsonObjectObject(JsonObject jObj, boolean showType) throws IOException {
        if (this.writeOptions.isNeverShowingType()) {
            showType = false;
        }
        Writer output = this.out;
        boolean referenced = this.adjustIfReferenced(jObj);
        showType = showType && jObj.getType() != null;
        output.write(123);
        this.tabIn();
        if (referenced) {
            this.writeId(jObj.id);
        }
        Class<?> type = null;
        if (showType) {
            if (referenced) {
                output.write(44);
                this.newLine();
            }
            this.writeType(this.getTypeNameForOutput(jObj), output);
            type = jObj.getRawType();
        }
        if (jObj.isEmpty()) {
            this.tabOut();
            output.write(125);
            return;
        }
        if (showType || referenced) {
            output.write(44);
            this.newLine();
        }
        Iterator<Map.Entry<Object, Object>> i = jObj.entrySet().iterator();
        boolean first = true;
        while (i.hasNext()) {
            Map.Entry<Object, Object> entry = i.next();
            if (this.writeOptions.isSkipNullFields() && entry.getValue() == null) continue;
            if (!first) {
                output.write(44);
                this.newLine();
            }
            first = false;
            String fieldName = (String)entry.getKey();
            output.write(34);
            output.write(fieldName);
            output.write("\":");
            Object value = entry.getValue();
            if (value == null) {
                output.write("null");
                continue;
            }
            if (value instanceof BigDecimal || value instanceof BigInteger) {
                this.writeImpl(value, !this.doesValueTypeMatchFieldType(type, fieldName, value));
                continue;
            }
            if (value instanceof Number || value instanceof Boolean) {
                output.write(value.toString());
                continue;
            }
            if (value instanceof String) {
                this.writeStringValue((String)value);
                continue;
            }
            if (value instanceof Character) {
                this.writeStringValue(String.valueOf(value));
                continue;
            }
            this.writeImpl(value, !this.doesValueTypeMatchFieldType(type, fieldName, value));
        }
        if (!jObj.isEmpty() && this.writeOptions.isJson5TrailingCommas()) {
            output.write(44);
        }
        this.tabOut();
        output.write(125);
    }

    private boolean adjustIfReferenced(JsonObject jObj) {
        Long idx = this.objsReferenced.get(jObj);
        if (!jObj.hasId() && idx != null && idx > 0L) {
            jObj.id = idx.intValue();
        }
        return this.objsReferenced.containsKey(jObj) && jObj.hasId();
    }

    private boolean doesValueTypeMatchFieldType(Class<?> type, String fieldName, Object value) {
        if (type != null) {
            Map<String, Field> fieldMap = this.writeOptions.getDeepDeclaredFields(type);
            Field field = fieldMap.get(fieldName);
            return field != null && field.getType().equals(value.getClass());
        }
        return false;
    }

    private void writeMap(Map map, boolean showType) throws IOException {
        if (this.writeOptions.isNeverShowingType()) {
            showType = false;
        }
        Writer output = this.out;
        boolean referenced = this.objsReferenced.containsKey(map);
        output.write(123);
        this.tabIn();
        if (referenced) {
            this.writeId(this.getIdLong(map));
        }
        if (showType) {
            if (referenced) {
                output.write(44);
                this.newLine();
            }
            this.writeType(this.getTypeNameForOutput(map), output);
        }
        if (map.isEmpty()) {
            this.tabOut();
            output.write(125);
            return;
        }
        if (showType || referenced) {
            output.write(44);
            this.newLine();
        }
        this.writeMapToEnd(map, output);
    }

    private void writeMapToEnd(Map map, Writer output) throws IOException {
        Class<?> savedValueType = this.declaredElementType;
        output.write(this.keysPrefix);
        output.write(91);
        this.tabIn();
        Iterator<Object> i = map.keySet().iterator();
        this.declaredElementType = this.declaredKeyType;
        this.writeElements(output, i);
        if (!map.isEmpty() && this.writeOptions.isJson5TrailingCommas()) {
            output.write(44);
        }
        this.tabOut();
        output.write("],");
        this.newLine();
        output.write(this.itemsPrefix);
        output.write(91);
        this.tabIn();
        i = map.values().iterator();
        this.declaredElementType = savedValueType;
        this.writeElements(output, i);
        if (!map.isEmpty() && this.writeOptions.isJson5TrailingCommas()) {
            output.write(44);
        }
        this.tabOut();
        output.write(93);
        if (this.writeOptions.isJson5TrailingCommas()) {
            output.write(44);
        }
        this.tabOut();
        output.write(125);
    }

    private boolean writeMapWithStringKeys(Map map, boolean showType) throws IOException {
        if (this.writeOptions.isNeverShowingType()) {
            showType = false;
        }
        if (this.writeOptions.isForceMapOutputAsTwoArrays() || !JsonWriter.ensureJsonPrimitiveKeys(map)) {
            return false;
        }
        boolean referenced = this.objsReferenced.containsKey(map);
        this.out.write(123);
        this.tabIn();
        this.writeIdAndTypeIfNeeded(map, showType, referenced);
        if (map.isEmpty()) {
            this.tabOut();
            this.out.write(125);
            return true;
        }
        if (showType || referenced) {
            this.out.write(44);
            this.newLine();
        }
        return this.writeMapBody(map.entrySet().iterator());
    }

    private boolean writeMapBody(Iterator i) throws IOException {
        Writer output = this.out;
        boolean wroteEntry = false;
        while (i.hasNext()) {
            Map.Entry att2value = (Map.Entry)i.next();
            Object value = att2value.getValue();
            if (this.writeOptions.isSkipNullFields() && value == null) continue;
            String key = (String)att2value.getKey();
            this.writeKey(key);
            this.writeCollectionElement(value);
            wroteEntry = true;
            if (!i.hasNext()) continue;
            output.write(44);
            this.newLine();
        }
        if (wroteEntry && this.writeOptions.isJson5TrailingCommas()) {
            output.write(44);
        }
        this.tabOut();
        output.write(125);
        return true;
    }

    public static boolean ensureJsonPrimitiveKeys(Map map) {
        for (Object o : map.keySet()) {
            if (o instanceof String) continue;
            return false;
        }
        return true;
    }

    private void writeCollectionElement(Object o) throws IOException {
        if (o == null) {
            this.out.write("null");
        } else if (o instanceof Boolean || o instanceof Double) {
            this.writePrimitive(o, false);
        } else if (o instanceof Long) {
            this.writePrimitive(o, this.getWriteOptions().isWriteLongsAsStrings());
        } else if (o instanceof String) {
            this.writeStringValue((String)o);
        } else if (this.getWriteOptions().isNeverShowingType() && ClassUtilities.isPrimitive(o.getClass())) {
            this.writePrimitive(o, false);
        } else {
            boolean showType = this.shouldShowTypeForElement(o.getClass());
            this.writeImpl(o, showType);
        }
    }

    private boolean shouldShowTypeForElement(Class<?> elementClass) {
        if (this.declaredElementType == null) {
            return true;
        }
        if (elementClass.isEnum()) {
            return true;
        }
        return elementClass != this.declaredElementType;
    }

    private void writeEnumSet(EnumSet<?> enumSet) throws IOException {
        boolean hasItems;
        this.out.write(123);
        this.tabIn();
        boolean referenced = this.objsReferenced.containsKey(enumSet);
        if (referenced) {
            this.writeId(this.getIdLong(enumSet));
            this.out.write(44);
            this.newLine();
        }
        String typeKey = this.writeOptions.isEnumSetWrittenOldWay() ? "@enum" : "@type";
        this.out.write(34);
        this.out.write(typeKey);
        this.out.write("\":");
        Class enumClass = null;
        Field elementTypeField = this.writeOptions.getDeepDeclaredFields(EnumSet.class).get("elementType");
        if (elementTypeField != null) {
            enumClass = (Class<MetaUtils.Dumpty>)this.getValueByReflect(enumSet, elementTypeField);
            Class<Object> actualEnumClass = ClassUtilities.getClassIfEnum((Class)enumClass);
            Class<Object> clazz = enumClass = actualEnumClass != null ? actualEnumClass : enumClass;
        }
        if (enumClass == null) {
            Enum e;
            Class<?> actualEnumClass;
            EnumSet<?> complement;
            Enum e2;
            Class<?> actualEnumClass2;
            enumClass = !enumSet.isEmpty() ? ((actualEnumClass2 = ClassUtilities.getClassIfEnum((e2 = (Enum)enumSet.iterator().next()).getClass())) != null ? actualEnumClass2 : e2.getClass()) : (!(complement = EnumSet.complementOf(enumSet)).isEmpty() ? ((actualEnumClass = ClassUtilities.getClassIfEnum((e = (Enum)complement.iterator().next()).getClass())) != null ? actualEnumClass : e.getClass()) : MetaUtils.Dumpty.class);
        }
        JsonWriter.writeBasicString(this.out, enumClass.getName());
        this.out.write(",");
        this.newLine();
        JsonWriter.writeBasicString(this.out, "@items");
        this.out.write(":[");
        boolean bl = hasItems = !enumSet.isEmpty();
        if (hasItems) {
            this.newLine();
            this.tabIn();
            boolean firstInSet = true;
            for (Enum e : enumSet) {
                if (!firstInSet) {
                    this.out.write(",");
                    this.newLine();
                }
                firstInSet = false;
                List<Accessor> mapOfFields = this.writeOptions.getAccessorsForClass(e.getClass());
                int enumFieldsCount = mapOfFields.size();
                if (enumFieldsCount <= 2) {
                    this.writeStringValue(e.name());
                    continue;
                }
                this.out.write(123);
                boolean firstInEntry = true;
                for (Accessor f : mapOfFields) {
                    firstInEntry = this.writeField(e, firstInEntry, f.getUniqueFieldName(), f);
                }
                this.out.write(125);
            }
            this.tabOut();
            this.newLine();
        }
        this.out.write(93);
        this.tabOut();
        this.newLine();
        this.out.write(125);
    }

    @Override
    public void writeObject(Object obj, boolean showType, boolean bodyOnly) throws IOException {
        boolean first;
        if (this.writeOptions.isNeverShowingType()) {
            showType = false;
        }
        boolean referenced = this.objsReferenced.containsKey(obj);
        if (!bodyOnly) {
            this.out.write(123);
            this.tabIn();
            if (referenced) {
                this.writeId(this.getIdLong(obj));
            }
            if (referenced && showType) {
                this.out.write(44);
                this.newLine();
            }
            if (showType) {
                this.writeType(obj.getClass().getName(), this.out);
            }
        }
        boolean bl = first = !showType;
        if (referenced && !showType) {
            first = false;
        }
        List<Accessor> accessors = this.writeOptions.getAccessorsForClass(obj.getClass());
        for (Accessor accessor : accessors) {
            String fieldName = accessor.getUniqueFieldName();
            first = this.writeField(obj, first, fieldName, accessor);
        }
        if (!bodyOnly) {
            this.tabOut();
            this.out.write(125);
        }
    }

    private Object getValueByReflect(Object obj, Field field) {
        if (field == null) {
            return null;
        }
        if (obj == null && !Modifier.isStatic(field.getModifiers())) {
            return null;
        }
        try {
            if (!field.isAccessible() && !Modifier.isPublic(field.getModifiers())) {
                return null;
            }
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            return field.get(obj);
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (SecurityException e) {
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeField(Object obj, boolean first, String fieldName, Accessor accessor) throws IOException {
        Class<?> fieldDeclaringClass = accessor.getDeclaringClass();
        if (Enum.class.isAssignableFrom(fieldDeclaringClass) && !accessor.isPublic() && this.writeOptions.isEnumPublicFieldsOnly()) {
            return first;
        }
        Object o = accessor.retrieve(obj);
        if (this.writeOptions.isSkipNullFields() && o == null) {
            return first;
        }
        if (!first) {
            this.out.write(44);
            this.newLine();
        }
        this.writeKey(fieldName);
        if (o == null) {
            this.out.write("null");
            return false;
        }
        Class<?> type = accessor.getFieldType();
        Class<?> savedElementType = this.declaredElementType;
        Class<?> savedKeyType = this.declaredKeyType;
        try {
            Type genericType;
            if ((o instanceof Collection || o instanceof Map) && !Throwable.class.isAssignableFrom(fieldDeclaringClass) && (genericType = accessor.getGenericType()) != null) {
                Type elementType;
                Type keyType;
                if (o instanceof Map && (keyType = this.extractMapKeyType(genericType)) instanceof Class) {
                    this.declaredKeyType = (Class)keyType;
                }
                if ((elementType = TypeUtilities.inferElementType((Type)genericType, null)) instanceof Class) {
                    this.declaredElementType = (Class)elementType;
                }
            }
            this.writeImpl(o, this.isForceType(o.getClass(), type));
        }
        finally {
            this.declaredElementType = savedElementType;
            this.declaredKeyType = savedKeyType;
        }
        return false;
    }

    private boolean isForceType(Class<?> objectClass, Class<?> declaredType) {
        boolean declaredClassIsLongWrittenAsString;
        boolean writeLongsAsStrings = this.writeOptions.isWriteLongsAsStrings();
        boolean objectClassIsLongWrittenAsString = (objectClass == Long.class || objectClass == Long.TYPE) && writeLongsAsStrings;
        boolean bl = declaredClassIsLongWrittenAsString = (declaredType == Long.class || objectClass == Long.TYPE) && writeLongsAsStrings;
        if (Primitives.isNativeJsonType(objectClass) && !objectClassIsLongWrittenAsString) {
            return false;
        }
        if (Primitives.isPrimitive(declaredType) && !declaredClassIsLongWrittenAsString) {
            return false;
        }
        if (this.writeOptions.isNeverShowingType() && Primitives.isPrimitive(objectClass) && !objectClassIsLongWrittenAsString) {
            return false;
        }
        if (this.writeOptions.isAlwaysShowingType()) {
            return true;
        }
        if (objectClass == declaredType) {
            return false;
        }
        if (declaredType.isEnum() && declaredType.isAssignableFrom(objectClass)) {
            Class enumClass = ClassUtilities.getClassIfEnum(objectClass);
            return !declaredType.equals(enumClass);
        }
        return true;
    }

    private Type extractMapKeyType(Type mapType) {
        ParameterizedType pt;
        Type[] typeArgs;
        if (mapType instanceof ParameterizedType && (typeArgs = (pt = (ParameterizedType)mapType).getActualTypeArguments()).length >= 1) {
            return typeArgs[0];
        }
        return null;
    }

    @Override
    public void flush() {
        if (this.out != null) {
            IOUtilities.flush((Flushable)this.out);
        }
    }

    @Override
    public void close() {
        if (this.out != null) {
            IOUtilities.close((Closeable)this.out);
        }
    }

    private long getIdLong(Object o) {
        long id;
        if (o instanceof JsonObject && (id = (long)((JsonObject)o).id) > 0L) {
            return id;
        }
        Long id2 = this.objsReferenced.get(o);
        return id2 == null ? 0L : id2;
    }

    public static void writeBasicString(Writer writer, String s) throws IOException {
        writer.write(34);
        writer.write(s);
        writer.write(34);
    }

    public static void writeJsonUtf8String(Writer output, String s) throws IOException {
        JsonWriter.writeJsonUtf8String(output, s, 1000000);
    }

    public static void writeJson5String(Writer output, String s, WriteOptions writeOptions) throws IOException {
        if (writeOptions == null || !writeOptions.isJson5SmartQuotes()) {
            JsonWriter.writeJsonUtf8String(output, s, writeOptions != null ? writeOptions.getMaxStringLength() : 1000000);
            return;
        }
        int maxLen = writeOptions.getMaxStringLength();
        boolean hasDoubleQuote = false;
        boolean hasSingleQuote = false;
        int len = s != null ? s.length() : 0;
        for (int i = 0; !(i >= len || hasDoubleQuote && hasSingleQuote); ++i) {
            char c = s.charAt(i);
            if (c == '\"') {
                hasDoubleQuote = true;
                continue;
            }
            if (c != '\'') continue;
            hasSingleQuote = true;
        }
        if (hasDoubleQuote && !hasSingleQuote) {
            JsonWriter.writeSingleQuotedString(output, s, maxLen);
        } else {
            JsonWriter.writeJsonUtf8String(output, s, maxLen);
        }
    }

    public static void writeJsonUtf8String(Writer output, String s, int maxStringLength) throws IOException {
        if (output == null) {
            throw new JsonIoException("Output writer cannot be null");
        }
        if (s == null) {
            output.write("null");
            return;
        }
        output.write(34);
        int len = s.length();
        if (len > maxStringLength) {
            throw new JsonIoException("String too large for JSON serialization: " + len + " characters. Maximum allowed: " + maxStringLength);
        }
        int start = 0;
        int i = 0;
        while (i < len) {
            int codePoint;
            char ch = s.charAt(i);
            if (ch < '\u0080' && !NEEDS_ESCAPE[ch]) {
                ++i;
                continue;
            }
            if (i > start) {
                output.write(s, start, i - start);
            }
            if ((codePoint = s.codePointAt(i)) < 32 || codePoint == 127) {
                switch (codePoint) {
                    case 8: {
                        output.write("\\b");
                        break;
                    }
                    case 12: {
                        output.write("\\f");
                        break;
                    }
                    case 10: {
                        output.write("\\n");
                        break;
                    }
                    case 13: {
                        output.write("\\r");
                        break;
                    }
                    case 9: {
                        output.write("\\t");
                        break;
                    }
                    default: {
                        output.write(String.format("\\u%04x", codePoint));
                        break;
                    }
                }
            } else if (codePoint == 34) {
                output.write("\\\"");
            } else if (codePoint == 92) {
                output.write("\\\\");
            } else if (codePoint >= 128 && codePoint <= 65535) {
                output.write(s, i, Character.charCount(codePoint));
            } else if (codePoint > 65535) {
                output.write(s, i, Character.charCount(codePoint));
            }
            start = i += Character.charCount(codePoint);
        }
        if (start < len) {
            output.write(s, start, len - start);
        }
        output.write(34);
    }

    private void writeStringValue(String s) throws IOException {
        if (!this.writeOptions.isJson5SmartQuotes()) {
            JsonWriter.writeJsonUtf8String(this.out, s, this.writeOptions.getMaxStringLength());
            return;
        }
        boolean hasDoubleQuote = false;
        boolean hasSingleQuote = false;
        int len = s != null ? s.length() : 0;
        for (int i = 0; !(i >= len || hasDoubleQuote && hasSingleQuote); ++i) {
            char c = s.charAt(i);
            if (c == '\"') {
                hasDoubleQuote = true;
                continue;
            }
            if (c != '\'') continue;
            hasSingleQuote = true;
        }
        if (hasDoubleQuote && !hasSingleQuote) {
            JsonWriter.writeSingleQuotedString(this.out, s, this.writeOptions.getMaxStringLength());
        } else {
            JsonWriter.writeJsonUtf8String(this.out, s, this.writeOptions.getMaxStringLength());
        }
    }

    public static void writeSingleQuotedString(Writer output, String s, int maxStringLength) throws IOException {
        if (output == null) {
            throw new JsonIoException("Output writer cannot be null");
        }
        if (s == null) {
            output.write("null");
            return;
        }
        output.write(39);
        int len = s.length();
        if (len > maxStringLength) {
            throw new JsonIoException("String too large for JSON serialization: " + len + " characters. Maximum allowed: " + maxStringLength);
        }
        int start = 0;
        int i = 0;
        while (i < len) {
            int codePoint;
            char ch = s.charAt(i);
            if (ch < '\u0080' && !NEEDS_ESCAPE_SINGLE_QUOTE[ch]) {
                ++i;
                continue;
            }
            if (i > start) {
                output.write(s, start, i - start);
            }
            if ((codePoint = s.codePointAt(i)) < 32 || codePoint == 127) {
                switch (codePoint) {
                    case 8: {
                        output.write("\\b");
                        break;
                    }
                    case 12: {
                        output.write("\\f");
                        break;
                    }
                    case 10: {
                        output.write("\\n");
                        break;
                    }
                    case 13: {
                        output.write("\\r");
                        break;
                    }
                    case 9: {
                        output.write("\\t");
                        break;
                    }
                    default: {
                        output.write(String.format("\\u%04x", codePoint));
                        break;
                    }
                }
            } else if (codePoint == 39) {
                output.write("\\'");
            } else if (codePoint == 92) {
                output.write("\\\\");
            } else if (codePoint >= 128 && codePoint <= 65535) {
                output.write(s, i, Character.charCount(codePoint));
            } else if (codePoint > 65535) {
                output.write(s, i, Character.charCount(codePoint));
            }
            start = i += Character.charCount(codePoint);
        }
        if (start < len) {
            output.write(s, start, len - start);
        }
        output.write(39);
    }

    private void writeCommaIfNeeded() throws IOException {
        WriteContext ctx = this.contextStack.peek();
        if (ctx == WriteContext.OBJECT_FIELD || ctx == WriteContext.ARRAY_ELEMENT) {
            this.out.write(44);
        }
    }

    private void markArrayElementWritten() {
        WriteContext ctx;
        if (!this.contextStack.isEmpty() && (ctx = this.contextStack.peek()) == WriteContext.ARRAY_EMPTY) {
            this.contextStack.pop();
            this.contextStack.push(WriteContext.ARRAY_ELEMENT);
        }
    }

    private void markObjectFieldWritten() {
        WriteContext ctx;
        if (!this.contextStack.isEmpty() && (ctx = this.contextStack.peek()) == WriteContext.OBJECT_EMPTY) {
            this.contextStack.pop();
            this.contextStack.push(WriteContext.OBJECT_FIELD);
        }
    }

    @Override
    public void writeFieldName(String name) throws IOException {
        WriteContext ctx = this.contextStack.peek();
        if (ctx == WriteContext.OBJECT_FIELD) {
            this.out.write(44);
        }
        this.writeKey(name);
        this.markObjectFieldWritten();
    }

    @Override
    public void writeStringField(String name, String value) throws IOException {
        this.out.write(44);
        this.writeKey(name);
        if (value == null) {
            this.out.write("null");
        } else {
            this.writeStringValue(value);
        }
        this.markObjectFieldWritten();
    }

    @Override
    public void writeObjectField(String name, Object value) throws IOException {
        this.out.write(44);
        this.writeKey(name);
        this.writeImpl(value, true);
        this.markObjectFieldWritten();
    }

    @Override
    public void writeStartObject() throws IOException {
        this.writeCommaIfNeeded();
        this.out.write(123);
        this.markArrayElementWritten();
        this.contextStack.push(WriteContext.OBJECT_EMPTY);
    }

    @Override
    public void writeEndObject() throws IOException {
        this.out.write(125);
        if (!this.contextStack.isEmpty()) {
            this.contextStack.pop();
        }
    }

    @Override
    public void writeStartArray() throws IOException {
        this.writeCommaIfNeeded();
        this.out.write(91);
        this.markArrayElementWritten();
        this.contextStack.push(WriteContext.ARRAY_EMPTY);
    }

    @Override
    public void writeEndArray() throws IOException {
        this.out.write(93);
        if (!this.contextStack.isEmpty()) {
            this.contextStack.pop();
        }
    }

    @Override
    public void writeValue(String value) throws IOException {
        this.writeCommaIfNeeded();
        if (value == null) {
            this.out.write("null");
        } else {
            this.writeStringValue(value);
        }
        this.markArrayElementWritten();
    }

    @Override
    public void writeValue(Object value) throws IOException {
        this.writeCommaIfNeeded();
        this.writeImpl(value, true);
        this.markArrayElementWritten();
    }

    @Override
    public void writeArrayFieldStart(String name) throws IOException {
        this.out.write(44);
        this.writeKey(name);
        this.out.write(91);
        this.markObjectFieldWritten();
        this.contextStack.push(WriteContext.ARRAY_EMPTY);
    }

    @Override
    public void writeObjectFieldStart(String name) throws IOException {
        this.out.write(44);
        this.writeKey(name);
        this.out.write(123);
        this.markObjectFieldWritten();
        this.contextStack.push(WriteContext.OBJECT_EMPTY);
    }

    @Override
    public void writeNumberField(String name, Number value) throws IOException {
        this.out.write(44);
        this.writeKey(name);
        if (value == null) {
            this.out.write("null");
        } else {
            this.out.write(value.toString());
        }
        this.markObjectFieldWritten();
    }

    @Override
    public void writeBooleanField(String name, boolean value) throws IOException {
        this.out.write(44);
        this.writeKey(name);
        this.out.write(value ? "true" : "false");
        this.markObjectFieldWritten();
    }

    private void writeKey(String name) throws IOException {
        if (this.writeOptions.isJson5UnquotedKeys() && JsonWriter.isValidJson5Identifier(name)) {
            this.out.write(name);
            this.out.write(58);
        } else {
            JsonWriter.writeJsonUtf8String(this.out, name, this.writeOptions.getMaxStringLength());
            this.out.write(58);
        }
    }

    private static boolean isValidJson5Identifier(String name) {
        if (name == null || name.isEmpty()) {
            return false;
        }
        char first = name.charAt(0);
        if (!JsonWriter.isIdentifierStart(first)) {
            return false;
        }
        for (int i = 1; i < name.length(); ++i) {
            if (JsonWriter.isIdentifierPart(name.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isIdentifierStart(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c == '$';
    }

    private static boolean isIdentifierPart(char c) {
        return JsonWriter.isIdentifierStart(c) || c >= '0' && c <= '9';
    }

    private boolean isNanInfinityAllowed() {
        return this.writeOptions.isAllowNanAndInfinity() || this.writeOptions.isJson5InfinityNaN();
    }

    static {
        int i;
        LOG = Logger.getLogger(JsonWriter.class.getName());
        byteStrings = new Object[256];
        NEW_LINE = System.lineSeparator();
        ZERO = 0L;
        NEEDS_ESCAPE = new boolean[128];
        NEEDS_ESCAPE_SINGLE_QUOTE = new boolean[128];
        writeTypeCache = new ClassValue<WriteType>(){

            @Override
            protected WriteType computeValue(Class<?> type) {
                if (type.isArray()) {
                    return type.getComponentType().isPrimitive() ? WriteType.PRIMITIVE_ARRAY : WriteType.OBJECT_ARRAY;
                }
                if (JsonObject.class.isAssignableFrom(type)) {
                    return WriteType.JSON_OBJECT;
                }
                if (EnumSet.class.isAssignableFrom(type)) {
                    return WriteType.ENUM_SET;
                }
                if (Collection.class.isAssignableFrom(type)) {
                    return WriteType.COLLECTION;
                }
                if (Map.class.isAssignableFrom(type)) {
                    return WriteType.MAP;
                }
                return WriteType.POJO;
            }
        };
        for (i = -128; i <= 127; i = (int)((short)(i + 1))) {
            char[] chars = Integer.toString(i).toCharArray();
            JsonWriter.byteStrings[i + 128] = chars;
        }
        for (i = 0; i < 32; ++i) {
            JsonWriter.NEEDS_ESCAPE[i] = true;
        }
        JsonWriter.NEEDS_ESCAPE[34] = true;
        JsonWriter.NEEDS_ESCAPE[92] = true;
        JsonWriter.NEEDS_ESCAPE[127] = true;
        for (i = 0; i < 32; ++i) {
            JsonWriter.NEEDS_ESCAPE_SINGLE_QUOTE[i] = true;
        }
        JsonWriter.NEEDS_ESCAPE_SINGLE_QUOTE[39] = true;
        JsonWriter.NEEDS_ESCAPE_SINGLE_QUOTE[92] = true;
        JsonWriter.NEEDS_ESCAPE_SINGLE_QUOTE[127] = true;
        DIGIT_TENS = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9'};
        DIGIT_ONES = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    }

    private static enum WriteType {
        PRIMITIVE_ARRAY,
        OBJECT_ARRAY,
        ENUM_SET,
        COLLECTION,
        JSON_OBJECT,
        MAP,
        POJO;

    }

    static enum WriteContext {
        ROOT,
        OBJECT_EMPTY,
        OBJECT_FIELD,
        ARRAY_EMPTY,
        ARRAY_ELEMENT;

    }

    @Deprecated
    public static interface JsonClassWriter<T>
    extends com.cedarsoftware.io.JsonClassWriter<T> {
    }
}

