/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io.writers;

import com.cedarsoftware.io.JsonClassWriter;
import com.cedarsoftware.io.WriterContext;
import com.cedarsoftware.util.MultiKeyMap;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;

public class MultiKeyMapWriter
implements JsonClassWriter {
    public void write(Object obj, boolean showType, Writer output, WriterContext context) throws IOException {
        String modeCode;
        MultiKeyMap map = (MultiKeyMap)obj;
        int capacity = map.getCapacity();
        float loadFactor = map.getLoadFactor();
        MultiKeyMap.CollectionKeyMode collectionKeyMode = map.getCollectionKeyMode();
        boolean flattenDimensions = map.getFlattenDimensions();
        boolean simpleKeysMode = map.getSimpleKeysMode();
        boolean valueBasedEquality = map.getValueBasedEquality();
        boolean caseSensitive = map.getCaseSensitive();
        StringBuilder config = new StringBuilder();
        config.append(capacity).append('/');
        config.append(loadFactor).append('/');
        switch (collectionKeyMode) {
            case COLLECTIONS_EXPANDED: {
                modeCode = "EXP";
                break;
            }
            case COLLECTIONS_NOT_EXPANDED: {
                modeCode = "NOEXP";
                break;
            }
            default: {
                modeCode = "EXP";
            }
        }
        config.append(modeCode).append('/');
        config.append(flattenDimensions ? "T" : "F").append('/');
        config.append(simpleKeysMode ? "T" : "F").append('/');
        config.append(valueBasedEquality ? "T" : "F").append('/');
        config.append(caseSensitive ? "T" : "F");
        context.writeFieldName("config");
        context.writeValue(config.toString());
        context.writeArrayFieldStart("entries");
        for (Map.Entry entry : map.entrySet()) {
            context.writeStartObject();
            context.writeFieldName("keys");
            context.writeImpl(entry.getKey(), showType);
            context.writeObjectField("value", entry.getValue());
            context.writeEndObject();
        }
        context.writeEndArray();
    }

    @Override
    public String getTypeName(Object o) {
        return "com.cedarsoftware.util.MultiKeyMap";
    }
}

