/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io.factory;

import com.cedarsoftware.io.ClassFactory;
import com.cedarsoftware.io.JsonIoException;
import com.cedarsoftware.io.JsonObject;
import com.cedarsoftware.io.Resolver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class SynchronizedFactory
implements ClassFactory {
    @Override
    public Object newInstance(Class<?> c, JsonObject jObj, Resolver resolver) {
        if (NavigableSet.class.isAssignableFrom(c)) {
            return Collections.synchronizedNavigableSet(new TreeSet());
        }
        if (SortedSet.class.isAssignableFrom(c)) {
            return Collections.synchronizedSortedSet(new TreeSet());
        }
        if (Set.class.isAssignableFrom(c)) {
            return Collections.synchronizedSet(new LinkedHashSet());
        }
        if (List.class.isAssignableFrom(c)) {
            return Collections.synchronizedList(new ArrayList());
        }
        if (Collection.class.isAssignableFrom(c)) {
            return Collections.synchronizedCollection(new ArrayList());
        }
        if (NavigableMap.class.isAssignableFrom(c)) {
            return Collections.synchronizedNavigableMap(new TreeMap());
        }
        if (SortedMap.class.isAssignableFrom(c)) {
            return Collections.synchronizedSortedMap(new TreeMap());
        }
        if (Map.class.isAssignableFrom(c)) {
            return Collections.synchronizedMap(new LinkedHashMap());
        }
        throw new JsonIoException("SynchronizedFactory handed Class for which it was not expecting: " + c.getName());
    }
}

