/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io;

import com.cedarsoftware.io.JsonIoException;
import com.cedarsoftware.io.JsonObject;
import com.cedarsoftware.io.JsonParser;
import com.cedarsoftware.io.JsonWriter;
import com.cedarsoftware.io.MapResolver;
import com.cedarsoftware.io.ObjectResolver;
import com.cedarsoftware.io.ReadOptions;
import com.cedarsoftware.io.ReadOptionsBuilder;
import com.cedarsoftware.io.Resolver;
import com.cedarsoftware.io.TypeHolder;
import com.cedarsoftware.io.WriteOptions;
import com.cedarsoftware.io.WriteOptionsBuilder;
import com.cedarsoftware.io.prettyprint.JsonPrettyPrinter;
import com.cedarsoftware.util.ClassUtilities;
import com.cedarsoftware.util.Convention;
import com.cedarsoftware.util.FastByteArrayOutputStream;
import com.cedarsoftware.util.FastReader;
import com.cedarsoftware.util.IOUtilities;
import com.cedarsoftware.util.LoggingConfig;
import com.cedarsoftware.util.convert.Converter;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;

public class JsonIo {
    private static final Logger LOG = Logger.getLogger(JsonIo.class.getName());
    private static final Map<ReadOptions, ReadOptions> MAP_OPTIONS_CACHE;

    private JsonIo() {
    }

    private static Resolver createResolver(ReadOptions readOptions) {
        Resolver.DefaultReferenceTracker references = new Resolver.DefaultReferenceTracker(readOptions);
        Converter converter = new Converter(readOptions.getConverterOptions());
        return readOptions.isReturningJsonObjects() ? new MapResolver(readOptions, references, converter) : new ObjectResolver(readOptions, references, converter);
    }

    private static ReadOptions getMapOptions(ReadOptions readOptions) {
        ReadOptions cacheKey = readOptions != null ? readOptions : ReadOptionsBuilder.getDefaultReadOptions();
        return MAP_OPTIONS_CACHE.computeIfAbsent(cacheKey, opts -> new ReadOptionsBuilder(readOptions).returnAsJsonObjects().build());
    }

    public static String toJson(Object srcObject, WriteOptions writeOptions) {
        FastByteArrayOutputStream out = new FastByteArrayOutputStream(8192);
        JsonWriter writer = new JsonWriter((OutputStream)out, writeOptions);
        try {
            writer.write(srcObject);
            String string = out.toString();
            writer.close();
            return string;
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (JsonIoException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JsonIoException("Unable to convert object to JSON", e);
            }
        }
    }

    public static void toJson(OutputStream out, Object source, WriteOptions writeOptions) {
        Convention.throwIfNull((Object)out, (String)"OutputStream cannot be null");
        if (writeOptions == null) {
            writeOptions = WriteOptionsBuilder.getDefaultWriteOptions();
        }
        JsonWriter writer = null;
        try {
            writer = new JsonWriter(out, writeOptions);
            writer.write(source);
        }
        catch (Exception e) {
            if (e instanceof JsonIoException) {
                throw (JsonIoException)e;
            }
            throw new JsonIoException("Unable to convert object and send in JSON format to OutputStream.", e);
        }
        finally {
            if (writeOptions.isCloseStream() && writer != null) {
                try {
                    writer.close();
                }
                catch (Exception closeException) {
                    Logger.getLogger(JsonIo.class.getName()).warning("Failed to close JsonWriter: " + closeException.getMessage());
                }
            }
        }
    }

    public static JavaStringBuilder toMaps(String json) {
        return JsonIo.toMaps(json, null);
    }

    public static JavaStringBuilder toMaps(String json, ReadOptions readOptions) {
        return new JavaStringBuilder(json, JsonIo.getMapOptions(readOptions));
    }

    public static JavaStreamBuilder toMaps(InputStream in) {
        return JsonIo.toMaps(in, null);
    }

    public static JavaStreamBuilder toMaps(InputStream in, ReadOptions readOptions) {
        return new JavaStreamBuilder(in, JsonIo.getMapOptions(readOptions));
    }

    public static JavaStringBuilder toJava(String json, ReadOptions readOptions) {
        return new JavaStringBuilder(json, readOptions);
    }

    public static JavaStreamBuilder toJava(InputStream in, ReadOptions readOptions) {
        return new JavaStreamBuilder(in, readOptions);
    }

    public static JavaObjectBuilder toJava(JsonObject jsonObject, ReadOptions readOptions) {
        return new JavaObjectBuilder(jsonObject, readOptions);
    }

    public static String formatJson(String json) {
        return JsonPrettyPrinter.prettyPrint(json);
    }

    public static <T> T deepCopy(T source, ReadOptions readOptions, WriteOptions writeOptions) {
        if (source == null) {
            return null;
        }
        writeOptions = new WriteOptionsBuilder(writeOptions).showTypeInfoMinimal().shortMetaKeys(true).json5().build();
        if (readOptions == null) {
            readOptions = ReadOptionsBuilder.getDefaultReadOptions();
        }
        String json = JsonIo.toJson(source, writeOptions);
        Class<?> clazz = source.getClass();
        return (T)JsonIo.toJava(json, readOptions).asClass(clazz);
    }

    @Deprecated
    public static <T> T toObjects(String json, ReadOptions readOptions, Class<T> rootType) {
        return JsonIo.toJava(json, readOptions).asClass(rootType);
    }

    @Deprecated
    public static <T> T toObjects(InputStream in, ReadOptions readOptions, Class<T> rootType) {
        return JsonIo.toJava(in, readOptions).asClass(rootType);
    }

    @Deprecated
    public static <T> T toObjects(JsonObject jsonObject, ReadOptions readOptions, Class<T> rootType) {
        return JsonIo.toJava(jsonObject, readOptions).asClass(rootType);
    }

    public static void main(String[] args) {
        String json = JsonIo.toJson(Converter.getSupportedConversions(), new WriteOptionsBuilder().prettyPrint(true).showTypeInfoNever().build());
        LOG.info("json-io supported conversions (source type to target types):");
        LOG.info(json);
    }

    static {
        LoggingConfig.init();
        MAP_OPTIONS_CACHE = new ConcurrentHashMap<ReadOptions, ReadOptions>();
    }

    public static final class JavaStringBuilder {
        private final String json;
        private final ReadOptions readOptions;

        JavaStringBuilder(String json, ReadOptions readOptions) {
            this.json = json != null ? json : "";
            this.readOptions = readOptions != null ? readOptions : ReadOptionsBuilder.getDefaultReadOptions();
        }

        public <T> T asClass(Class<T> clazz) {
            return this.asType(TypeHolder.forClass(clazz));
        }

        public <T> T asType(TypeHolder<T> typeHolder) {
            try {
                return this.parseJson(typeHolder);
            }
            catch (JsonIoException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JsonIoException(e);
            }
        }

        private <T> T parseJson(TypeHolder<T> typeHolder) {
            Object parsed;
            FastReader input = new FastReader((Reader)new StringReader(this.json), 65536, 16);
            Resolver resolver = JsonIo.createResolver(this.readOptions);
            JsonParser parser = new JsonParser(input, resolver);
            try {
                parsed = parser.readValue(typeHolder.getType());
            }
            catch (JsonIoException e) {
                throw e;
            }
            catch (Exception e) {
                throw new JsonIoException("Error parsing JSON value", e);
            }
            boolean shouldManageUnsafe = this.readOptions.isUseUnsafe();
            if (shouldManageUnsafe) {
                ClassUtilities.setUseUnsafe((boolean)true);
            }
            try {
                Object object = resolver.toJava(typeHolder.getType(), parsed);
                return (T)object;
            }
            catch (Exception e) {
                if (e instanceof JsonIoException) {
                    throw (JsonIoException)e;
                }
                throw new JsonIoException(e.getMessage(), e);
            }
            finally {
                if (shouldManageUnsafe) {
                    ClassUtilities.setUseUnsafe((boolean)false);
                }
                resolver.cleanup();
            }
        }
    }

    public static final class JavaStreamBuilder {
        private final InputStream in;
        private final ReadOptions readOptions;

        JavaStreamBuilder(InputStream in, ReadOptions readOptions) {
            Convention.throwIfNull((Object)in, (String)"InputStream cannot be null");
            this.in = in;
            this.readOptions = readOptions != null ? readOptions : ReadOptionsBuilder.getDefaultReadOptions();
        }

        public <T> T asClass(Class<T> clazz) {
            return this.asType(TypeHolder.forClass(clazz));
        }

        public <T> T asType(TypeHolder<T> typeHolder) {
            Object parsed;
            FastReader input = new FastReader((Reader)new InputStreamReader(this.in, StandardCharsets.UTF_8), 65536, 16);
            Resolver resolver = JsonIo.createResolver(this.readOptions);
            JsonParser parser = new JsonParser(input, resolver);
            try {
                parsed = parser.readValue(typeHolder.getType());
            }
            catch (JsonIoException e) {
                throw e;
            }
            catch (Exception e) {
                throw new JsonIoException("Error parsing JSON value", e);
            }
            boolean shouldManageUnsafe = this.readOptions.isUseUnsafe();
            if (shouldManageUnsafe) {
                ClassUtilities.setUseUnsafe((boolean)true);
            }
            try {
                Object object = resolver.toJava(typeHolder.getType(), parsed);
                return (T)object;
            }
            catch (Exception e) {
                if (e instanceof JsonIoException) {
                    throw (JsonIoException)e;
                }
                throw new JsonIoException(e.getMessage(), e);
            }
            finally {
                if (shouldManageUnsafe) {
                    ClassUtilities.setUseUnsafe((boolean)false);
                }
                resolver.cleanup();
                if (this.readOptions.isCloseStream()) {
                    IOUtilities.close((Closeable)input);
                }
            }
        }
    }

    public static final class JavaObjectBuilder {
        private final JsonObject jsonObject;
        private final ReadOptions readOptions;

        JavaObjectBuilder(JsonObject jsonObject, ReadOptions readOptions) {
            Convention.throwIfNull((Object)jsonObject, (String)"JsonObject cannot be null");
            this.jsonObject = jsonObject;
            this.readOptions = readOptions != null ? readOptions : ReadOptionsBuilder.getDefaultReadOptions();
        }

        public <T> T asClass(Class<T> clazz) {
            return this.asType(TypeHolder.forClass(clazz));
        }

        public <T> T asType(TypeHolder<T> typeHolder) {
            ReadOptions effectiveOptions = this.readOptions;
            if (!effectiveOptions.isReturningJavaObjects()) {
                effectiveOptions = new ReadOptionsBuilder(effectiveOptions).returnAsJavaObjects().build();
            }
            Resolver resolver = JsonIo.createResolver(effectiveOptions);
            boolean shouldManageUnsafe = effectiveOptions.isUseUnsafe();
            if (shouldManageUnsafe) {
                ClassUtilities.setUseUnsafe((boolean)true);
            }
            try {
                Object object = resolver.toJava(typeHolder.getType(), this.jsonObject);
                return (T)object;
            }
            catch (Exception e) {
                if (e instanceof JsonIoException) {
                    throw (JsonIoException)e;
                }
                throw new JsonIoException(e.getMessage(), e);
            }
            finally {
                if (shouldManageUnsafe) {
                    ClassUtilities.setUseUnsafe((boolean)false);
                }
                resolver.cleanup();
            }
        }
    }
}

