/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io;

import com.cedarsoftware.io.JsonIoException;
import com.cedarsoftware.io.JsonObject;
import com.cedarsoftware.io.JsonReader;
import com.cedarsoftware.io.JsonWriter;
import com.cedarsoftware.io.ReadOptions;
import com.cedarsoftware.io.ReadOptionsBuilder;
import com.cedarsoftware.io.TypeHolder;
import com.cedarsoftware.io.WriteOptions;
import com.cedarsoftware.io.WriteOptionsBuilder;
import com.cedarsoftware.io.prettyprint.JsonPrettyPrinter;
import com.cedarsoftware.util.Convention;
import com.cedarsoftware.util.FastByteArrayOutputStream;
import com.cedarsoftware.util.LoggingConfig;
import com.cedarsoftware.util.convert.Converter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;

public class JsonIo {
    private static final Logger LOG = Logger.getLogger(JsonIo.class.getName());
    private static final Map<ReadOptions, ReadOptions> MAP_OPTIONS_CACHE;

    private JsonIo() {
    }

    public static String toJson(Object srcObject, WriteOptions writeOptions) {
        FastByteArrayOutputStream out = new FastByteArrayOutputStream(4096);
        JsonWriter writer = new JsonWriter((OutputStream)out, writeOptions);
        try {
            writer.write(srcObject);
            String string = out.toString();
            writer.close();
            return string;
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (JsonIoException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JsonIoException("Unable to convert object to JSON", e);
            }
        }
    }

    public static void toJson(OutputStream out, Object source, WriteOptions writeOptions) {
        Convention.throwIfNull((Object)out, (String)"OutputStream cannot be null");
        if (writeOptions == null) {
            writeOptions = WriteOptionsBuilder.getDefaultWriteOptions();
        }
        JsonWriter writer = null;
        try {
            writer = new JsonWriter(out, writeOptions);
            writer.write(source);
        }
        catch (Exception e) {
            if (e instanceof JsonIoException) {
                throw (JsonIoException)e;
            }
            throw new JsonIoException("Unable to convert object and send in JSON format to OutputStream.", e);
        }
        finally {
            if (writeOptions.isCloseStream() && writer != null) {
                try {
                    writer.close();
                }
                catch (Exception closeException) {
                    Logger.getLogger(JsonIo.class.getName()).warning("Failed to close JsonWriter: " + closeException.getMessage());
                }
            }
        }
    }

    public static JavaStringBuilder toMaps(String json) {
        return JsonIo.toMaps(json, null);
    }

    public static JavaStringBuilder toMaps(String json, ReadOptions readOptions) {
        ReadOptions cacheKey = readOptions != null ? readOptions : ReadOptionsBuilder.getDefaultReadOptions();
        ReadOptions mapOptions = MAP_OPTIONS_CACHE.computeIfAbsent(cacheKey, opts -> new ReadOptionsBuilder(readOptions).returnAsJsonObjects().build());
        return new JavaStringBuilder(json, mapOptions);
    }

    public static JavaStreamBuilder toMaps(InputStream in) {
        return JsonIo.toMaps(in, null);
    }

    public static JavaStreamBuilder toMaps(InputStream in, ReadOptions readOptions) {
        ReadOptions cacheKey = readOptions != null ? readOptions : ReadOptionsBuilder.getDefaultReadOptions();
        ReadOptions mapOptions = MAP_OPTIONS_CACHE.computeIfAbsent(cacheKey, opts -> new ReadOptionsBuilder(readOptions).returnAsJsonObjects().build());
        return new JavaStreamBuilder(in, mapOptions);
    }

    public static JavaStringBuilder toJava(String json, ReadOptions readOptions) {
        return new JavaStringBuilder(json, readOptions);
    }

    public static JavaStreamBuilder toJava(InputStream in, ReadOptions readOptions) {
        return new JavaStreamBuilder(in, readOptions);
    }

    public static JavaObjectBuilder toJava(JsonObject jsonObject, ReadOptions readOptions) {
        return new JavaObjectBuilder(jsonObject, readOptions);
    }

    public static String formatJson(String json) {
        return JsonPrettyPrinter.prettyPrint(json);
    }

    public static <T> T deepCopy(T source, ReadOptions readOptions, WriteOptions writeOptions) {
        if (source == null) {
            return null;
        }
        writeOptions = new WriteOptionsBuilder(writeOptions).showTypeInfoMinimal().shortMetaKeys(true).build();
        if (readOptions == null) {
            readOptions = ReadOptionsBuilder.getDefaultReadOptions();
        }
        String json = JsonIo.toJson(source, writeOptions);
        Class<?> clazz = source.getClass();
        return (T)JsonIo.toJava(json, readOptions).asClass(clazz);
    }

    @Deprecated
    public static <T> T toObjects(String json, ReadOptions readOptions, Class<T> rootType) {
        return JsonIo.toJava(json, readOptions).asClass(rootType);
    }

    @Deprecated
    public static <T> T toObjects(InputStream in, ReadOptions readOptions, Class<T> rootType) {
        return JsonIo.toJava(in, readOptions).asClass(rootType);
    }

    @Deprecated
    public static <T> T toObjects(JsonObject jsonObject, ReadOptions readOptions, Class<T> rootType) {
        return JsonIo.toJava(jsonObject, readOptions).asClass(rootType);
    }

    public static void main(String[] args) {
        String json = JsonIo.toJson(Converter.getSupportedConversions(), new WriteOptionsBuilder().prettyPrint(true).showTypeInfoNever().build());
        LOG.info("json-io supported conversions (source type to target types):");
        LOG.info(json);
    }

    static {
        LoggingConfig.init();
        MAP_OPTIONS_CACHE = new ConcurrentHashMap<ReadOptions, ReadOptions>();
    }

    public static final class JavaStringBuilder {
        private final String json;
        private final ReadOptions readOptions;

        JavaStringBuilder(String json, ReadOptions readOptions) {
            this.json = json != null ? json : "";
            this.readOptions = readOptions != null ? readOptions : ReadOptionsBuilder.getDefaultReadOptions();
        }

        public <T> T asClass(Class<T> clazz) {
            return this.asType(TypeHolder.forClass(clazz));
        }

        public <T> T asType(TypeHolder<T> typeHolder) {
            try {
                return this.parseJson(typeHolder);
            }
            catch (JsonIoException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JsonIoException(e);
            }
        }

        private <T> T parseJson(TypeHolder<T> typeHolder) {
            StringReader reader = new StringReader(this.json);
            JsonReader jr = new JsonReader(reader, this.readOptions);
            Object root = jr.readObject(typeHolder.getType());
            if (this.readOptions.isCloseStream()) {
                jr.close();
            }
            return root;
        }
    }

    public static final class JavaStreamBuilder {
        private final InputStream in;
        private final ReadOptions readOptions;

        JavaStreamBuilder(InputStream in, ReadOptions readOptions) {
            Convention.throwIfNull((Object)in, (String)"InputStream cannot be null");
            this.in = in;
            this.readOptions = readOptions != null ? readOptions : ReadOptionsBuilder.getDefaultReadOptions();
        }

        public <T> T asClass(Class<T> clazz) {
            return this.asType(TypeHolder.forClass(clazz));
        }

        public <T> T asType(TypeHolder<T> typeHolder) {
            JsonReader jr = null;
            try {
                jr = new JsonReader(this.in, this.readOptions);
                Object t = jr.readObject(typeHolder.getType());
                return t;
            }
            catch (JsonIoException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JsonIoException(e);
            }
            finally {
                if (jr != null && this.readOptions.isCloseStream()) {
                    try {
                        jr.close();
                    }
                    catch (Exception closeException) {
                        Logger.getLogger(JsonIo.class.getName()).warning("Failed to close JsonReader: " + closeException.getMessage());
                    }
                }
            }
        }
    }

    public static final class JavaObjectBuilder {
        private final JsonObject jsonObject;
        private final ReadOptions readOptions;

        JavaObjectBuilder(JsonObject jsonObject, ReadOptions readOptions) {
            Convention.throwIfNull((Object)jsonObject, (String)"JsonObject cannot be null");
            this.jsonObject = jsonObject;
            this.readOptions = readOptions != null ? readOptions : ReadOptionsBuilder.getDefaultReadOptions();
        }

        public <T> T asClass(Class<T> clazz) {
            return this.asType(TypeHolder.forClass(clazz));
        }

        public <T> T asType(TypeHolder<T> typeHolder) {
            ReadOptions effectiveOptions = this.readOptions;
            if (!effectiveOptions.isReturningJavaObjects()) {
                effectiveOptions = new ReadOptionsBuilder(effectiveOptions).returnAsJavaObjects().build();
            }
            JsonReader reader = new JsonReader(effectiveOptions);
            return reader.resolveObjects(this.jsonObject, typeHolder.getType());
        }
    }
}

