/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io;

import java.util.HashSet;
import java.util.Set;

public class Primitives {
    private static final Set<Class<?>> PRIMITIVE_WRAPPERS = new HashSet();
    private static final Set<Class<?>> NATIVE_JSON_TYPES = new HashSet();

    private Primitives() {
    }

    public static boolean isPrimitive(Class<?> c) {
        return c.isPrimitive() || PRIMITIVE_WRAPPERS.contains(c);
    }

    public static boolean isNativeJsonType(Class<?> c) {
        return NATIVE_JSON_TYPES.contains(c);
    }

    static {
        PRIMITIVE_WRAPPERS.add(Byte.class);
        PRIMITIVE_WRAPPERS.add(Integer.class);
        PRIMITIVE_WRAPPERS.add(Long.class);
        PRIMITIVE_WRAPPERS.add(Double.class);
        PRIMITIVE_WRAPPERS.add(Character.class);
        PRIMITIVE_WRAPPERS.add(Float.class);
        PRIMITIVE_WRAPPERS.add(Boolean.class);
        PRIMITIVE_WRAPPERS.add(Short.class);
        NATIVE_JSON_TYPES.add(Long.class);
        NATIVE_JSON_TYPES.add(Long.TYPE);
        NATIVE_JSON_TYPES.add(Double.class);
        NATIVE_JSON_TYPES.add(Double.TYPE);
        NATIVE_JSON_TYPES.add(String.class);
        NATIVE_JSON_TYPES.add(Boolean.class);
        NATIVE_JSON_TYPES.add(Boolean.TYPE);
        NATIVE_JSON_TYPES.add(Object[].class);
    }
}

