/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io.util;

import com.cedarsoftware.util.ConcurrentSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

public class SealableSet<T>
implements Set<T> {
    private final Set<T> set;
    private final transient Supplier<Boolean> sealedSupplier;

    public SealableSet(Supplier<Boolean> sealedSupplier) {
        this.sealedSupplier = sealedSupplier;
        this.set = new ConcurrentSet();
    }

    public SealableSet(Collection<T> col, Supplier<Boolean> sealedSupplier) {
        this.sealedSupplier = sealedSupplier;
        this.set = new ConcurrentSet();
        this.set.addAll(col);
    }

    public SealableSet(Set<T> set, Supplier<Boolean> sealedSupplier) {
        this.sealedSupplier = sealedSupplier;
        this.set = set;
    }

    private void throwIfSealed() {
        if (this.sealedSupplier.get().booleanValue()) {
            throw new UnsupportedOperationException("This set has been sealed and is now immutable");
        }
    }

    @Override
    public boolean equals(Object o) {
        return this.set.equals(o);
    }

    @Override
    public int hashCode() {
        return this.set.hashCode();
    }

    public String toString() {
        return this.set.toString();
    }

    @Override
    public int size() {
        return this.set.size();
    }

    @Override
    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.set.contains(o);
    }

    @Override
    public Object[] toArray() {
        return this.set.toArray();
    }

    @Override
    public <T1> T1[] toArray(T1[] a) {
        return this.set.toArray(a);
    }

    @Override
    public boolean containsAll(Collection<?> col) {
        return this.set.containsAll(col);
    }

    @Override
    public boolean add(T t) {
        this.throwIfSealed();
        return this.set.add(t);
    }

    @Override
    public boolean remove(Object o) {
        this.throwIfSealed();
        return this.set.remove(o);
    }

    @Override
    public boolean addAll(Collection<? extends T> col) {
        this.throwIfSealed();
        return this.set.addAll(col);
    }

    @Override
    public boolean removeAll(Collection<?> col) {
        this.throwIfSealed();
        return this.set.removeAll(col);
    }

    @Override
    public boolean retainAll(Collection<?> col) {
        this.throwIfSealed();
        return this.set.retainAll(col);
    }

    @Override
    public void clear() {
        this.throwIfSealed();
        this.set.clear();
    }

    @Override
    public Iterator<T> iterator() {
        final Iterator<T> iterator = this.set.iterator();
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public T next() {
                Object item = iterator.next();
                if (item instanceof Map.Entry) {
                    Map.Entry entry = (Map.Entry)item;
                    return new SealAwareEntry(entry, SealableSet.this.sealedSupplier);
                }
                return item;
            }

            @Override
            public void remove() {
                SealableSet.this.throwIfSealed();
                iterator.remove();
            }
        };
    }

    static class SealAwareEntry<K, V>
    implements Map.Entry<K, V> {
        private final Map.Entry<K, V> entry;
        private final Supplier<Boolean> sealedSupplier;

        SealAwareEntry(Map.Entry<K, V> entry, Supplier<Boolean> sealedSupplier) {
            this.entry = entry;
            this.sealedSupplier = sealedSupplier;
        }

        @Override
        public K getKey() {
            return this.entry.getKey();
        }

        @Override
        public V getValue() {
            return this.entry.getValue();
        }

        @Override
        public V setValue(V value) {
            if (this.sealedSupplier.get().booleanValue()) {
                throw new UnsupportedOperationException("Cannot modify, set is sealed");
            }
            return this.entry.setValue(value);
        }

        @Override
        public boolean equals(Object o) {
            return this.entry.equals(o);
        }

        @Override
        public int hashCode() {
            return this.entry.hashCode();
        }
    }
}

