/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io.writers;

import com.cedarsoftware.io.JsonWriter;
import com.cedarsoftware.io.WriterContext;
import com.cedarsoftware.util.CompactMap;
import com.cedarsoftware.util.ReflectionUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.Set;

public class CompactMapWriter
implements JsonWriter.JsonClassWriter {
    public void write(Object obj, boolean showType, Writer output, WriterContext context) throws IOException {
        String orderCode;
        String mapImplClass;
        CompactMap map = (CompactMap)obj;
        boolean caseSensitive = (Boolean)ReflectionUtils.call((Object)map, (String)"isCaseInsensitive", (Object[])new Object[0]) == false;
        int compactSize = (Integer)ReflectionUtils.call((Object)map, (String)"compactSize", (Object[])new Object[0]);
        String ordering = (String)ReflectionUtils.call((Object)map, (String)"getOrdering", (Object[])new Object[0]);
        String singleKey = (String)ReflectionUtils.call((Object)map, (String)"getSingleValueKey", (Object[])new Object[0]);
        try {
            Map newMap = (Map)ReflectionUtils.call((Object)map, (String)"getNewMap", (Object[])new Object[0]);
            mapImplClass = newMap.getClass().getName();
        }
        catch (Exception e) {
            mapImplClass = "java.util.HashMap";
        }
        StringBuilder config = new StringBuilder();
        config.append(mapImplClass).append('/');
        config.append(caseSensitive ? "CS" : "CI").append('/');
        config.append('S').append(compactSize).append('/');
        config.append(singleKey == null ? "-" : singleKey).append('/');
        switch (ordering) {
            case "sorted": {
                orderCode = "Sort";
                break;
            }
            case "reverse": {
                orderCode = "Rev";
                break;
            }
            case "insertion": {
                orderCode = "Ins";
                break;
            }
            default: {
                orderCode = "Unord";
            }
        }
        config.append(orderCode);
        output.write("\"config\":\"" + config + "\",");
        output.write("\"data\":{");
        boolean allStringKeys = true;
        if (!context.getWriteOptions().isForceMapOutputAsTwoArrays()) {
            Set entries = map.entrySet();
            for (Map.Entry entry : entries) {
                if (entry.getKey() instanceof String) continue;
                allStringKeys = false;
                break;
            }
        } else {
            allStringKeys = false;
        }
        if (allStringKeys) {
            boolean first = true;
            for (Map.Entry entry : map.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    output.write(44);
                }
                String key = (String)entry.getKey();
                JsonWriter.writeJsonUtf8String(output, key);
                output.write(58);
                context.writeImpl(entry.getValue(), showType);
            }
        } else {
            Set entries = map.entrySet();
            int size = entries.size();
            Object[] keys = new Object[size];
            Object[] values = new Object[size];
            int i = 0;
            for (Map.Entry entry : entries) {
                keys[i] = entry.getKey();
                values[i] = entry.getValue();
                ++i;
            }
            output.write("\"@keys\":");
            context.writeImpl(keys, showType);
            output.write(",\"@items\":");
            context.writeImpl(values, showType);
        }
        output.write("}");
    }

    @Override
    public String getTypeName(Object o) {
        return CompactMap.class.getName();
    }
}

