/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class SingletonMap<K, V>
implements Map<K, V> {
    private static final Object UNINITIALIZED = new Object();
    private K key = UNINITIALIZED;
    private V value = UNINITIALIZED;

    public SingletonMap(K key, V value) {
        this.key = key == null ? UNINITIALIZED : key;
        this.value = value == null ? UNINITIALIZED : value;
    }

    public SingletonMap() {
    }

    @Override
    public int size() {
        return this.key == UNINITIALIZED ? 0 : 1;
    }

    @Override
    public boolean isEmpty() {
        return this.key == UNINITIALIZED;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.key != UNINITIALIZED && this.key.equals(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.value != UNINITIALIZED && this.value.equals(value);
    }

    @Override
    public V get(Object key) {
        return this.containsKey(key) ? (V)this.value : null;
    }

    @Override
    public V put(K key, V value) {
        if (this.key == UNINITIALIZED) {
            this.key = key;
            this.value = value;
            return null;
        }
        if (this.key.equals(key)) {
            V oldValue = this.value;
            this.value = value;
            return oldValue;
        }
        throw new UnsupportedOperationException("Cannot add more than one item to a SingletonMap");
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException("Cannot remove item from SingletonMap");
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        throw new UnsupportedOperationException("Cannot add items to SingletonMap");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Cannot clear SingletonMap");
    }

    @Override
    public Set<K> keySet() {
        return this.key == UNINITIALIZED ? Collections.emptySet() : Collections.singleton(this.key);
    }

    @Override
    public Collection<V> values() {
        return this.key == UNINITIALIZED ? Collections.emptyList() : Collections.singletonList(this.value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.key == UNINITIALIZED) {
            return Collections.emptySet();
        }
        return Collections.singleton(new Map.Entry<K, V>(){

            @Override
            public K getKey() {
                return SingletonMap.this.key;
            }

            @Override
            public V getValue() {
                return SingletonMap.this.value;
            }

            @Override
            public V setValue(V value) {
                Object oldVal = SingletonMap.this.value;
                SingletonMap.this.value = value;
                return oldVal;
            }
        });
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        return this.size() == m.size() && (this.key == UNINITIALIZED || m.containsKey(this.key) && m.get(this.key).equals(this.value));
    }

    @Override
    public int hashCode() {
        return this.key == UNINITIALIZED ? 0 : this.key.hashCode() ^ (this.value == null ? 0 : this.value.hashCode());
    }
}

