/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io;

import com.cedarsoftware.io.JsonIoException;
import com.cedarsoftware.io.JsonValue;
import java.lang.reflect.Array;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;

public class JsonObject
extends JsonValue
implements Map<Object, Object> {
    private final Map<Object, Object> jsonStore = new LinkedHashMap<Object, Object>();
    private Integer hash = null;
    private static volatile int linearSearchThreshold = 8;
    private Object[] items;
    private Object[] keys;
    private String typeString;
    private final CacheState cache = new CacheState();

    private int getKeysLength() {
        if (this.keys == null) {
            return 0;
        }
        if (this.cache.keysLength == null) {
            this.cache.keysLength = this.keys.length;
        }
        return this.cache.keysLength;
    }

    private int getItemsLength() {
        if (this.items == null) {
            return 0;
        }
        if (this.cache.itemsLength == null) {
            this.cache.itemsLength = Array.getLength(this.items);
        }
        return this.cache.itemsLength;
    }

    public String toString() {
        String jType = this.typeString != null ? this.typeString : (this.type == null ? "not set" : this.type.getTypeName());
        String targetInfo = this.target == null ? "null" : jType;
        return "JsonObject(id:" + this.id + ", type:" + jType + ", target:" + targetInfo + ", line:" + this.line + ", col:" + this.col + ", size:" + this.size() + ")";
    }

    public boolean isMap() {
        return this.target instanceof Map || this.type != null && Map.class.isAssignableFrom(this.getRawType());
    }

    public boolean isCollection() {
        if (this.target instanceof Collection) {
            return true;
        }
        if (this.isMap()) {
            return false;
        }
        if (this.items != null && this.keys == null) {
            Class<?> type = this.getRawType();
            return type != null && !type.isArray();
        }
        return false;
    }

    @Override
    public boolean isArray() {
        if (this.target == null) {
            if (this.type != null) {
                return this.getRawType().isArray();
            }
            return this.items != null && this.keys == null;
        }
        return this.target.getClass().isArray();
    }

    public Object[] getItems() {
        return this.items;
    }

    public void setItems(Object[] array) {
        if (array == null) {
            throw new JsonIoException("Argument array cannot be null");
        }
        this.items = array;
        this.hash = null;
        this.cache.clear();
    }

    public Object[] getKeys() {
        return this.keys;
    }

    void setKeys(Object[] keys) {
        if (keys == null) {
            throw new JsonIoException("Argument 'keys' cannot be null");
        }
        this.keys = keys;
        this.hash = null;
        this.cache.clear();
    }

    public String getTypeString() {
        return this.typeString;
    }

    void setTypeString(String typeString) {
        this.typeString = typeString;
    }

    @Override
    public int size() {
        if (this.items != null) {
            return this.getItemsLength();
        }
        return this.jsonStore.size();
    }

    @Deprecated
    public int getLength() {
        return this.size();
    }

    public void setValue(Object o) {
        this.jsonStore.put("value", o);
        this.hash = null;
    }

    public Object getValue() {
        return this.jsonStore.get("value");
    }

    public boolean hasValue() {
        return this.size() == 1 && this.jsonStore.containsKey("value");
    }

    @Override
    public int hashCode() {
        if (this.hash == null) {
            int result = 1;
            if (this.keys != null) {
                result = 31 * result + this.fastArrayHashCode(this.keys);
            }
            if (this.items != null) {
                result = 31 * result + this.fastArrayHashCode(this.items);
            }
            if (!this.jsonStore.isEmpty()) {
                result = 31 * result + this.jsonStore.hashCode();
            }
            this.hash = result;
        }
        return this.hash;
    }

    private int fastArrayHashCode(Object[] array) {
        if (array == null) {
            return 1;
        }
        boolean hasNestedArrays = false;
        for (Object item : array) {
            if (item == null || !item.getClass().isArray()) continue;
            hasNestedArrays = true;
            break;
        }
        if (!hasNestedArrays) {
            int result = 1;
            for (Object item : array) {
                result = 31 * result + (item == null ? 0 : item.hashCode());
            }
            return result;
        }
        return this.hashCode(array, new IdentityHashMap<Object, Integer>());
    }

    private int hashCode(Object array, Map<Object, Integer> seen) {
        if (array == null) {
            return 1;
        }
        if (!array.getClass().isArray()) {
            return array.hashCode();
        }
        Integer cachedHash = seen.get(array);
        if (cachedHash != null) {
            return cachedHash;
        }
        seen.put(array, null);
        int result = 1;
        for (Object item : (Object[])array) {
            result = 31 * result + this.hashCode(item, seen);
        }
        seen.put(array, result);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JsonObject)) {
            return false;
        }
        JsonObject other = (JsonObject)obj;
        if (!JsonObject.shallowArrayEquals(this.items, other.items)) {
            return false;
        }
        if (!JsonObject.shallowArrayEquals(this.keys, other.keys)) {
            return false;
        }
        return this.jsonStore.equals(other.jsonStore);
    }

    private static boolean shallowArrayEquals(Object[] arr1, Object[] arr2) {
        int len2;
        if (arr1 == arr2) {
            return true;
        }
        if (arr1 == null || arr2 == null) {
            return false;
        }
        int len1 = Array.getLength(arr1);
        if (len1 != (len2 = Array.getLength(arr2))) {
            return false;
        }
        for (int i = 0; i < len1; ++i) {
            Object e1 = arr1[i];
            Object e2 = arr2[i];
            if (Objects.equals(e1, e2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        if (this.items != null) {
            return this.getItemsLength() == 0;
        }
        return this.jsonStore.isEmpty();
    }

    @Override
    public Object remove(Object key) {
        this.hash = null;
        return this.jsonStore.remove(key);
    }

    @Override
    public Object put(Object key, Object value) {
        this.hash = null;
        return this.jsonStore.put(key, value);
    }

    @Override
    public void putAll(Map<?, ?> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        if (this.keys == null && this.items == null && this.jsonStore instanceof LinkedHashMap && this.jsonStore.isEmpty()) {
            this.hash = null;
            this.jsonStore.putAll(map);
            return;
        }
        this.hash = null;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            this.putInternal(entry.getKey(), entry.getValue());
        }
    }

    private Object putInternal(Object key, Object value) {
        return this.jsonStore.put(key, value);
    }

    @Override
    public void clear() {
        super.clear();
        this.jsonStore.clear();
        this.items = null;
        this.keys = null;
        this.hash = null;
        this.cache.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.keys != null) {
            if (key == null) {
                for (Object k : this.keys) {
                    if (k != null) continue;
                    return true;
                }
                return false;
            }
            int keyLen = this.getKeysLength();
            if (keyLen <= linearSearchThreshold) {
                for (Object k : this.keys) {
                    if (!key.equals(k)) continue;
                    return true;
                }
            } else {
                if (this.isSorted() && key instanceof String) {
                    return this.binarySearch(this.keys, key) >= 0;
                }
                for (Object k : this.keys) {
                    if (!Objects.equals(key, k)) continue;
                    return true;
                }
            }
            return false;
        }
        return this.jsonStore.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        if (this.items != null) {
            if (value == null) {
                for (Object v : this.items) {
                    if (v != null) continue;
                    return true;
                }
                return false;
            }
            int itemLen = this.getItemsLength();
            if (itemLen <= linearSearchThreshold) {
                for (Object v : this.items) {
                    if (!value.equals(v)) continue;
                    return true;
                }
            } else {
                Class<?> valueClass = value.getClass();
                for (Object v : this.items) {
                    if (v == null || v.getClass() != valueClass || !value.equals(v)) continue;
                    return true;
                }
            }
            return false;
        }
        return this.jsonStore.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        if (this.keys != null && this.items != null) {
            int keyLen = this.getKeysLength();
            if (keyLen <= linearSearchThreshold) {
                for (int i = 0; i < keyLen; ++i) {
                    if (!Objects.equals(key, this.keys[i])) continue;
                    return this.items[i];
                }
            } else if (this.isSorted()) {
                int index = this.binarySearch(this.keys, key);
                if (index >= 0) {
                    return this.items[index];
                }
            } else {
                for (int i = 0; i < keyLen; ++i) {
                    if (!Objects.equals(key, this.keys[i])) continue;
                    return this.items[i];
                }
            }
            return null;
        }
        return this.jsonStore.get(key);
    }

    private boolean isSorted() {
        if (this.keys == null) {
            return false;
        }
        if (this.cache.sorted != null) {
            return this.cache.sorted;
        }
        this.cache.sorted = this.calculateSorted();
        return this.cache.sorted;
    }

    private boolean calculateSorted() {
        int keyLen = this.getKeysLength();
        if (keyLen < 2) {
            return true;
        }
        for (Object key : this.keys) {
            if (key instanceof String) continue;
            return false;
        }
        for (int i = 1; i < keyLen; ++i) {
            if (((String)this.keys[i - 1]).compareTo((String)this.keys[i]) <= 0) continue;
            return false;
        }
        return true;
    }

    private int binarySearch(Object[] keys, Object key) {
        if (!(key instanceof String)) {
            return -1;
        }
        String searchKey = (String)key;
        int left = 0;
        int right = this.getKeysLength() - 1;
        while (left <= right) {
            int mid = left + (right - left) / 2;
            int cmp = searchKey.compareTo((String)keys[mid]);
            if (cmp == 0) {
                return mid;
            }
            if (cmp < 0) {
                right = mid - 1;
                continue;
            }
            left = mid + 1;
        }
        return -1;
    }

    @Override
    public Set<Object> keySet() {
        if (this.keys != null) {
            if (this.cache.keySet == null) {
                this.cache.keySet = new LinkedHashSet<Object>(Arrays.asList(this.keys));
            }
            return this.cache.keySet;
        }
        return this.jsonStore.keySet();
    }

    @Override
    public Collection<Object> values() {
        if (this.items != null) {
            if (this.cache.values == null) {
                LinkedHashSet<Object> valueList = new LinkedHashSet<Object>();
                Collections.addAll(valueList, this.items);
                this.cache.values = valueList;
            }
            return this.cache.values;
        }
        return this.jsonStore.values();
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        if (this.keys != null && this.items != null) {
            return new ArrayEntrySet();
        }
        return this.jsonStore.entrySet();
    }

    Map.Entry<Object[], Object[]> asTwoArrays() {
        int itemLen;
        int keyLen;
        if (this.keys == null && this.items == null && !this.isReference()) {
            Object[] newKeys = new Object[this.jsonStore.size()];
            Object[] newValues = new Object[this.jsonStore.size()];
            int i = 0;
            for (Map.Entry<Object, Object> entry : this.jsonStore.entrySet()) {
                newKeys[i] = entry.getKey();
                newValues[i] = entry.getValue();
                ++i;
            }
            this.setKeys(newKeys);
            this.setItems(newValues);
            this.jsonStore.clear();
            return new AbstractMap.SimpleImmutableEntry<Object[], Object[]>(newKeys, newValues);
        }
        if (this.keys == null && this.items != null || this.keys != null && this.items == null) {
            throw new JsonIoException("@keys or @items cannot be empty if the other is not empty");
        }
        if (this.keys != null && this.items != null && (keyLen = this.getKeysLength()) != (itemLen = this.getItemsLength())) {
            throw new JsonIoException("@keys and @items must be same length");
        }
        return new AbstractMap.SimpleImmutableEntry<Object[], Object[]>(this.keys, this.items);
    }

    void rehashMaps() {
        if (this.keys == null || this.items == null) {
            return;
        }
        this.hash = null;
        Map targetMap = null;
        if (this.target instanceof Map) {
            targetMap = (Map)this.target;
        }
        int len = this.getKeysLength();
        for (int i = 0; i < len; ++i) {
            Object key = this.keys[i];
            Object value = this.items[i];
            this.jsonStore.put(key, value);
            if (targetMap == null) continue;
            targetMap.put(key, value);
        }
        this.keys = null;
        this.items = null;
        this.cache.clear();
    }

    public static void setLinearSearchThreshold(int threshold) {
        if (threshold < 1) {
            throw new JsonIoException("Linear search threshold must be at least 1, value: " + threshold);
        }
        linearSearchThreshold = threshold;
    }

    public static int getLinearSearchThreshold() {
        return linearSearchThreshold;
    }

    private static class CacheState {
        Set<Object> keySet;
        Collection<Object> values;
        Boolean sorted;
        Integer keysLength;
        Integer itemsLength;

        private CacheState() {
        }

        void clear() {
            this.keySet = null;
            this.values = null;
            this.sorted = null;
            this.keysLength = null;
            this.itemsLength = null;
        }
    }

    private class ArrayEntrySet
    extends AbstractSet<Map.Entry<Object, Object>> {
        private ArrayEntrySet() {
        }

        @Override
        public int size() {
            return JsonObject.this.keys != null ? JsonObject.this.getKeysLength() : 0;
        }

        @Override
        public boolean isEmpty() {
            return JsonObject.this.keys == null || JsonObject.this.getKeysLength() == 0;
        }

        @Override
        public Iterator<Map.Entry<Object, Object>> iterator() {
            return new ArrayEntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (JsonObject.this.keys != null && JsonObject.this.items != null) {
                int keyLen = JsonObject.this.getKeysLength();
                for (int i = 0; i < keyLen; ++i) {
                    if (!Objects.equals(JsonObject.this.keys[i], key)) continue;
                    return Objects.equals(JsonObject.this.items[i], value);
                }
            }
            return false;
        }
    }

    private class ArrayEntry
    implements Map.Entry<Object, Object> {
        private int index;

        private ArrayEntry() {
        }

        void setIndex(int index) {
            this.index = index;
        }

        @Override
        public Object getKey() {
            return JsonObject.this.keys[this.index];
        }

        @Override
        public Object getValue() {
            return JsonObject.this.items[this.index];
        }

        @Override
        public Object setValue(Object value) {
            Object oldValue = JsonObject.this.items[this.index];
            ((JsonObject)JsonObject.this).items[this.index] = value;
            JsonObject.this.hash = null;
            ((JsonObject)JsonObject.this).cache.values = null;
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return Objects.equals(JsonObject.this.keys[this.index], e.getKey()) && Objects.equals(JsonObject.this.items[this.index], e.getValue());
        }

        @Override
        public int hashCode() {
            return (JsonObject.this.keys[this.index] == null ? 0 : JsonObject.this.keys[this.index].hashCode()) ^ (JsonObject.this.items[this.index] == null ? 0 : JsonObject.this.items[this.index].hashCode());
        }
    }

    private class ArrayEntryIterator
    implements Iterator<Map.Entry<Object, Object>> {
        private int index = 0;
        private final ArrayEntry reusableEntry = new ArrayEntry();

        private ArrayEntryIterator() {
        }

        @Override
        public boolean hasNext() {
            return JsonObject.this.keys != null && this.index < JsonObject.this.getKeysLength();
        }

        @Override
        public Map.Entry<Object, Object> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.reusableEntry.setIndex(this.index++);
            return this.reusableEntry;
        }
    }
}

