/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io.writers;

import com.cedarsoftware.io.JsonWriter;
import com.cedarsoftware.io.WriterContext;
import com.cedarsoftware.util.CompactSet;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;

public class CompactSetWriter
implements JsonWriter.JsonClassWriter {
    @Override
    public void write(Object obj, boolean showType, Writer output, WriterContext context) throws IOException {
        String orderCode;
        CompactSet set = (CompactSet)obj;
        Map config = set.getConfig();
        boolean caseSensitive = (Boolean)config.get("caseSensitive");
        int compactSize = (Integer)config.get("compactSize");
        String ordering = (String)config.get("ordering");
        StringBuilder configStr = new StringBuilder();
        configStr.append(caseSensitive ? "CS" : "CI").append('/');
        configStr.append('S').append(compactSize).append('/');
        switch (ordering) {
            case "sorted": {
                orderCode = "Sort";
                break;
            }
            case "reverse": {
                orderCode = "Rev";
                break;
            }
            case "insertion": {
                orderCode = "Ins";
                break;
            }
            default: {
                orderCode = "Unord";
            }
        }
        configStr.append(orderCode);
        output.write("\"config\":\"" + configStr + "\",");
        output.write("\"data\":");
        output.write(91);
        boolean first = true;
        for (Object element : set) {
            if (first) {
                first = false;
            } else {
                output.write(44);
            }
            context.writeImpl(element, showType);
        }
        output.write(93);
    }

    @Override
    public String getTypeName(Object o) {
        return CompactSet.class.getName();
    }
}

