/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.io;

import com.cedarsoftware.io.JsonIoException;
import com.cedarsoftware.io.JsonObject;
import com.cedarsoftware.io.JsonReader;
import com.cedarsoftware.io.JsonWriter;
import com.cedarsoftware.io.ReadOptions;
import com.cedarsoftware.io.ReadOptionsBuilder;
import com.cedarsoftware.io.TypeHolder;
import com.cedarsoftware.io.WriteOptions;
import com.cedarsoftware.io.WriteOptionsBuilder;
import com.cedarsoftware.io.prettyprint.JsonPrettyPrinter;
import com.cedarsoftware.util.Convention;
import com.cedarsoftware.util.FastByteArrayInputStream;
import com.cedarsoftware.util.FastByteArrayOutputStream;
import com.cedarsoftware.util.convert.Converter;
import com.cedarsoftware.util.convert.ConverterOptions;
import com.cedarsoftware.util.convert.DefaultConverterOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;

public class JsonIo {
    private JsonIo() {
    }

    public static String toJson(Object srcObject, WriteOptions writeOptions) {
        FastByteArrayOutputStream out = new FastByteArrayOutputStream();
        JsonWriter writer = new JsonWriter((OutputStream)out, writeOptions);
        try {
            writer.write(srcObject);
            String string = out.toString();
            writer.close();
            return string;
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (JsonIoException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JsonIoException("Unable to convert object to JSON", e);
            }
        }
    }

    public static void toJson(OutputStream out, Object source, WriteOptions writeOptions) {
        Convention.throwIfNull((Object)out, (String)"OutputStream cannot be null");
        if (writeOptions == null) {
            writeOptions = WriteOptionsBuilder.getDefaultWriteOptions();
        }
        JsonWriter writer = null;
        try {
            writer = new JsonWriter(out, writeOptions);
            writer.write(source);
        }
        catch (Exception e) {
            throw new JsonIoException("Unable to convert object and send in JSON format to OutputStream.", e);
        }
        finally {
            if (writeOptions.isCloseStream() && writer != null) {
                writer.close();
            }
        }
    }

    public static JavaStringBuilder toJava(String json, ReadOptions readOptions) {
        return new JavaStringBuilder(json, readOptions);
    }

    public static JavaStreamBuilder toJava(InputStream in, ReadOptions readOptions) {
        return new JavaStreamBuilder(in, readOptions);
    }

    public static JavaObjectBuilder toJava(JsonObject jsonObject, ReadOptions readOptions) {
        return new JavaObjectBuilder(jsonObject, readOptions);
    }

    public static String formatJson(String json) {
        return JsonPrettyPrinter.prettyPrint(json);
    }

    public static <T> T deepCopy(Object source, ReadOptions readOptions, WriteOptions writeOptions) {
        if (source == null) {
            return null;
        }
        writeOptions = new WriteOptionsBuilder(writeOptions).showTypeInfoMinimal().shortMetaKeys(true).build();
        if (readOptions == null) {
            readOptions = ReadOptionsBuilder.getDefaultReadOptions();
        }
        String json = JsonIo.toJson(source, writeOptions);
        return (T)JsonIo.toJava(json, readOptions).asClass(source.getClass());
    }

    public static <T> T toObjects(String json, ReadOptions readOptions, Class<T> rootType) {
        return JsonIo.toJava(json, readOptions).asClass(rootType);
    }

    public static <T> T toObjects(InputStream in, ReadOptions readOptions, Class<T> rootType) {
        return JsonIo.toJava(in, readOptions).asClass(rootType);
    }

    public static <T> T toObjects(JsonObject jsonObject, ReadOptions readOptions, Class<T> rootType) {
        return JsonIo.toJava(jsonObject, readOptions).asClass(rootType);
    }

    public static void main(String[] args) {
        new Converter((ConverterOptions)new DefaultConverterOptions());
        String json = JsonIo.toJson(Converter.getSupportedConversions(), new WriteOptionsBuilder().prettyPrint(true).showTypeInfoNever().build());
        System.out.println("json-io supported conversions (source type to target types):");
        System.out.println(json);
    }

    public static final class JavaStringBuilder {
        private final String json;
        private final ReadOptions readOptions;

        JavaStringBuilder(String json, ReadOptions readOptions) {
            this.json = json != null ? json : "";
            this.readOptions = readOptions != null ? readOptions : ReadOptionsBuilder.getDefaultReadOptions();
        }

        public <T> T asClass(Class<T> clazz) {
            return this.asType(TypeHolder.forClass(clazz));
        }

        public <T> T asType(TypeHolder<T> typeHolder) {
            try {
                return this.parseJson(typeHolder);
            }
            catch (JsonIoException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JsonIoException(e);
            }
        }

        private <T> T parseJson(TypeHolder<T> typeHolder) throws Exception {
            FastByteArrayInputStream in = new FastByteArrayInputStream(this.json.getBytes(StandardCharsets.UTF_8));
            JsonReader jr = new JsonReader((InputStream)in, this.readOptions);
            Object root = jr.readObject(typeHolder.getType());
            if (this.readOptions.isCloseStream()) {
                jr.close();
            }
            return root;
        }
    }

    public static final class JavaStreamBuilder {
        private final InputStream in;
        private final ReadOptions readOptions;

        JavaStreamBuilder(InputStream in, ReadOptions readOptions) {
            Convention.throwIfNull((Object)in, (String)"InputStream cannot be null");
            this.in = in;
            this.readOptions = readOptions != null ? readOptions : ReadOptionsBuilder.getDefaultReadOptions();
        }

        public <T> T asClass(Class<T> clazz) {
            return this.asType(TypeHolder.forClass(clazz));
        }

        public <T> T asType(TypeHolder<T> typeHolder) {
            JsonReader jr = null;
            try {
                Object root;
                jr = new JsonReader(this.in, this.readOptions);
                Object t = root = jr.readObject(typeHolder.getType());
                return t;
            }
            catch (JsonIoException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JsonIoException(e);
            }
            finally {
                if (jr != null && this.readOptions.isCloseStream()) {
                    jr.close();
                }
            }
        }
    }

    public static final class JavaObjectBuilder {
        private final JsonObject jsonObject;
        private final ReadOptions readOptions;

        JavaObjectBuilder(JsonObject jsonObject, ReadOptions readOptions) {
            Convention.throwIfNull((Object)jsonObject, (String)"JsonObject cannot be null");
            this.jsonObject = jsonObject;
            this.readOptions = readOptions != null ? readOptions : ReadOptionsBuilder.getDefaultReadOptions();
        }

        public <T> T asClass(Class<T> clazz) {
            return this.asType(TypeHolder.forClass(clazz));
        }

        public <T> T asType(TypeHolder<T> typeHolder) {
            ReadOptions effectiveOptions = this.readOptions;
            if (!effectiveOptions.isReturningJavaObjects()) {
                effectiveOptions = new ReadOptionsBuilder(effectiveOptions).returnAsJavaObjects().build();
            }
            JsonReader reader = new JsonReader(effectiveOptions);
            return reader.resolveObjects(this.jsonObject, typeHolder.getType());
        }
    }
}

